/*
    This file is part of libkcal.
    Copyright (c) 1998 Preston Brown
    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

// $Id: vcaldrag.h,v 1.3 2001/09/19 13:09:50 cschumac Exp $

#ifndef VCALDRAG_H
#define VCALDRAG_H

#include <qdragobject.h>

class VObject;

namespace KCal {

/** vCalendar drag&drop class. */
class VCalDrag : public QStoredDrag {
  public:
    /** Create a drag&drop object for vCalendar component \a vcal. */
    VCalDrag(VObject *vcal, QWidget *parent=0, const char *name=0);
    ~VCalDrag() {};

    /** Return, if drag&drop object can be decode to vCalendar. */
    static bool canDecode(QMimeSource *);
    /** Decode drag&drop object to vCalendar component \a vcal. */
    static bool decode(QMimeSource *e, VObject **vcal);
};

}

#endif
