// $Id: kitsystemtray.cpp,v 1.10 2002/01/21 15:27:15 cumming Exp $
//
// Kit
//
// Copyright (C) 1999 Neil Stevens <multivac@fcmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <noatun/app.h>
#include <noatun/player.h>
#include <qdragobject.h> 

#include "kitsystemtray.h"
#include "kmainwindow.h"
#include "kpopupmenu.h"
#include "kxmlgui.h"
#include "kiconloader.h"

KitSystemTray::KitSystemTray(const QString &contextMenu, KMainWindow *parent, const char *name)
	: KSystemTray(parent, name)
{
	setAlignment(AlignHCenter | AlignVCenter);
	menu = (KPopupMenu *)parent->guiFactory()->container(contextMenu, parent); 
	menu->insertTitle(SmallIcon("noatun"), QString::null, 0, 0);
	setAcceptDrops(true);
}

void KitSystemTray::changeTitle(const QPixmap &pixmap, const QString &title)
{
	menu->changeTitle(0, pixmap, title);
}

void KitSystemTray::showEvent(QShowEvent *)
{
	// empty
}

void KitSystemTray::mousePressEvent(QMouseEvent *event)
{
	switch(event->button())
	{
	case LeftButton:
		napp->toggleInterfaces();
		break;
	case MidButton:
		napp->playlist()->toggleList();
		break;
	default:
		menu->popup(event->globalPos());
		break;
	}
}

void KitSystemTray::dragEnterEvent(QDragEnterEvent * event)
{
	// accept uri drops only
	event->accept(QUriDrag::canDecode(event));
}

void KitSystemTray::dropEvent(QDropEvent * event)
{
	QStrList uri;
	if (QUriDrag::decode(event, uri)) {
		for (char *file = uri.first(); file != 0; file = uri.next())
			napp->player()->openFile(KURL(file), false);
	}
}

#include "kitsystemtray.moc"
