/** 
 * Copyright (C) 2000-2002 the KGhostView authors. See file AUTHORS.
 * 	
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __KGV_VIEW_H
#define __KGV_VIEW_H

#include <qcstring.h> // QByteArray
#include <qfile.h>

#include <kio/job.h>
#include <kparts/browserextension.h>
#include <kparts/genericfactory.h>
#include <krun.h>

class QFrame;
class QWidget;

class KAction;
class KActionCollection;
class KDirWatch;
class KInstance;
class KToggleAction;

class KGVBrowserExtension;
class KGVMiniWidget;
class KGVPageView;
class KGVPageDecorator;
class KGVRun;
class KPSWidget;
class MarkList;
class ScrollBox;

class KSelectAction;
class KAboutData;

class KGVPart: public KParts::ReadOnlyPart
{
  Q_OBJECT
public:
    KGVPart( QWidget* parentWidget, const char* widgetName, 
             QObject* parent, const char* name, 
             const QStringList& args = QStringList() );
    
    virtual ~KGVPart();

    KGVMiniWidget*    miniWidget()    const { return _docManager;    }
    MarkList*         markList()      const { return _markList;      }
    KGVPageView*      pageView()      const { return _pageView;      }
    KGVPageDecorator* pageDecorator() const { return _pageDecorator; }

    /**
     * Reimplemented from ReadOnlyPart in order to delete the file from 
     * KDirWatch's list.
     */
    virtual bool closeURL();

    static KAboutData* createAboutData();

public slots:
    /**
     * Reimplemented from ReadOnlyPart so that incoming data can be sent 
     * through the DSC parser immediately on arrival.
     */
    virtual bool openURL( const KURL& );
    virtual void openURLContinue();

    void slotScrollLeft();   
    void slotScrollRight();
    void slotScrollUp();
    void slotScrollDown();
    void slotReadDown();
    void slotReadUp();
    void slotPrevPage();
    void slotNextPage();
    void slotGotoStart();
    void slotGotoEnd();
    // void slotFitWidth();
    
    void slotShowScrollBars();
    void slotCancelWatch();
    void slotShowMarkList();
    void slotShowPageLabels();

protected slots:
    void slotData( KIO::Job*, const QByteArray& );
    void slotJobFinished( KIO::Job* );
    
    void slotMimetypeFinished( const QString& );
    void slotMimetypeError();
    
    void slotFileDirty( const QString& );
    void slotOrientation (int);
    void slotMedia (int);
    void slotNewPage( int );
    void slotPageMoved( int, int );
    void slotWatchFile();

    void slotOpenFileCompleted();

protected:
    virtual void guiActivateEvent( KParts::GUIActivateEvent* );
   
    // reimplemented from ReadOnlyPart
    virtual bool openFile();
    
    void updatePageDepActions();
    void updateReadUpDownActions();

    void readSettings();
    void writeSettings();

private:
    KGVBrowserExtension* _extension;

    QWidget*	      _mainWidget;
    KGVPageView*      _pageView;
    KGVPageDecorator* _pageDecorator;
    KPSWidget*        _psWidget;
    ScrollBox*	      _scrollBox;
    QFrame*	      _divider;
    MarkList*	      _markList;
    KGVMiniWidget*    _docManager;

    KSelectAction* _selectOrientation;
    KSelectAction* _selectMedia;
    KAction*       _zoomIn;
    KAction*       _zoomOut; 
    // KAction* _fitWidth; 
    KAction*       _prevPage;
    KAction*       _nextPage;
    KAction*       _firstPage; 
    KAction*       _lastPage; 
    KAction*       _readUp; 
    KAction*       _readDown; 
    // KAction* _gotoPage;
    KToggleAction* _showScrollBars;
    KToggleAction* _watchFile;
    KToggleAction* _showPageList;
    KToggleAction* _showPageLabels; 
  
    QFile             _tmpFile;
    KIO::TransferJob* _job;
    KDirWatch*        _fileWatcher;
    KGVRun*           _mimetypeScanner;

    QString _mimetype;

    bool _isGuiInitialized : 1;
    bool _isDocumentOpen   : 1;
    bool _isFileDirty      : 1;

    int _currentPage;
};

class KGVBrowserExtension : public KParts::BrowserExtension
{
  Q_OBJECT
    friend class KGVPart; // emits our signals
public:
    KGVBrowserExtension( KGVPart* parent );
    virtual ~KGVBrowserExtension() {}

public slots:
    // Automatically detected by konqueror
    void print();
};

typedef KParts::GenericFactory<KGVPart> KGVFactory;

class KGVRun : public KRun
{
    Q_OBJECT
	
public:
    KGVRun( const KURL& url, mode_t mode = 0, 
            bool isLocalFile = false, bool showProgressInfo = true );

    virtual ~KGVRun();

signals:
    void finished( const QString& mimetype );

protected:
    void foundMimeType( const QString& mimetype );

protected slots:
    void emitFinishedWithMimetype() { emit finished( _mimetype ); }

private:
    QString _mimetype;
};

#endif


