#ifndef COMMON_INTER_H
#define COMMON_INTER_H

#include "ghighscores.h"

#include "lib/mp_simple_interface.h"
#include "base/inter.h"
#include "types.h"


class Interface : public MPSimpleInterface, public BaseInterface
{
 Q_OBJECT
 public:
	Interface(const MPGameInfo &, KAccel *kacc, QWidget *parent);
    ~Interface();

 private:
	QMemArray<ClientPlayData> data;
    QValueList<KExtHighscores::Score> gameOverData;

	MPBoard *newBoard(uint);
    void setInitData(uint player, ServerInitData &);
	uint prev(uint i) const;
	uint next(uint i) const;
    void resizeGameOverData(uint size);

    void _readGameOverData(QDataStream &s);
	void _sendGameOverData(QDataStream &s);
	void _firstInit() {}
	void _treatInit();
	void _init(bool server);
	void _showGameOverData(bool server);
	bool _readPlayData();
	void _sendPlayData();

    void _start() { MPSimpleInterface::start(); }
    void _pause() { MPSimpleInterface::pause(); }
    bool _isPaused() const { return MPSimpleInterface::isPaused(); }
};

#endif
