/***************************************************************************
                          klatin.cpp  -  description
                             -------------------
    begin                : Tue Dec 18 17:47:22 GMT 2001
    copyright            : (C) 2001 by George Wright
    email                : gwright@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcolor.h>
#include <qfile.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qsize.h>
#include <qstring.h>
#include <qtextstream.h>

#include <kstddirs.h>
#include <stdlib.h>
#include <time.h>
#include "klatin.h"

int section, typevocab, checkNum = 0;
float numCorrect = 0, numTotal = 0;
QString section_name[256], section_file[256], ques[64], ans[64], filename;
QString englishWord[6], grammarfile;
QString noun[13];

KLatin::KLatin(QWidget *parent, const char *name) : KMainWindow(parent, name)
{
	section = 1;
	klatinchoose = new KLatinChooseUI(this);
	setCentralWidget(klatinchoose);
	setConnections();
}

KLatin::~KLatin()
{
}

void KLatin::setConnections()
{
	if (section == 1)
	{
		connect(klatinchoose->butQuit, SIGNAL(clicked()), kapp, SLOT(quit()));
		connect(klatinchoose->butStart, SIGNAL(clicked()), this, SLOT(loadNext()));
	}
	if (section == 2)
	{
		connect(klatinvocablogin->butLaunch, SIGNAL(clicked()), this, SLOT(loadVocab()));
		connect(klatinvocablogin->butBack, SIGNAL(clicked()), this, SLOT(backFromLogin()));
	}
	if (section == 3)
	{
		connect(klatinvocab->butQuit, SIGNAL(clicked()), kapp, SLOT(quit()));
		connect(klatinvocab->butBack, SIGNAL(clicked()), this, SLOT(backFromVocab()));
		connect(klatinvocab->lblAnswer1, SIGNAL(clicked()), this, SLOT(checkAnswer1()));
		connect(klatinvocab->lblAnswer2, SIGNAL(clicked()), this, SLOT(checkAnswer2()));
		connect(klatinvocab->lblAnswer3, SIGNAL(clicked()), this, SLOT(checkAnswer3()));
		connect(klatinvocab->lblAnswer4, SIGNAL(clicked()), this, SLOT(checkAnswer4()));		
	}
	if (section == 4)
	{
		connect(klatingrammarlogin->butLaunch, SIGNAL(clicked()), this, SLOT(loadGrammar()));
		connect(klatingrammarlogin->butBack, SIGNAL(clicked()), this, SLOT(backFromGrammarLogin()));
	}
	if (section == 5)
	{
		connect(klatingrammar->btnOK, SIGNAL(clicked()), this, SLOT(checkGrammarAnswer()));
		connect(klatingrammar->txtAnswerBox, SIGNAL(returnPressed()), this, SLOT(checkGrammarAnswer()));
		connect(klatingrammar->btnBack, SIGNAL(clicked()), this, SLOT(backFromGrammar()));
	}

}

void KLatin::loadNext()
{
	if (klatinchoose->optVocab->isOn() == 1)
	{
		int lineNum = 0;
		
		klatinchoose->close();
		klatinvocablogin = new KLatinVocabLoginUI(this);
		klatinvocablogin->show();
		setCentralWidget(klatinvocablogin);
		section = 2;
		setConnections();
		
    // Load difficulty levels
		QFile levelDatabase(locate("data", "klatin/vocabs/vocab_levels.txt"));
		levelDatabase.open(IO_ReadOnly);
		QTextStream databaseRead(&levelDatabase);
		while (databaseRead.atEnd() == FALSE)
		{
			section_name[lineNum] = databaseRead.readLine();
			section_file[lineNum] = databaseRead.readLine();
			klatinvocablogin->cmbDifficulty->insertItem(section_name[lineNum]);
			lineNum++;
		}
	
		levelDatabase.close();
	}

	if (klatinchoose->optGrammar->isOn() == 1)
	{
		klatinchoose->close();
		klatingrammarlogin = new KLatinGrammarLoginUI(this);
		klatingrammarlogin->show();
		setCentralWidget(klatingrammarlogin);
		section = 4;
		setConnections();
	}

	if (klatinchoose->optRevision->isOn() == 1)
	{
		// Take the *very* easy route out :)
		// TODO: Implement a proper KHTML widget system
		QString revision_path;
		revision_path = "konqueror ";
		revision_path.insert(revision_path.length(), locate("data", "klatin/revision/klatin.html"));
		system(revision_path.latin1());
	}
}

void KLatin::loadVocab()
{
	int x = 0;
	while (x < 257)
	{
		if (section_name[x] == klatinvocablogin->cmbDifficulty->currentText())
			filename = section_file[x];
		x++;
	}
	
	if (klatinvocablogin->cmbType->currentText() == "Latin to English") typevocab = 1;
	if (klatinvocablogin->cmbType->currentText() == "English to Latin") typevocab = 2;
	
	klatinvocablogin->close();
	klatinvocab = new KLatinVocabUI(this);
	klatinvocab->show();
	setCentralWidget(klatinvocab);
	section = 3;
	setConnections();
	if (typevocab == 1) setupLtoE();
	if (typevocab == 2) setupEtoL();
}

void KLatin::loadGrammar()
{
	if (klatingrammarlogin->cmbDifficulty->currentText() == "1st Feminine")	
		grammarfile = locate("data", "klatin/grammar/puella.txt");
	if (klatingrammarlogin->cmbDifficulty->currentText() == "2nd Masculine")	
		grammarfile = locate("data", "klatin/grammar/servus.txt");
	if (klatingrammarlogin->cmbDifficulty->currentText() == "2nd Neuter")	
		grammarfile = locate("data", "klatin/grammar/bellum.txt");
	if (klatingrammarlogin->cmbDifficulty->currentText() == "3rd Masc/Fem")	
		grammarfile = locate("data", "klatin/grammar/rex.txt");
	if (klatingrammarlogin->cmbDifficulty->currentText() == "3rd Neuter")	
		grammarfile = locate("data", "klatin/grammar/opus.txt");
	if (klatingrammarlogin->cmbDifficulty->currentText() == "4th Masculine")	
		grammarfile = locate("data", "klatin/grammar/gradus.txt");
	if (klatingrammarlogin->cmbDifficulty->currentText() == "4th Neuter")	
		grammarfile = locate("data", "klatin/grammar/genu.txt");
	if (klatingrammarlogin->cmbDifficulty->currentText() == "5th Feminine")	
		grammarfile = locate("data", "klatin/grammar/res.txt");

	klatingrammarlogin->close();
	klatingrammar = new KLatinGrammarUI(this);
	klatingrammar->show();
	setCentralWidget(klatingrammar);
	section = 5;
	setConnections();
	setupGrammar();
}

void KLatin::setupGrammar()
{
	int lineNum = 0;
	
	QFile levelDatabase(grammarfile);
	levelDatabase.open(IO_ReadOnly);	
	QTextStream databaseRead(&levelDatabase);
	
	while (databaseRead.atEnd() == FALSE)
	{
		noun[lineNum] = databaseRead.readLine();
		lineNum++;
	}
	
	checkNum = random() % 13;

	QString temp_string;
	temp_string = "What is the ";
	if (checkNum == 1) temp_string.insert(temp_string.length(), "nominative singular of ");
	if (checkNum == 2) temp_string.insert(temp_string.length(), "vocative singular of ");
	if (checkNum == 3) temp_string.insert(temp_string.length(), "accusative singular of ");
	if (checkNum == 4) temp_string.insert(temp_string.length(), "genitive singular of ");
	if (checkNum == 5) temp_string.insert(temp_string.length(), "dative singular of ");
	if (checkNum == 6) temp_string.insert(temp_string.length(), "ablative singular of ");
	if (checkNum == 7) temp_string.insert(temp_string.length(), "nominative plural of ");
	if (checkNum == 8) temp_string.insert(temp_string.length(), "vocative plural of ");
	if (checkNum == 9) temp_string.insert(temp_string.length(), "accusative plural of ");
	if (checkNum == 10) temp_string.insert(temp_string.length(), "genitive plural of ");
	if (checkNum == 11) temp_string.insert(temp_string.length(), "dative plural of ");
	if (checkNum == 12) temp_string.insert(temp_string.length(), "ablative plural of ");
	temp_string.insert(temp_string.length(), noun[1]);
	temp_string.insert(temp_string.length(), "?");

	klatingrammar->lblQuestion->setText(temp_string);
	
	levelDatabase.close();
	
}

void KLatin::backFromLogin()
{
	klatinvocablogin->close();
	klatinchoose = new KLatinChooseUI(this);
	klatinchoose->show();
	setCentralWidget(klatinchoose);
	section = 1;
	setConnections();
}

void KLatin::backFromGrammarLogin()
{
	klatingrammarlogin->close();
	klatinchoose = new KLatinChooseUI(this);
	klatinchoose->show();
	setCentralWidget(klatinchoose);
	section = 1;
	setConnections();
}

void KLatin::backFromVocab()
{
	klatinvocab->close();
	klatinvocablogin = new KLatinVocabLoginUI(this);
	klatinvocablogin->show();
	setCentralWidget(klatinvocablogin);
	section = 2;
	setConnections();

	int lineNum = 0;

	QFile levelDatabase(locate("data", "klatin/vocabs/vocab_levels.txt"));
	levelDatabase.open(IO_ReadOnly);	
	QTextStream databaseRead(&levelDatabase);
	
	while (databaseRead.atEnd() == FALSE)
	{
		section_name[lineNum] = databaseRead.readLine();
		section_file[lineNum] = databaseRead.readLine();
		klatinvocablogin->cmbDifficulty->insertItem(section_name[lineNum]);
		lineNum++;
	}
	
	levelDatabase.close();

}

// Load all the data from the files.
void KLatin::setupLtoE()
{

	int lineNum = 0, randNum;
	// Seed the random number generator using the time
	srandom(time(NULL));
	
	QString str;
		str = "klatin/vocabs/";
		str.insert(str.length(), filename);
	
	QFile vocabFile(locate("data", str));
	
	vocabFile.open(IO_ReadOnly);
	
	QTextStream vocabRead(&vocabFile);
	
	while (vocabRead.atEnd() == FALSE)
	{
		ques[lineNum] = vocabRead.readLine();
		ans[lineNum] = vocabRead.readLine();
		lineNum++;
	}
	
	vocabFile.close();
	
	randNum = random() % (lineNum - 1);
	
	// Set the question label
	klatinvocab->lblQuestion->setText(ques[randNum]);
	
	// Assign the array englishWord[6] certain words to display for multiple choice
	
	int temp_rand, x = 1;

	while (x < 5)
	{
		temp_rand = random() % (lineNum - 1);
		
		if (temp_rand != randNum)
		{
			englishWord[x] = ans[temp_rand];
			x++;
		}
	}
	
	englishWord[5] = ans[randNum];
	
	// Override the previous assignment with the correct answer
	englishWord[(random() % 3) + 1] = ans[randNum];
	
	// Set the captions of the text boxes
	klatinvocab->lblAnswer1->setText(englishWord[1]);
	klatinvocab->lblAnswer2->setText(englishWord[2]);
	klatinvocab->lblAnswer3->setText(englishWord[3]);
	klatinvocab->lblAnswer4->setText(englishWord[4]);
}

// Same as setupLtoE() except that ans and ques swap "duties"
void KLatin::setupEtoL()
{

	int lineNum = 0, randNum;
	// Seed the random number generator using the time
	srandom(time(NULL));
	
	QString str;
		str = "klatin/vocabs/";
		str.insert(str.length(), filename);
	
	QFile vocabFile(locate("data", str));
	
	vocabFile.open(IO_ReadOnly);
	
	QTextStream vocabRead(&vocabFile);
	
	while (vocabRead.atEnd() == FALSE)
	{
		ans[lineNum] = vocabRead.readLine();
		ques[lineNum] = vocabRead.readLine();
		lineNum++;
	}
	
	vocabFile.close();
	
	randNum = random() % (lineNum - 1);
	
	// Set the question label
	klatinvocab->lblQuestion->setText(ques[randNum]);
	
	// Assign the array englishWord[6] certain words to display for multiple choice
	
	int temp_rand, x = 1;

	while (x < 5)
	{
		temp_rand = random() % (lineNum - 1);
		
		if (temp_rand != randNum)
		{
			englishWord[x] = ans[temp_rand];
			x++;
		}
	}
	
	englishWord[5] = ans[randNum];
	
	// Override the previous assignment with the correct answer
	englishWord[(random() % 3) + 1] = ans[randNum];
	
	// Set the captions of the text boxes
	klatinvocab->lblAnswer1->setText(englishWord[1]);
	klatinvocab->lblAnswer2->setText(englishWord[2]);
	klatinvocab->lblAnswer3->setText(englishWord[3]);
	klatinvocab->lblAnswer4->setText(englishWord[4]);
}

// Check to see if the answer is correct
// It's a horrible way of doing it - I know

void KLatin::checkAnswer1()
{
	if (englishWord[1] != englishWord[5])
	{
		numTotal++;
	}

	if (englishWord[1] == englishWord[5])
	{
		numCorrect++;
		numTotal++;
		setupLtoE();
	}

	klatinvocab->lblScore2->setNum(numTotal);
	klatinvocab->lblScore1->setNum(numCorrect);
	QString temp;
	temp.setNum(int(numCorrect / numTotal * 100));
	temp.insert(temp.length(), "%");
	klatinvocab->lblPercentage->setText(temp);
}

void KLatin::checkAnswer2()
{
	if (englishWord[2] != englishWord[5])
	{
		numTotal++;
	}

	if (englishWord[2] == englishWord[5])
	{
		numCorrect++;
		numTotal++;
		if (typevocab == 1) setupLtoE();
		if (typevocab == 2) setupEtoL();	
	}

	klatinvocab->lblScore2->setNum(numTotal);
	klatinvocab->lblScore1->setNum(numCorrect);

	QString temp;
	temp.setNum(int(numCorrect / numTotal * 100));
	temp.insert(temp.length(), "%");
	klatinvocab->lblPercentage->setText(temp);
}

void KLatin::checkAnswer3()
{
	if (englishWord[3] != englishWord[5])
	{
		numTotal++;
	}

	if (englishWord[3] == englishWord[5])
	{
		numCorrect++;
		numTotal++;
		if (typevocab == 1) setupLtoE();
		if (typevocab == 2) setupEtoL();	
	}

	klatinvocab->lblScore2->setNum(numTotal);
	klatinvocab->lblScore1->setNum(numCorrect);
	QString temp;
	temp.setNum(int(numCorrect / numTotal * 100));
	temp.insert(temp.length(), "%");
	klatinvocab->lblPercentage->setText(temp);
}

void KLatin::checkAnswer4()
{
	if (englishWord[4] != englishWord[5])
	{
		numTotal++;
	}

	if (englishWord[4] == englishWord[5])
	{
		numCorrect++;
		numTotal++;
		if (typevocab == 1) setupLtoE();
		if (typevocab == 2) setupEtoL();
	}

	klatinvocab->lblScore2->setNum(numTotal);
	klatinvocab->lblScore1->setNum(numCorrect);
	QString temp;
	temp.setNum(int(numCorrect / numTotal * 100));
	temp.insert(temp.length(), "%");
	klatinvocab->lblPercentage->setText(temp);
}

void KLatin::checkGrammarAnswer()
{
	int i, x;
	for (i =0; i<13; i++)
	{
		if (checkNum == i)
			if (x != 1)
				if (klatingrammar->txtAnswerBox->text() != noun[i])
				{
					x = 1;
					numTotal++;
					klatingrammar->lblScore2->setNum(numTotal);
				}
			if (klatingrammar->txtAnswerBox->text() == noun[i])
			{
				x = 1;
				setupGrammar();
				klatingrammar->txtAnswerBox->setText("");
				numCorrect++;
				numTotal++;
				klatingrammar->lblScore1->setNum(numCorrect);
				klatingrammar->lblScore2->setNum(numTotal);
			}
	}
	
}
