/***************************************************************************
                            KURLCompletion.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KURLCOMPLETION_H
#define KURLCOMPLETION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KCompletion.h>

/**

 This class does completion of URLs including user directories (~user)
 and environment variables.  Remote URLs are passed to KIO.

 @author David Smith <dsmith@algonet.se>

 @version $Id: KURLCompletion.h,v 1.3 2002/03/15 02:12:24 rdale Exp $
 
 @short Completion of a single URL.
*/
@class Job; 

@interface KURLCompletion : KCompletion 

/** 
 Constructs a KURLCompletion object in FileCompletion mode.
	 
*/
- init;

/** 
 This overloaded constructor allows you to set the Mode to ExeCompletion
 or FileCompletion without using @ref setMode. Default is FileCompletion
	 
*/
- initWithInt: (int)arg1;

/** 
 Destructs the KURLCompletion object.
	 
*/
- (void) dealloc;

/** 
 Finds completions to the given text.

 Remote URLs are listed with KIO. For performance reasons, local files
 are listed with KIO only if KURLCOMPLETION_LOCAL_KIO is set.
 The completion is done asyncronously if KIO is used.

 Returns the first match for user, environment, and local dir completion
 and -[QString null]for asyncronous completion (KIO).
	 
*/
- (NSString *) makeCompletion: (NSString *)arg1;

/** 
 Sets the current directory (used as base for completion)
 Default = $HOME.
	 
*/
- setDir: (NSString *)dir;

/** 
 Returns the current directory.
	 
*/
- (NSString *) dir;

/** 
 Returns true if asyncronous completion is in progress.
	 
*/
- (BOOL) isRunning;

/** 
 Stops asyncronous completion.
	 
*/
- stop;

/** 
 Returns the completion mode: exe or file completion (default FileCompletion)
	 
*/
- (int) mode;

/** 
 Changes the completion mode: exe or file completion
	 
*/
- setMode: (int)mode;

/** 
 Returns whether environment variables are completed and
 whether they are replaced internally while finding completions.
 Default is enabled.
	 
*/
- (BOOL) replaceEnv;

/** 
 Enables/disables completion and replacement (internally) of
 environment variables in URLs. Default is enabled.
	 
*/
- setReplaceEnv: (BOOL)replace;

/** 
 Returns whether ~username is completed and whether ~username
 is replaced internally with the user's home directory while
 finding completions. Default is enabled.
	 
*/
- (BOOL) replaceHome;

/** 
 Enables/disables completion of ~username and replacement
 (internally) of ~username with the user's home directory.
 Default is enabled.
	 
*/
- setReplaceHome: (BOOL)replace;

/** 
 Replaces username and/or environment variables, depending on the
 current settings and returns the filtered url. Only works with
 local files, i.e. returns back the original string for non-local
 urls.
	 
*/
- (NSString *) replacedPath: (NSString *)text;
- postProcessMatch: (NSString *)match;
- postProcessMatches: (NSArray *)matches;
//- postProcessCompletionMatches: (KCompletionMatches*)matches;
//- slotEntries: (Job*)arg1 udsentrylist: (UDSEntryList*)arg2;
- slotIOFinished: (Job*)arg1;
+ (int) ExeCompletion;
+ (int) FileCompletion;
+ (int) DirCompletion;
@end

/** Override these methods in subclasses of KURLCompletion to customise event handling behaviour */
@protocol KURLCompletionEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
