/***************************************************************************
                            KMultipleDrag.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class makes it easy for applications to provide a drag object
 (for drag-n-drop or for clipboard) that has several representations
 of the same data, under different formats.

 Instead of creating a specific class for each case (as would otherwise
 be necessary), you can simply create independent drag objects (e.g.
 a QImageDrag object and a KURLDrag object), and bundle them together
 using KMultipleDrag.

 Sample code for this:

 KMultipleDrag drag = new KMultipleDrag( parentWidget );
 drag.addDragObject( new QImageDrag( someQImage, null ) );
 drag.addDragObject( KURLDrag.newDrag( someKURL, null ) );
 drag.drag();

 Note that the drag objects added to the multiple drag become owned by it.
 For that reason their parent should be null.

 See {@link KMultipleDragSignals} for signals emitted by KMultipleDrag.

 See {@link KMultipleDragEventHandling} for event handlers to override in subclasses of KMultipleDrag.

 @author David Faure <david@mandrakesoft.com>
 
 @short 
 This class makes it easy for applications to provide a drag object
 (for drag-n-drop or for clipboard) that has several representations
 of the same data, under different formats.
*/
public class KMultipleDrag extends QDragObject  {
	protected KMultipleDrag(Class dummy){super((Class) null);}

	private native void newKMultipleDrag( QWidget dragSource, String name);
	public KMultipleDrag( QWidget dragSource, String name) {
		super((Class) null);
		newKMultipleDrag( dragSource, name);
	}
	private native void newKMultipleDrag();
	public KMultipleDrag() {
		super((Class) null);
		newKMultipleDrag();
	}

/** 
 Call this to add each underlying drag object to the multipledrag.
     
*/
	public native void addDragObject( QDragObject dragObject);
	public native byte[] encodedData( String mime);
	public native String format( int i);
}
