package org.kde.koala;
import org.kde.qt.*;


/** {@link KListBox} emits these signals */
public interface KListBoxSignals {
	void rightButtonPressed( QListBoxItem arg1, QPoint arg2 );
	void selected( QListBoxItem arg1 );
	void destroyed( QObject obj );
	void returnPressed( QListBoxItem arg1 );
	void rightButtonClicked( QListBoxItem arg1, QPoint arg2 );
	void contentsMoving( int x, int y );
	void pressed( QListBoxItem arg1, QPoint arg2 );
	void highlighted( QListBoxItem arg1 );
	void clicked( QListBoxItem arg1, QPoint arg2 );
	void contextMenuRequested( QListBoxItem arg1, QPoint arg2 );
	void currentChanged( QListBoxItem arg1 );
	void mouseButtonPressed( int arg1, QListBoxItem arg2, QPoint arg3 );
	void mouseButtonClicked( int arg1, QListBoxItem arg2, QPoint arg3 );

/** 
 This signal gets emitted whenever the user double clicks into the 
 listbox. 

 Note that you may not delete any {@link QListBoxItem} objects in slots
 connected to this signal.  

 This signal is more or less here for the sake of completeness.
 You should normally not need to use this. In most cases its better 
 to use {@link KListBox#executed} instead.
   
*/
	void doubleClicked( QListBoxItem item, QPoint pos );
	void selectionChanged( QListBoxItem arg1 );
	void onViewport();
	void onItem( QListBoxItem item );

/** 
 Emitted whenever the user executes an listbox item. 

 That means depending on the KDE wide Single Click/Double Click 
 setting the user clicked or double clicked on that item.

 Note that you may not delete any {@link QListBoxItem} objects in slots 
 connected to this signal.
   
*/
	void executed( QListBoxItem item, QPoint pos );
}

