/***************************************************************************
                            KCModule.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The base class for control center modules.

 Starting from KDE 2.0, control center modules are realized as shared
 libraries that are loaded into the control center at runtime.

 The module in principle is a simple widget displaying the
 item to be changed. The module has a very small interface.

 All the necessary glue logic and the GUI bells and whistles
 are provided by the control center and must not concern
 the module author.

 To write a config module, you have to create a library
 that contains at one factory function like this:

 <pre>
 #include <kgenericfactory.h>

 typedef KGenericFactory<YourKCModule, QWidget> YourKCModuleFactory;
 K_EXPORT_COMPONENT_FACTORY( yourLibName, YourKCModuleFactory );
 </pre>

 See kdebase/kcontrol/HOWTO for more detailed documentation.

 See {@link KCModuleSignals} for signals emitted by KCModule.

 See {@link KCModuleEventHandling} for event handlers to override in subclasses of KCModule.

 @author Matthias Hoelzer-Kluepfel <hoelzer@kde.org>
 
 @short 
 The base class for control center modules.
*/
public class KCModule extends QWidget  {
	protected KCModule(Class dummy){super((Class) null);}

	private native void newKCModule( QWidget parent, String name, String[] args);
	public KCModule( QWidget parent, String name, String[] args) {
		super((Class) null);
		newKCModule( parent, name, args);
	}
	private native void newKCModule();
	public KCModule() {
		super((Class) null);
		newKCModule();
	}
	private native void newKCModule( KInstanceInterface instance, QWidget parent, String[] args);
	public KCModule( KInstanceInterface instance, QWidget parent, String[] args) {
		super((Class) null);
		newKCModule( instance, parent, args);
	}
	private native void newKCModule( KInstanceInterface instance);
	public KCModule( KInstanceInterface instance) {
		super((Class) null);
		newKCModule( instance);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Load the configuration data into the module.

 The load method sets the user interface elements of the
 module to reflect the current settings stored in the
 configuration files.

 This method is invoked whenever the module should read its configuration
 (most of the times from a config file) and update the user interface.
 This happens when the user clicks the "Reset" button in the control
 center, to undo all of his changes and restore the currently valid
 settings. NOTE that this is not called after the modules is loaded,
 so you probably want to call this method in the constructor.
   
*/
	public native void load();

/** 
 Save the configuration data.

 The save method stores the config information as shown
 in the user interface in the config files.

 If necessary, this method also updates the running system,
 e.g. by restarting applications.

 save is called when the user clicks "Apply" or "Ok".
   
*/
	public native void save();

/** 
 Sets the configuration to sensible default values.

 This method is called when the user clicks the "Default"
 button. It should set the display to useful values.
   
*/
	public native void defaults();

/** 
 Set the configuration to system default values.

 This method is called when the user clicks the "System-Default"
 button. It should set the display to the system default values.

 NOTE: The default behaviour is to call defaults().
   
*/
	public native void sysdefaults();

/** 
 Return a quick-help text.

 This method is called when the module is docked.
 The quick-help text should contain a short description of the module and
 links to the module's help files. You can use QML formating tags in the text.

 NOTE: Please make sure the quick help text gets translated (use i18n()).
   
*/
	public native String quickHelp();

/** 
 Returns a the KAboutData for this module
 This is generally only called for the KBugReport.
 Override and have it return a pointer to a constant
   
*/
	public native KAboutData aboutData();

/** 
 Indicate which buttons will be used.

 The return value is a value or'ed together from
 the Button enumeration type.

*/
	public native int buttons();

/** 
 Get the RootOnly message for this module.

 When the module must be run as root, or acts differently
 for root and a normal user, it is sometimes useful to
 customize the message that appears at the top of the module
 when used as a normal user. This function returns this
 customized message. If none has been set, a default message
 will be used.

*/
	public native String rootOnlyMsg();

/** 
 Tell if KControl should show a RootOnly message when run as
 a normal user.

 In some cases, the module don't want a RootOnly message to
 appear (for example if it has already one). This function
 tells KControl if a RootOnly message should be shown

*/
	public native boolean useRootOnlyMsg();
	public native KInstanceInterface instance();

/** 
 Sets the buttons to display.

 Help: shows a "Help" button.
 Default: shows a "Use Defaults" button
 Apply: in kcontrol this will show an "Apply" and "Reset" button
        in kcmshell this will show an "Ok", "Apply" and "Cancel" button

 If Apply is not specified, kcmshell will show a "Close" button.

*/
	protected native void setButtons( int btn);

/** 
 Sets the RootOnly message.

 This message will be shown at the top of the module of the
 corresponding desktop file contains the line X-KDE-RootOnly=true.
 If no message is set, a default one will be used.

*/
	protected native void setRootOnlyMsg( String msg);

/** 
 Change wether or not the RootOnly message should be shown.

 Following the value of <code>on</code>, the RootOnly message will be
 shown or not.

*/
	protected native void setUseRootOnlyMsg( boolean on);
	public static final int Help = 1;
	public static final int Default = 2;
	public static final int Apply = 16;
	public static final int Reset = 4;
	public static final int Cancel = 8;
	public static final int Ok = 32;
	public static final int SysDefault = 64;
}
