/***************************************************************************
                            kde_KSelectAction.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSELECTACTION
#define KDE_KSELECTACTION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

  Action for selecting one of several items.

  This action shows up a submenu with a list of items.
  One of them can be checked. If the user clicks on an item
  this item will automatically be checked,
  the formerly checked item becomes unchecked.
  There can be only one item checked at a time.

 @short Action for selecting one of several items.
*/

/** 
 Constructs a select action with text and potential keyboard
 accelerator but nothing else. Use this only if you really
 know what you are doing.

*/
kde_KSelectAction * kde_new_KSelectAction(qt_QString * text, kde_KShortcut* cut, qt_QObject * parent, char* name);

/** 

*/
kde_KSelectAction * kde_new_KSelectAction1(qt_QString * text, kde_KShortcut* cut, qt_QObject * receiver, char* slot, qt_QObject * parent, char* name);

/** 

*/
kde_KSelectAction * kde_new_KSelectAction2(qt_QString * text, qt_QIconSet* pix, kde_KShortcut* cut, qt_QObject * parent, char* name);

/** 

*/
kde_KSelectAction * kde_new_KSelectAction3(qt_QString * text, qt_QString * pix, kde_KShortcut* cut, qt_QObject * parent, char* name);

/** 

*/
kde_KSelectAction * kde_new_KSelectAction4(qt_QString * text, qt_QIconSet* pix, kde_KShortcut* cut, qt_QObject * receiver, char* slot, qt_QObject * parent, char* name);

/** 

*/
kde_KSelectAction * kde_new_KSelectAction5(qt_QString * text, qt_QString * pix, kde_KShortcut* cut, qt_QObject * receiver, char* slot, qt_QObject * parent, char* name);

/** 

*/
kde_KSelectAction * kde_new_KSelectAction6(qt_QObject * parent, char* name);

/** 
 Destructor
     
*/
void kde_del_KSelectAction( kde_KSelectAction* p );

/** 
  "Plug" or insert this action into a given widget.

  This will typically be a menu or a toolbar.
  From this point on, you will never need to directly
  manipulate the item in the menu or toolbar.
  You do all enabling/disabling/manipulation directly with your KSelectAction object.

*/
int kde_KSelectAction_plug(kde_KSelectAction* instPointer,qt_QWidget * widget, int index);

/** 
 When this action is plugged into a toolbar, it creates a combobox.

*/
int kde_KSelectAction_isEditable(kde_KSelectAction* instPointer);

/** 

*/
qt_QStringList* kde_KSelectAction_items(kde_KSelectAction* instPointer);
void kde_KSelectAction_changeItem(kde_KSelectAction* instPointer,int index, qt_QString * text);
qt_QString * kde_KSelectAction_currentText(kde_KSelectAction* instPointer);
int kde_KSelectAction_currentItem(kde_KSelectAction* instPointer);

/** 
 When this action is plugged into a toolbar, it creates a combobox.
 This returns the maximum width set by setComboWidth
     
*/
int kde_KSelectAction_comboWidth(kde_KSelectAction* instPointer);
qt_QPopupMenu* kde_KSelectAction_popupMenu(kde_KSelectAction* instPointer);

/** 
  Sets the currently checked item.

*/
void kde_KSelectAction_setCurrentItem(kde_KSelectAction* instPointer,int index);

/** 
 Sets the items to be displayed in this action
 You need to call this.
     
*/
void kde_KSelectAction_setItems(kde_KSelectAction* instPointer,qt_QStringList* lst);

/** 
 Clears up all the items in this action
     
*/
void kde_KSelectAction_clear(kde_KSelectAction* instPointer);

/** 
 When this action is plugged into a toolbar, it creates a combobox.
 This makes the combo editable or read-only.
     
*/
void kde_KSelectAction_setEditable(kde_KSelectAction* instPointer,int arg1);

/** 
 When this action is plugged into a toolbar, it creates a combobox.
 This gives a _maximum_ size to the combobox.
 The minimum size is automatically given by the contents (the items).
     
*/
void kde_KSelectAction_setComboWidth(kde_KSelectAction* instPointer,int width);
void kde_KSelectAction_changeItem1(kde_KSelectAction* instPointer,int identifier, int index, qt_QString * text);
void kde_KSelectAction_setCurrentItem1(kde_KSelectAction* instPointer,int identifier, int index);
void kde_KSelectAction_setComboWidth1(kde_KSelectAction* instPointer,int identifier, int width);
void kde_KSelectAction_setItems1(kde_KSelectAction* instPointer,int identifier, qt_QStringList* lst);
void kde_KSelectAction_clear1(kde_KSelectAction* instPointer,int identifier);
void kde_KSelectAction_slotActivated(kde_KSelectAction* instPointer,int identifier);
void kde_KSelectAction_slotActivated1(kde_KSelectAction* instPointer,qt_QString * text);
void kde_KSelectAction_slotActivated2(kde_KSelectAction* instPointer);

#endif
