/***************************************************************************
                            kde_HTMLTextAreaElement.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_HTMLTEXTAREAELEMENT
#define KDE_HTMLTEXTAREAELEMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Multi-line text field. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#edef-TEXTAREA">
 TEXTAREA element definition </a> in HTML 4.0.

 
 @short 
 Multi-line text field.
*/
kde_HTMLTextAreaElement * kde_new_HTMLTextAreaElement();
kde_HTMLTextAreaElement * kde_new_HTMLTextAreaElement1(kde_HTMLTextAreaElement* other);
kde_HTMLTextAreaElement * kde_new_HTMLTextAreaElement2(kde_DOMNode* other);
void kde_del_HTMLTextAreaElement( kde_HTMLTextAreaElement* p );

/** 
 Stores the initial control value (i.e., the initial value of
 <code> value </code> ).

     
*/
kde_DOMString* kde_HTMLTextAreaElement_defaultValue(kde_HTMLTextAreaElement* instPointer);

/** 
 see @ref defaultValue
     
*/
void kde_HTMLTextAreaElement_setDefaultValue(kde_HTMLTextAreaElement* instPointer,kde_DOMString* arg1);

/** 
 Returns the <code> FORM </code> element containing this
 control. Returns null if this control is not within the context
 of a form.

     
*/
kde_HTMLFormElement* kde_HTMLTextAreaElement_form(kde_HTMLTextAreaElement* instPointer);

/** 
 A single character access key to give access to the form
 control. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-accesskey">
 accesskey attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTextAreaElement_accessKey(kde_HTMLTextAreaElement* instPointer);

/** 
 see @ref accessKey
     
*/
void kde_HTMLTextAreaElement_setAccessKey(kde_HTMLTextAreaElement* instPointer,kde_DOMString* arg1);

/** 
 Width of control (in characters). See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-cols-TEXTAREA">
 cols attribute definition </a> in HTML 4.0.

     
*/
long kde_HTMLTextAreaElement_cols(kde_HTMLTextAreaElement* instPointer);

/** 
 see @ref cols
     
*/
void kde_HTMLTextAreaElement_setCols(kde_HTMLTextAreaElement* instPointer,long arg1);

/** 
 The control is unavailable in this context. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-disabled">
 disabled attribute definition </a> in HTML 4.0.

     
*/
int kde_HTMLTextAreaElement_disabled(kde_HTMLTextAreaElement* instPointer);

/** 
 see @ref disabled
     
*/
void kde_HTMLTextAreaElement_setDisabled(kde_HTMLTextAreaElement* instPointer,int arg1);

/** 
 Form control or object name when submitted with a form. See the
 <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-name-TEXTAREA">
 name attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTextAreaElement_name(kde_HTMLTextAreaElement* instPointer);

/** 
 see @ref name
     
*/
void kde_HTMLTextAreaElement_setName(kde_HTMLTextAreaElement* instPointer,kde_DOMString* arg1);

/** 
 This control is read-only. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-readonly">
 readonly attribute definition </a> in HTML 4.0.

     
*/
int kde_HTMLTextAreaElement_readOnly(kde_HTMLTextAreaElement* instPointer);

/** 
 see @ref readOnly
     
*/
void kde_HTMLTextAreaElement_setReadOnly(kde_HTMLTextAreaElement* instPointer,int arg1);

/** 
 Number of text rows. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-rows-TEXTAREA">
 rows attribute definition </a> in HTML 4.0.

     
*/
long kde_HTMLTextAreaElement_rows(kde_HTMLTextAreaElement* instPointer);

/** 
 see @ref rows
     
*/
void kde_HTMLTextAreaElement_setRows(kde_HTMLTextAreaElement* instPointer,long arg1);

/** 
 Index that represents the element's position in the tabbing
 order. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-tabindex">
 tabindex attribute definition </a> in HTML 4.0.

     
*/
long kde_HTMLTextAreaElement_tabIndex(kde_HTMLTextAreaElement* instPointer);

/** 
 see @ref tabIndex
     
*/
void kde_HTMLTextAreaElement_setTabIndex(kde_HTMLTextAreaElement* instPointer,long arg1);

/** 
 The type of this form control.

     
*/
kde_DOMString* kde_HTMLTextAreaElement_type(kde_HTMLTextAreaElement* instPointer);

/** 
 The current textual content of the multi-line text field. If
 the entirety of the data can not fit into a single wstring, the
 implementation may truncate the data.

     
*/
kde_DOMString* kde_HTMLTextAreaElement_value(kde_HTMLTextAreaElement* instPointer);

/** 
 see @ref value
     
*/
void kde_HTMLTextAreaElement_setValue(kde_HTMLTextAreaElement* instPointer,kde_DOMString* arg1);

/** 
 Removes keyboard focus from this element.
     
*/
void kde_HTMLTextAreaElement_blur(kde_HTMLTextAreaElement* instPointer);

/** 
 Gives keyboard focus to this element.
     
*/
void kde_HTMLTextAreaElement_focus(kde_HTMLTextAreaElement* instPointer);

/** 
 Select the contents of the <code> TEXTAREA </code> .
     
*/
void kde_HTMLTextAreaElement_select(kde_HTMLTextAreaElement* instPointer);

#endif
