#include <qimage.h>
#include <qfont.h>
#include <qpainter.h>
#include <qregexp.h>
#include <qdict.h>

#include <kstandarddirs.h>
#include <klocale.h>

#include "pixmap.h"



const QPixmap& findPixmap(const QString& code_)
{
  static QDict<QPixmap> pixmaps(80);
  static const QString flagTemplate("l10n/%1/flag.png");

  QPixmap* pm = pixmaps[code_];
  if( pm )
    return *pm;

  QString code = code_.mid(0, code_.find(QRegExp("[()+]")));	//co_foo,co(foo),co+foo
  code = code.mid(code.find('/') + 1);	//NEC/jp


  QString flag;
  int pos = code.length();
  if( code_ == "ar" )	// Arabic - not argentina
    flag = locate("locale", flagTemplate.arg("C"));
  else {
    flag = locate("locale", flagTemplate.arg(code.lower()));
    if (flag.isEmpty()) {
      pos = code.find("_");
      if (pos > 0 && code.find("intl") < 1) { // so "us_intl" != "us" layout
        flag = locate("locale", flagTemplate.arg(code.mid(pos+1).lower()));
        if (flag.isEmpty())
        flag = locate("locale", flagTemplate.arg(code.left(pos).lower()));
      }
      //this is a tiny patch for the el (Hellenic <=> Greek) keyboard
      //which is not named after the country, but after the language
      //unlike all others.
      //remove if it causes trouble, but pls contact first
      // d.kamenopoulos@mail.ntua.gr
      else if (code.lower() == "el")
        flag = locate("locale", flagTemplate.arg("gr"));
      //end of patch
    }
  }
  
  if (flag.isEmpty())
    flag = locate("locale", flagTemplate.arg("C"));

  if (flag.isEmpty()) {		// could not find "C" flag - pretty bad!
    pm = new QPixmap(21, 14);
    pm->fill(Qt::white);
  }
  else
    pm = new QPixmap(flag);

  QImage image = pm->convertToImage();
  for (int y=0; y<image.height(); y++)
    for(int x=0; x<image.width(); x++)
      {
	QRgb rgb = image.pixel(x,y);
	image.setPixel(x,y,qRgb(qRed(rgb)*3/4,qGreen(rgb)*3/4,qBlue(rgb)*3/4));
      }
  pm->convertFromImage(image);

  QPainter p(pm);
  
  // some workaround for layouts which have poor representation with two letters
  if( ( code.length() == 3 && code.find(QRegExp("[^a-zA-Z0-9]")) == -1 )
	|| code_ == "dvorak" ) {
    code = code.left(3);
    p.setFont(QFont("helvetica", 9, QFont::Bold));
    p.setPen(Qt::black);
    p.drawText(2, 1, pm->width(), pm->height()-2, Qt::AlignCenter, code);
    p.setPen(Qt::white);
    p.drawText(1, 0, pm->width(), pm->height()-2, Qt::AlignCenter, code);
  }
  else {
    code = code.left(pos).right(3);
    p.setFont(QFont("helvetica", 10, QFont::Bold));
    p.setPen(Qt::black);
    p.drawText(1, 1, pm->width(), pm->height()-2, Qt::AlignCenter, code);
    p.setPen(Qt::white);
    p.drawText(0, 0, pm->width(), pm->height()-2, Qt::AlignCenter, code);
  }

  pixmaps.insert(code_, pm);

  return *pm;
}


// Note: this seems stupid, but allows for translations
#if 0
   I18N_NOOP("Belgian");
   I18N_NOOP("Bulgarian");
   I18N_NOOP("Brazilian");
   I18N_NOOP("Canadian");
   I18N_NOOP("Czech");
   I18N_NOOP("Czech (qwerty)");
   I18N_NOOP("Danish");
   I18N_NOOP("Estonian");
   I18N_NOOP("Finnish");
   I18N_NOOP("French");
   I18N_NOOP("German");
   I18N_NOOP("Hungarian");
   I18N_NOOP("Hungarian (qwerty)");
   I18N_NOOP("Italian");
   I18N_NOOP("Japanese");
   I18N_NOOP("Lithuanian");
   I18N_NOOP("Norwegian");
   I18N_NOOP("PC-98xx Series");
   I18N_NOOP("Polish");
   I18N_NOOP("Portuguese");
   I18N_NOOP("Romanian");
   I18N_NOOP("Russian");
   I18N_NOOP("Slovak");
   I18N_NOOP("Slovak (qwerty)");
   I18N_NOOP("Spanish");
   I18N_NOOP("Swedish");
   I18N_NOOP("Swiss German");
   I18N_NOOP("Swiss French");
   I18N_NOOP("Thai");
   I18N_NOOP("United Kingdom");
   I18N_NOOP("U.S. English");
   I18N_NOOP("U.S. English w/ deadkeys");
   I18N_NOOP("U.S. English w/ISO9995-3");

  //lukas: these seem to be new in XF 4.0.2
   I18N_NOOP("Armenian");
   I18N_NOOP("Azerbaidjani");
   I18N_NOOP("Icelandic");
   I18N_NOOP("Israeli");
   I18N_NOOP("Lithuanian azerty standard");
   I18N_NOOP("Lithuanian querty \"numeric\"");	     //for bw compatibility
   I18N_NOOP("Lithuanian querty \"programmer's\"");
   I18N_NOOP("Macedonian");
   I18N_NOOP("Serbian");
   I18N_NOOP("Slovenian");
   I18N_NOOP("Vietnamese");

  //these seem to be new in XFree86 4.1.0
   I18N_NOOP("Arabic");
   I18N_NOOP("Belarusian");
   I18N_NOOP("Bengali");
   I18N_NOOP("Croatian");
   I18N_NOOP("Greek");
   I18N_NOOP("Latvian");
   I18N_NOOP("Lithuanian qwerty \"numeric\"");
   I18N_NOOP("Lithuanian qwerty \"programmer's\"");
   I18N_NOOP("Turkish");
   I18N_NOOP("Ukrainian");

   I18N_NOOP("Brazilian ABNT2");
   I18N_NOOP("Dell 101-key PC");
   I18N_NOOP("Everex STEPnote");
   I18N_NOOP("Generic 101-key PC");
   I18N_NOOP("Generic 102-key (Intl) PC");
   I18N_NOOP("Generic 104-key PC");
   I18N_NOOP("Generic 105-key (Intl) PC ");
   I18N_NOOP("Japanese 106-key");
   I18N_NOOP("Microsoft Natural");
   I18N_NOOP("Northgate OmniKey 101");
   I18N_NOOP("Keytronic FlexPro");
   I18N_NOOP("Winbook Model XP5");

  //these seem to be new in XFree86 4.2.0
   I18N_NOOP("Albanian");
   I18N_NOOP("Burmese");
   I18N_NOOP("Dutch");
   I18N_NOOP("Georgian (latin)");
   I18N_NOOP("Georgian (russian)");
   I18N_NOOP("Gujarati");
   I18N_NOOP("Gurmukhi");
   I18N_NOOP("Hindi");
   I18N_NOOP("Inuktitut");
   I18N_NOOP("Iranian");
   I18N_NOOP("Latin America");
   I18N_NOOP("Maltese");
   I18N_NOOP("Maltese (US layout)");
   I18N_NOOP("Northern Saami (Finland)");
   I18N_NOOP("Northern Saami (Norway)");
   I18N_NOOP("Northern Saami (Sweden)");
   I18N_NOOP("Polish (qwertz)");
   I18N_NOOP("Russian (cyrillic phonetic)");
   I18N_NOOP("Tajik");
   I18N_NOOP("Turkish (F)");
   I18N_NOOP("U.S. English w/ ISO9995-3");
   I18N_NOOP("Yugoslavian");
#endif
