/* Pan "About" Dialog
 * Copyright (C) 2001 Charles Kerr <charles@rebelbase.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * AUTHOR:
 * 	Charles Kerr <charles@rebelbase.com>
 *
 * DESCRIPTION:
 *	An "About" somewhat more flexible than the Gnome default.
 *	It's somewhat similar to the KDE "about" dialog class.
 */        

#ifndef __PAN_ABOUT_H__
#define __PAN_ABOUT_H__

#include <libgnome/gnome-defs.h>
#include <libgnomeui/libgnomeui.h>

BEGIN_GNOME_DECLS

#define PAN_TYPE_ABOUT            (pan_about_get_type ())
#define PAN_ABOUT(obj)            (GTK_CHECK_CAST ((obj), PAN_TYPE_ABOUT, PanAbout))
#define PAN_ABOUT_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), PAN_TYPE_ABOUT, PanAboutClass))
#define PAN_IS_ABOUT(obj)         (GTK_CHECK_TYPE ((obj), PAN_TYPE_ABOUT))
#define PAN_IS_ABOUT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), PAN_TYPE_ABOUT))

typedef struct _PanAbout        PanAbout;
typedef struct _PanAboutClass   PanAboutClass;

struct _PanAbout
{
	GnomeDialog dialog;
	GtkWidget * notebook;
	gpointer _private;
};

struct _PanAboutClass
{
	GnomeDialogClass parent_class;
};


guint         pan_about_get_type     (void);

GtkWidget*    pan_about_new          (const gchar   * app_title,
                                      const gchar   * app_version,
                                      const gchar   * app_short_description,
                                      const gchar   * app_copyright,
                                      const gchar   * app_license,
                                      const gchar   * app_homepage);

void          pan_about_add_author   (PanAbout      * about_dialog,
                                      const gchar   * name, 
                                      const gchar   * email,
                                      const gchar   * job_title);

void          pan_about_add_credit   (PanAbout      * about_dialog,
                                      const gchar   * name, 
                                      const gchar   * email,
                                      const gchar   * job_title);

void          pan_about_add_text     (PanAbout      * about_dialog,
                                      const gchar   * tab,
                                      const gchar   * text);

extern const gchar * PAN_ABOUT_LICENSE_GPL;


void          pan_about_construct    (PanAbout      * about,
                                      const gchar   * app_title,
                                      const gchar   * app_version,
                                      const gchar   * app_short_description,
                                      const gchar   * app_copyright,
                                      const gchar   * app_license,
                                      const gchar   * app_homepage);
END_GNOME_DECLS

#endif /* __GNOME_ABOUT_H__ */


