/*
 *  Copyright (C) 1999, 2000 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GTM_H
#define _GTM_H

#include <config.h>

typedef enum {
    PROTOCOL_NONE,
    PROTOCOL_HTTP,
    PROTOCOL_FTP,
    PROTOCOL_HTTPS
} Protocol;

typedef struct 
{
    gboolean use_proxy;
    gchar *proxy_user;
    gchar *proxy_pass;
    gchar *proxy_http;
    gchar *proxy_ftp;
    gchar *proxy_https;
    guint toolbar_style;
    gchar *def_download_dir;
    guint file_list_refresh;
    guint read_timeout;
    guint num_retries;
    gchar *interface;
    gint num_of_auto_download;
    guint chk_interf_time;
    gboolean use_passive_ftp;
    gchar *command_all_complete;
    gboolean addnew_changes_def_dl_dir;
    gboolean show_list_stat;
    gboolean show_page_stat;
    gboolean confirm_remove_incomplete;
    gboolean confirm_remove_completed;
    gboolean confirm_restart;
    gboolean manual_stop_disables_auto_dl;
    gboolean show_dl_info_page;
    gboolean confirm_dnd_url;
    gboolean use_sound;
    gboolean use_beep;
    gboolean stop_dl_on_link_loss;
    Protocol presume_protocol;
    gboolean load_pause_auto_dl;
    gboolean pause_auto_dl;
    gboolean auto_hide_dl_info_page;
    guint auto_hide_dl_info_page_timeout;
} Preferences;

/* The application used in save_state */
extern GtkWidget *gtm_app;

/* The program preferences */
extern Preferences gtm_pref;

/* The program download list */
extern GtkWidget *dl_file_list;

/* Number of active automatic download */
extern gint num_of_download;

/* ID used on the next file data created */
extern guint next_file_id;

/* Report an event (play sound, beep, run command) */
void report_event (gchar *which);

/* Fork and run arbitrary shell command */
void shell_command (gchar *command);

/* Update the check interface timeout */
void update_check_interface_timeout (guint timeout);

#endif /* _GTM_H */
