/******************************
 Configuration parser
 (c) 1999 Jeremy Wise
 GnomeICU
*******************************/

#include "common.h"
#include "autohide.h"
#include "autoaway.h"
#include "awaymsglist.h"
#include "gnomecfg.h"
#include "gnomeicu.h"
#include "groups.h"
#include "gtkconf.h"
#include "newsignup.h"
#include "response.h"
#include "tcp.h"
#include "util.h"

/*** Local function declarations ***/
static void str2col( GdkColor *color, const gchar *str );
int sort_compare( CONTACT_PTR c1, CONTACT_PTR c2 );
static void save_each_group (GroupInfo *ginfo, gpointer data);

/*** Global functions ***/
void Read_RC_File( void )
{
	char *value, *true_value;
	char *temp_uin;
	char *temp_nick;
	int first = TRUE;

	/* To be used in the new config section */
	void *iter;
	gchar *iterKey = NULL;
	gchar *iterData = NULL;
	gchar *tmp;

	CONTACT_PTR contactdata;

	gchar *version;

	gboolean have_group = FALSE;
        gboolean have_vis = FALSE;
        gboolean have_inv = FALSE;
        gboolean have_ign = FALSE;

#ifdef TRACE_FUNCTION
	g_print( "Read_RC_File\n" );
#endif

	gnome_config_push_prefix( configfilename );

	/* User info */
	if( our_info->uin == 0 ) /* in case it was set in newsignup.c */
	  our_info->uin = gnome_config_get_int( "User/UIN=0" );

	/* Version */
	version = gnome_config_get_string( "User/Version=" );
	if( strcmp( version, VERSION ) )
	{
		/* Do this if they've upgraded */
	}

	g_free( version );

	if( !passwd ) /* ... */
		passwd = gnome_config_private_get_string( "User/Password=" );

	if( !strcmp( passwd, "" ) )
	{
		passwd = gnome_config_get_string( "User/Password=" );
		if( strcmp( passwd, "" ) )
			gnome_config_clean_key( "User/Password" );
	}

	our_info->nick = gnome_config_get_string( "User/Nickname=User" );

	preset_status = gnome_config_get_int( "User/Status=0" );

	g_free( Away_Message );
	Away_Message = gnome_config_get_string( "User/AwayMessage=User is currently away.  Please leave a message and have a great day!" );

	g_free( our_info->first );
	our_info->first = gnome_config_get_string( "User/First" );

	g_free( our_info->last );
	our_info->last = gnome_config_get_string( "User/Last" );

	our_info->sex = gnome_config_get_int( "User/Sex=0" );

	our_info->age = gnome_config_get_int( "User/Age=0" );

	our_info->auth = gnome_config_get_int( "User/Auth=1" );

	our_info->birth_year = gnome_config_get_int( "User/Birth_Year=0" );

	our_info->birth_month = gnome_config_get_int( "User/Birth_Month=1" );

	our_info->birth_day = gnome_config_get_int( "User/Birth_Day=1" );

	g_free( our_info->email );
	our_info->email = gnome_config_get_string( "User/Email" );

	g_free( our_info->phone );
	our_info->phone = gnome_config_get_string( "User/Phone" );

	g_free( our_info->fax );
	our_info->fax = gnome_config_get_string( "User/Fax" );

	g_free( our_info->cellular );
	our_info->cellular = gnome_config_get_string( "User/Cellular" );

	g_free( our_info->street );
	our_info->street = gnome_config_get_string( "User/Street" );

	g_free( our_info->city );
	our_info->city = gnome_config_get_string( "User/City" );

	g_free( our_info->state );
	our_info->state = gnome_config_get_string( "User/State" );

	g_free( our_info->zip );
	our_info->zip = gnome_config_get_string( "User/Zip" );

	our_info->country = gnome_config_get_int( "User/Country=1" );

	our_info->c_status = gnome_config_get_int( "User/C_Status=-500" );

	our_info->hide_email = gnome_config_get_int( "User/Hide_Email=0 " );

	g_free(our_info->homepage);
	our_info->homepage = gnome_config_get_string( "User/Homepage" );

	g_free(our_info->about);
	our_info->about = gnome_config_get_string( "User/About" );

	/* Server info */
	g_free( server );
	server = gnome_config_get_string( "Server_v7/Server=login.icq.com" );

	remote_port = gnome_config_get_int( "Server_v7/Port=5190" );

	min_tcp_port = gnome_config_get_int( "Server/MinTCPPort=4000" );
	max_tcp_port = gnome_config_get_int( "Server/MaxTCPPort=4100" );

	/* Window info */
	sscanf( (tmp=gnome_config_get_string( "Window/Size=160x330" )), "%dx%d", &WindowWidth, &WindowHeight);
	g_free(tmp);

	WindowWidth = (WindowWidth > 500) ? 500 : WindowWidth;
	WindowHeight = (WindowHeight > 1200) ? 1200 : WindowHeight;

	sscanf( (tmp=gnome_config_get_string( "Window/Location=50,50" )), "%d,%d", &WindowX, &WindowY);
	g_free (tmp);

	/* Toggles */
	toggles->sound = gnome_config_get_bool( "Toggles/Sound=true" );
	toggles->sound_onlyonline = gnome_config_get_bool( "Toggles/Sound_OnlyOnline=false" );
	toggles->beep = gnome_config_get_bool( "Toggles/Beep=false" );
	toggles->packet_tcp = gnome_config_get_bool( "Toggles/PacketDumpTCP=false" );
        toggles->packet_udp = gnome_config_get_bool( "Toggles/PacketDumpUDP=false" );
	toggles->autohide = gnome_config_get_bool( "Toggles/AutoHide=false" );
	toggles->connect_startup = gnome_config_get_bool( "Toggles/ConnectStartup=true" );
	toggles->webpresence = gnome_config_get_bool( "Toggles/WebPresence=false" );
	toggles->show_window = gnome_config_get_bool( "Toggles/ShowWindow=false" );
	toggles->latin2 = gnome_config_get_bool ("Toggles/Latin2=false");
	toggles->russian = gnome_config_get_bool( "Toggles/Russian=false" );
	toggles->default_to_chat = gnome_config_get_bool ("Toggles/DefaultChat=true");
	toggles->check_spell = gnome_config_get_bool( "Toggles/Spelling=false" );
	toggles->kanji = gnome_config_get_bool( "Toggles/Kanji=false" );
	toggles->full_reply = gnome_config_get_bool( "Toggles/FullReply=true" );
	toggles->auto_popup = gnome_config_get_bool( "Toggles/AutoPopup=false" );
	toggles->no_new_users = gnome_config_get_bool( "Toggles/NoNewUsers=false" );
	toggles->hidetooltip = gnome_config_get_bool( "Toggles/HideToolTip=false" );
	toggles->status_notify = gnome_config_get_bool ("Toggles/StatusNotify=false" );
	toggles->sort_contacts = gnome_config_get_bool( "Toggles/Sort_Contacts=true" );
	toggles->program_on_receive_message =
		gnome_config_get_bool("Toggles/ProgramOnReceiveMessage=false");
	toggles->program_on_chat_request =
		gnome_config_get_bool( "Toggles/ProgramOnChatRequest=false" );
	toggles->program_on_receive_url =
		gnome_config_get_bool( "Toggles/ProgramOnReceiveURL=false" );
	toggles->program_on_file_request =
		gnome_config_get_bool( "Toggles/ProgramOnFileRequest=false" );
	toggles->program_on_user_online =
		gnome_config_get_bool( "Toggles/ProgramOnUserOnline=false" );
	toggles->program_on_user_offline =
		gnome_config_get_bool( "Toggles/ProgramOnUserOffline=false" );
	toggles->program_on_auth =
		gnome_config_get_bool( "Toggles/ProgramOnAuth=false" );
	toggles->program_on_auth_request =
		gnome_config_get_bool( "Toggles/ProgramOnAuthReq=false" );
	toggles->program_on_list_add =
		gnome_config_get_bool( "Toggles/ProgramOnListAdd=false" );
	toggles->program_on_contact_list =
		gnome_config_get_bool( "Toggles/ProgramOnContactList=false" );
	toggles->auto_away = gnome_config_get_int( "Toggles/AutoAway=10" );
	toggles->auto_na = gnome_config_get_int( "Toggles/AutoNA=20" );
	toggles->use_autoaway = gnome_config_get_bool("Toggles/UseAutoAway=true");
	toggles->auto_accept_xfers = gnome_config_get_bool("Toggles/AutoAcceptXfers=false");
	toggles->auto_accept_path = gnome_config_get_string("Toggles/AutoAcceptPath=~/.icq/Received");
	toggles->auto_recon_forced = gnome_config_get_bool("Toggles/AutoReconForced=false");
	toggles->show_applet_border = gnome_config_get_bool("Toggles/ShowAppletBorder=true");

        toggles->theme_name = gnome_config_get_string( "Toggles/ThemeName=Default" );
	auto_away_message = gnome_config_get_string( "Toggles/AutoAwayMsg=User is Away!" );
	auto_na_message = gnome_config_get_string( "Toggles/AutoNAMsg=User is N/A!" );


	/* Auto Hide */
	autohide_time = gnome_config_get_int( "AutoHide/AutoHideTime=60" );

	/* Chat font */
	g_free(ChatFontString);
	ChatFontString = gnome_config_get_string( "Color/ChatFont=-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1" );

	if( ChatFontString == NULL || !strcmp( ChatFontString, "" ) )
		ChatFontString = g_strdup( "-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1" );

	/* External Programs */
	programs->receive_message =
		gnome_config_get_string( "Programs/OnRecieveMessage" );
	programs->chat_request =
		gnome_config_get_string( "Programs/OnChatRequest" );
	programs->receive_url =
		gnome_config_get_string( "Programs/OnReceiveURL" );
	programs->file_request =
		gnome_config_get_string( "Programs/OnFileRequest" );
	programs->user_online =
		gnome_config_get_string( "Programs/OnUserOnline" );
	programs->user_offline =
		gnome_config_get_string( "Programs/OnUserOffline" );
	programs->auth =
		gnome_config_get_string( "Programs/OnAuth" );
	programs->auth_request =
		gnome_config_get_string( "Programs/OnAuthRequest" );
	programs->list_add =
		gnome_config_get_string( "Programs/OnListAdd" );
	programs->contact_list =
		gnome_config_get_string( "Programs/OnContactList" );

	/* Color section */
	str2col(&color_online, (tmp=gnome_config_get_string( "Color/Online=#000000009a69009a" )) );
	g_free(tmp);
	color_online_set = TRUE;
	str2col(&color_offline, (tmp=gnome_config_get_string( "Color/Offline=#75d675d675d67575" )) );
	g_free(tmp);
	color_offline_set = TRUE;
	str2col(&color_away, (tmp=gnome_config_get_string( "Color/Away=#0000820700008200" )) );
	g_free(tmp);
	color_away_set = TRUE;
	str2col(&color_na, (tmp=gnome_config_get_string( "Color/NotAvailable=#0000820700008200" )) );
	g_free(tmp);
	color_na_set = TRUE;
	str2col(&color_ffc, (tmp=gnome_config_get_string( "Color/FreeForChat=#0000000075300075" )) );
	g_free(tmp);
	color_ffc_set = TRUE;
	str2col(&color_occ, (tmp=gnome_config_get_string( "Color/Occupied=#0000000075300075" )) );
	g_free(tmp);
	color_occ_set = TRUE;
	str2col(&color_dnd, (tmp=gnome_config_get_string( "Color/DoNotDisturb=#0000000075300075" )) );
	g_free(tmp);
	color_dnd_set = TRUE;
	str2col(&color_inv, (tmp=gnome_config_get_string( "Color/Invisible=#9a692ed2810c2e81" )) );
	g_free(tmp);
	color_inv_set = TRUE;

        /* read server side contacts list section (ServerCL) */
	srvlist_exist = gnome_config_get_bool ("ServerCL/exists=false");
	if (srvlist_exist) {
	  list_time_stamp = gnome_config_get_int ("ServerCL/tstamp=0");
	  record_cnt = gnome_config_get_int ("ServerCL/record=0");
          status_uid = gnome_config_get_int ("ServerCL/status_uid=0");
          if (status_uid == 0) { /* don't know s-id, need re-read server list */
            list_time_stamp = 1;
            record_cnt = 1;
          }

          sane_cl = gnome_config_get_bool ("ServerCL/sane=false");
          if (!sane_cl) {
            list_time_stamp = 1;
            record_cnt = 1;
          }
	}

        /* Check if we have groups */
	have_group = gnome_config_has_section ("Groups");
        have_vis = gnome_config_has_section ("Visible");
        have_inv = gnome_config_has_section ("Invisible");
        have_ign = gnome_config_has_section ("Ignore");

	/* New Contacts section */
	if( gnome_config_has_section( "NewContacts" ) )
	{
	  gchar *tmpstr = NULL;
	  guint uinid = 0;
          void *iter2;
          gchar *iterKey2 = NULL;
          gchar *iterData2 = NULL;

		iter = gnome_config_init_iterator( "NewContacts" );
		while( 1 )
		{
			g_free( iterKey );
			g_free( iterData );

			iter = gnome_config_iterator_next( iter, &iterKey, &iterData );

			if( iter == NULL )
				break;
			if( atoi( iterKey ) == 0 )
				continue;
			contactdata = g_new0( Contact_Member, 1 );
			if( strstr( iterData, "Snot" ) ) /* Online Notification */
				contactdata->online_notify = TRUE;
			else
				contactdata->online_notify = FALSE;

			if( strstr( iterData, "Ssrv" ) ) /* Force through server */
				contactdata->force_override = TRUE;
			else
				contactdata->force_override = FALSE;

                        if( strstr( iterData, "Sign" ) ) /* Ignore List */
                          contactdata->ignore_list = TRUE;
                        else
                          contactdata->ignore_list = FALSE;

                        if( strstr( iterData, "Sinv" ) ) /* Invisible List */
                          contactdata->invis_list = TRUE;
                        else if( strstr( iterData, "Svis" ) ) /* Visible List */
                          contactdata->vis_list = TRUE;
			else {
                          contactdata->invis_list = FALSE;
                          contactdata->vis_list = FALSE;
			}

			contactdata->uin = atoi( iterKey );

			if (have_group) {
			  /* have group, that means we have to read uin-id */
			  gchar *eptr;

			  uinid = (guint)strtol (iterData, &eptr, 10);
			  contactdata->uid = uinid;
			  tmpstr = eptr+1;
			} else {
			  tmpstr = iterData;
			}

			if( tmpstr[ 0 ] == ',' )
			  sprintf( contactdata->nick, "%s", iterKey );
			else {
                          if( strchr( tmpstr, ',' ) != NULL )
                            strncpy( contactdata->nick, tmpstr,
                                     ( strchr( tmpstr, ',' ) - tmpstr ) );
                          else
                            strncpy( contactdata->nick, tmpstr,
                                     sizeof( contactdata->nick ) );
                        }

                        if (have_vis) {
                          iter2 = gnome_config_init_iterator ("Visible");
                          while (iter2) {
                            iter2 = gnome_config_iterator_next (iter2, &iterKey2,
                                                                &iterData2);
                            if (iter2 && contactdata->uin == atoi (iterKey2)) {
                              contactdata->vis_list = TRUE;
                              contactdata->vislist_uid = atoi (iterData2);
                              g_free (iterKey2);
                              g_free (iterData2);
                              break;
                            }
                          }
                        }

                        if (have_inv) {
                          iter2 = gnome_config_init_iterator ("Invisible");
                          while (iter2) {
                            iter2 = gnome_config_iterator_next (iter2, &iterKey2,
                                                                &iterData2);
                            if (iter2 && contactdata->uin == atoi (iterKey2)) {
                              contactdata->invis_list = TRUE;
                              contactdata->invlist_uid = atoi (iterData2);
                              g_free (iterKey2);
                              g_free (iterData2);
                              break;
                            }
                          }
                        }

                        if (have_ign) {
                          iter2 = gnome_config_init_iterator ("Ignore");
                          while (iter2) {
                            iter2 = gnome_config_iterator_next (iter2, &iterKey2,
                                                                &iterData2);
                            if (iter2 && contactdata->uin == atoi (iterKey2)) {
                              contactdata->ignore_list = TRUE;
                              contactdata->ignorelist_uid = atoi (iterData2);
                              g_free (iterKey2);
                              g_free (iterData2);
                              break;
                            }
                          }
                        }

			contactdata->sok = 0;
			contactdata->chat_requests = NULL;
			contactdata->stored_messages = NULL;
			contactdata->status = STATUS_OFFLINE;
			contactdata->last_time = -1L;
			contactdata->current_ip = -1L;
			contactdata->show_again = TRUE;
			contactdata->info = g_new0( USER_INFO_STRUCT, 1 );
			((USER_INFO_STRUCT*)contactdata->info)->sex = -1;
			contactdata->inlist = TRUE;
			contactdata->tcp_seq = -1;
			contactdata->msg_dlg_xml = NULL;
			contactdata->confirmed = TRUE;

			Contacts = g_slist_insert_sorted( Contacts, contactdata, (GCompareFunc)sort_compare );
		}
	}

	/* Contacts section */
	else
	{
		value = gnome_config_get_string( "Contacts/Contacts=" );

		true_value = value;

		while( ( temp_uin = strtok( ( first ? value : NULL ), "," ) ) != NULL )
		{
			first = FALSE;
			temp_nick = strtok( NULL, "," );

			contactdata = g_new0( Contact_Member, 1 );

			if( temp_uin[ 0 ] == '*' )
			{
				contactdata->invis_list = TRUE;
				contactdata->uin = atoi( &temp_uin[ 1 ] );
			}
			else if( temp_uin[ 0 ] == '~' )
			{
				contactdata->vis_list = TRUE;
				contactdata->uin = atoi( &temp_uin[ 1 ] );
			}
			else
			{
				contactdata->invis_list = FALSE;
				contactdata->vis_list = FALSE;
				contactdata->uin = atoi( temp_uin );
			}
			contactdata->sok = 0;
			contactdata->chat_requests = NULL;
			contactdata->status = STATUS_OFFLINE;
			contactdata->last_time = -1L;
			contactdata->current_ip = -1L;
			contactdata->show_again = TRUE;
			contactdata->info = g_new0( USER_INFO_STRUCT, 1 );
			contactdata->msg_dlg_xml = NULL;
			contactdata->tcp_seq = -1;

			if( temp_nick )
			{
				strncpy( contactdata->nick, temp_nick, sizeof(contactdata->nick)-1);
				contactdata->nick[ sizeof( contactdata->nick ) - 1 ] = 0;
			}
			else
				contactdata->nick[ 0 ] = 0;

			Contacts = g_slist_prepend( Contacts, contactdata );
		}

		Contacts = g_slist_reverse( Contacts );

		g_free( true_value );
	}

	if (have_group == FALSE) {
	  /* force a re-read of the server contacts list, to update group info */
	  if (srvlist_exist)
	    list_time_stamp = record_cnt = 0;
	} else { /* we have groups, read it */
	  /* format:
	   *   groupid=grpname,count,uinid1,uinid2...
	   */
	  gchar *grpname;
	  gint user_cnt, grp_cnt=0;
	  gint loop_cnt;
	  gchar *tmpstr;
	  guint gid, uid;

	  iter = gnome_config_init_iterator ("Groups");
	  g_free (iterKey);
	  g_free (iterData);
	  while ( (iter = gnome_config_iterator_next (iter, &iterKey, &iterData)) != NULL) {
	    grp_cnt++;
	    /* read group id */
	    grpname = g_strndup (iterData, strchr (iterData, ',') - iterData);
	    gid = atoi (iterKey);
	    groups_add (grpname, gid);
 
	    /* get number of user belong to this group */
	    user_cnt = strtol (strchr (iterData, ',') + 1, NULL, 10);

	    /* get all the uin-id relate to this group */
	    tmpstr = strchr (strchr (iterData, ',')+1, ',')+1;
	    for (loop_cnt = 0; loop_cnt < user_cnt; loop_cnt++) {
              GSList *contact;
	      uid = (guint) strtol (tmpstr, NULL, 10);
              
              contact = Find_User_uid(uid);
              if (contact)
                kontakt->gid = gid;
	      tmpstr = strchr (tmpstr, ',') + 1;
	    }

	    g_free (grpname);
	    g_free (iterKey);
	    g_free (iterData);
	  }
	  if (grp_cnt == 0)
	    have_group = FALSE;
	}



	/* Here we get all of the away messages */
	get_config_file_away_msgs();
	/* End get all of the away messages */

	gnome_config_pop_prefix();

	return;
}

void Initialize_RC_File( void )
{
	gchar *path = NULL;
#ifdef TRACE_FUNCTION
	g_print( "Initialize_RC_File\n" );
#endif

	path = g_strdup_printf("%s/.icq", g_get_home_dir() );
	if(mkdir(path, 0700))
	    switch(errno)
	      {
	      case EEXIST: break;
	      default: g_warning(PACKAGE "mkdir:%s:%s", path, g_strerror(errno) );
	      }
	g_free(path);

	path = g_strdup_printf("%s/.icq/history", g_get_home_dir() );
	if(mkdir(path, 0700))
	    switch(errno)
	      {
	      case EEXIST: break;
	      default: g_warning(PACKAGE "mkdir:%s:%s", path, g_strerror(errno) );
	      }
	g_free(path);

	NewUserSignup();

	return;
}

void save_user_info (void)
{
	gnome_config_set_string ("User/First", our_info->first);
	gnome_config_set_string ("User/Last", our_info->last);
	gnome_config_set_int ("User/Sex", our_info->sex);
	gnome_config_set_int ("User/Age", our_info->age);
	gnome_config_set_int ("User/Auth", our_info->auth);
	gnome_config_set_int ("User/Birth_Year", our_info->birth_year);
	gnome_config_set_int ("User/Birth_Month", our_info->birth_month);
	gnome_config_set_int ("User/Birth_Day", our_info->birth_day);
	gnome_config_set_string ("User/Email", our_info->email);
	gnome_config_set_string ("User/Phone", our_info->phone);
	gnome_config_set_string ("User/Fax", our_info->fax);
	gnome_config_set_string ("User/Cellular", our_info->cellular);
	gnome_config_set_string ("User/Street", our_info->street);
	gnome_config_set_string ("User/City", our_info->city);
	gnome_config_set_string ("User/State", our_info->state);
	gnome_config_set_string ("User/Zip", our_info->zip);
	gnome_config_set_int ("User/Country", our_info->country);
	gnome_config_set_int ("User/C_Status", our_info->c_status);
	gnome_config_set_string ("User/Homepage", our_info->homepage);
	gnome_config_set_string ("User/About", our_info->about);
	gnome_config_set_int ("User/Hide_Email", our_info->hide_email);
}

void save_preferences (void)
{
	char str[18];

	/* User info */
	gnome_config_set_int ("User/UIN", our_info->uin);
	gnome_config_set_string ("User/Nickname", our_info->nick);
	gnome_config_private_set_string ("User/Password", passwd);

	/* Server info */
	gnome_config_set_string ("Server_v7/Server", server);
	gnome_config_set_int ("Server_v7/Port", remote_port);
	gnome_config_set_bool ("Toggles/ConnectStartup",
			       toggles->connect_startup);
	gnome_config_set_bool ("Toggles/AutoReconForced",
			       toggles->auto_recon_forced);

	/* TCP range */
	gnome_config_set_int ("Server/MinTCPPort", min_tcp_port);
	gnome_config_set_int ("Server/MaxTCPPort", max_tcp_port);

	/* Packets */
	gnome_config_set_bool ("Toggles/Russian", toggles->russian);
	gnome_config_set_bool ("Toggles/Kanji", toggles->kanji);
	gnome_config_set_bool ("Toggles/Latin2", toggles->latin2);
	gnome_config_set_bool ("Toggles/NoNewUsers", toggles->no_new_users);

	/* Sounds */
	gnome_config_set_bool ("Toggles/Sound", toggles->sound);
	gnome_config_set_bool ("Toggles/Sound_OnlyOnline",
			       toggles->sound_onlyonline);
	gnome_config_set_bool ("Toggles/Beep", toggles->beep);

	/* External Programs */
	gnome_config_set_string ("Programs/OnRecieveMessage",
				 programs->receive_message);
	gnome_config_set_string ("Programs/OnChatRequest",
				 programs->chat_request);
	gnome_config_set_string ("Programs/OnReceiveURL",
				 programs->receive_url);
	gnome_config_set_string ("Programs/OnFileRequest",
				 programs->file_request);
	gnome_config_set_string ("Programs/OnUserOnline",
				 programs->user_online);
	gnome_config_set_string ("Programs/OnUserOffline",
				 programs->user_offline);
	gnome_config_set_string ("Programs/OnAuth", programs->auth);
	gnome_config_set_string ("Programs/OnAuthRequest",
				 programs->auth_request);
	gnome_config_set_string ("Programs/OnListAdd", programs->list_add);
	gnome_config_set_string ("Programs/OnContactList",
				 programs->contact_list);
	gnome_config_set_bool ("Toggles/ProgramOnReceiveMessage",
			       toggles->program_on_receive_message);
	gnome_config_set_bool ("Toggles/ProgramOnChatRequest",
			       toggles->program_on_chat_request);
	gnome_config_set_bool ("Toggles/ProgramOnReceiveURL",
			       toggles->program_on_receive_url);
	gnome_config_set_bool ("Toggles/ProgramOnFileRequest",
			       toggles->program_on_file_request);
	gnome_config_set_bool ("Toggles/ProgramOnUserOnline",
			       toggles->program_on_user_online);
	gnome_config_set_bool ("Toggles/ProgramOnUserOffline",
			       toggles->program_on_user_offline);
	gnome_config_set_bool ("Toggles/ProgramOnAuth",
			       toggles->program_on_auth);
	gnome_config_set_bool ("Toggles/ProgramOnAuthReq",
			       toggles->program_on_auth_request);
	gnome_config_set_bool ("Toggles/ProgramOnListAdd",
			       toggles->program_on_list_add);
	gnome_config_set_bool ("Toggles/ProgramOnContactList",
			       toggles->program_on_contact_list);

	/* Write the away messages to the config file */
	set_config_file_away_msgs ();

	/* Autoaway options */
	gnome_config_set_bool ("Toggles/UseAutoAway", toggles->use_autoaway);
	gnome_config_set_string ("Toggles/AutoAwayMsg", auto_away_message);
	gnome_config_set_string ("Toggles/AutoNAMsg", auto_na_message);
	gnome_config_set_int ("Toggles/AutoAway", toggles->auto_away);
	gnome_config_set_int ("Toggles/AutoNA", toggles->auto_na);

	/* Color Section */
	sprintf (str, "#%04hx%04hx%04hx%04hx",
		 color_online.red & 0xffff,
		 color_online.green & 0xffff,
		 color_online.blue & 0xffff,
		 (unsigned int) color_online.pixel & 0xffff);
	gnome_config_set_string ("Color/Online", str);

	sprintf (str, "#%04hx%04hx%04hx%04hx",
		 color_offline.red & 0xffff,
		 color_offline.green & 0xffff,
		 color_offline.blue & 0xffff,
		 (unsigned int) color_offline.pixel & 0xffff);
	gnome_config_set_string ("Color/Offline", str);

	sprintf (str, "#%04hx%04hx%04hx%04hx",
		 color_away.red & 0xffff,
		 color_away.green & 0xffff,
		 color_away.blue & 0xffff,
		 (unsigned int) color_away.pixel & 0xffff);
	gnome_config_set_string ("Color/Away", str);

	sprintf (str, "#%04hx%04hx%04hx%04hx",
		 color_na.red & 0xffff,
		 color_na.green & 0xffff,
		 color_na.blue & 0xffff,
		 (unsigned int) color_na.pixel & 0xffff);
	gnome_config_set_string ("Color/NotAvailable", str);

	sprintf (str, "#%04hx%04hx%04hx%04hx",
		 color_ffc.red & 0xffff,
		 color_ffc.green & 0xffff,
		 color_ffc.blue & 0xffff,
		 (unsigned int) color_ffc.pixel & 0xffff);
	gnome_config_set_string ("Color/FreeForChat", str);

	sprintf (str, "#%04hx%04hx%04hx%04hx",
		 color_occ.red & 0xffff,
		 color_occ.green & 0xffff,
		 color_occ.blue & 0xffff,
		 (unsigned int) color_occ.pixel & 0xffff);
	gnome_config_set_string ("Color/Occupied", str);

	sprintf (str, "#%04hx%04hx%04hx%04hx",
		 color_dnd.red & 0xffff,
		 color_dnd.green & 0xffff,
		 color_dnd.blue & 0xffff,
		 (unsigned int) color_dnd.pixel & 0xffff);
	gnome_config_set_string ("Color/DoNotDisturb", str);

	sprintf (str, "#%04hx%04hx%04hx%04hx",
		 color_inv.red & 0xffff,
		 color_inv.green & 0xffff,
		 color_inv.blue & 0xffff,
		 (unsigned int) color_inv.pixel & 0xffff);
	gnome_config_set_string ("Color/Invisible", str);

	gnome_config_set_string ("Toggles/ThemeName", toggles->theme_name);

	/* Applet toggles */
	gnome_config_set_bool ("Toggles/ShowAppletBorder",
			       toggles->show_applet_border);
	gnome_config_set_bool ("Toggles/HideToolTip", toggles->hidetooltip);

	/* Misc options */
	gnome_config_set_bool ("Toggles/ShowWindow", toggles->show_window);
	gnome_config_set_bool ("Toggles/AutoHide", toggles->autohide);
	gnome_config_set_int ("AutoHide/AutoHideTime", autohide_time);
	gnome_config_set_bool ("Toggles/AutoPopup", toggles->auto_popup);
	gnome_config_set_bool ("Toggles/FullReply", toggles->full_reply);
	gnome_config_set_bool ("Toggles/StatusNotify", toggles->status_notify);
	gnome_config_set_bool ("Toggles/Sort_Contacts", toggles->sort_contacts);
	gnome_config_set_bool ("Toggles/WebPresence", toggles->webpresence);
	gnome_config_set_bool ("Toggles/Spelling", toggles->check_spell);
	gnome_config_set_bool ("Toggles/DefaultChat", toggles->default_to_chat);
	gnome_config_set_bool ("Toggles/AutoAcceptXfers",
			       toggles->auto_accept_xfers);
	gnome_config_set_string ("Toggles/AutoAcceptPath",
				 toggles->auto_accept_path);

	gnome_config_set_bool ("Toggles/PacketDumpTCP", toggles->packet_tcp);
	gnome_config_set_bool ("Toggles/DumpPacketUDP",
			       toggles->packet_udp);

	/* server side contacts list */
	gnome_config_set_bool ("ServerCL/exists", srvlist_exist);
	gnome_config_set_int ("ServerCL/tstamp", list_time_stamp);
	gnome_config_set_int ("ServerCL/record", record_cnt);
        gnome_config_set_int ("ServerCL/status_uid", status_uid);
        gnome_config_set_bool ("ServerCL/sane", sane_cl);
}

void Save_RC( void )
{
	char str[10];
	char *contactKey, *contactStr;

	GSList *contact;

	gnome_config_push_prefix( configfilename );

#ifdef TRACE_FUNCTION
	g_print( "Save_RC\n" );
#endif

	/* User info */
	gnome_config_set_string( "User/Version", VERSION );
	gnome_config_set_int( "User/Status", ( Current_Status != STATUS_OFFLINE ? Current_Status : STATUS_ONLINE ) );
	gnome_config_set_string( "User/AwayMessage", Away_Message );

	/* Window info */
	sprintf (str, "%dx%d", WindowWidth, WindowHeight);
	gnome_config_set_string ("Window/Size", str);

	sprintf (str, "%d,%d", WindowX, WindowY);
	gnome_config_set_string ("Window/Location", str);

	/* Chat font */
	gnome_config_set_string( "Color/ChatFont", ChatFontString );

	/* Groups section */
	gnome_config_clean_section ("Groups");
        g_slist_foreach(Groups, (GFunc) save_each_group, NULL);

        gnome_config_clean_section ("Visible");
        gnome_config_clean_section ("Invisible");
        gnome_config_clean_section ("Ignore");

	/* New Contact Section */
	gnome_config_clean_section( "NewContacts" );

	contact = Contacts;

	while( contact != NULL )
	{
		if( kontakt->inlist == FALSE )
		{
			contact = contact->next;
			continue;
		}

                if (kontakt->vis_list) {
                  contactKey = g_strdup_printf ("Visible/%u", kontakt->uin);
                  contactStr = g_strdup_printf ("%d", kontakt->vislist_uid);
                  gnome_config_set_string (contactKey, contactStr);
                  g_free( contactKey );
                  g_free( contactStr );
                }

                if (kontakt->invis_list) {
                  contactKey = g_strdup_printf ("Invisible/%u", kontakt->uin);
                  contactStr = g_strdup_printf ("%d", kontakt->invlist_uid);
                  gnome_config_set_string (contactKey, contactStr);
                  g_free( contactKey );
                  g_free( contactStr );
                }

                if (kontakt->ignore_list) {
                  contactKey = g_strdup_printf ("Ignore/%u", kontakt->uin);
                  contactStr = g_strdup_printf ("%d", kontakt->ignorelist_uid);
                  gnome_config_set_string (contactKey, contactStr);
                  g_free( contactKey );
                  g_free( contactStr );
                }

                if (kontakt->uid == 0) {
                  contact = contact->next;
                  continue;
                }
                  
		contactKey = g_strdup_printf( "NewContacts/%u",
					      kontakt->uin );

		contactStr = g_strdup_printf( "%d,%s%s%s%s",
        /* start with uin-id */
                                              kontakt->uid,
	/* then nickname */
					      kontakt->nick,

	/* If we append ANYTHING, we need a comma here */
					      ( kontakt->force_override ||
		                 kontakt->online_notify ? "," : "" ),

	/* If we're forcing their messages thru server, we append Ssrv */
	                  ( kontakt->force_override ? "Ssrv" : "" ),

	/* If they're on the notify list, we append Snot here */
		               ( kontakt->online_notify ? "Snot" : "" ) );

		gnome_config_set_string( contactKey, contactStr );
		g_free( contactKey );
		g_free( contactStr );
		contact = contact->next;
	}

	gnome_config_set_int( "Existence/exists", 1 );

	gnome_config_sync();

	gnome_config_pop_prefix();

	return;
}

/*** Local functions ***/
void str2col(GdkColor *color, const gchar *str) {
    guint r, g, b;
    guint pix;

    sscanf(str, "#%04x%04x%04x%04x", &r, &g, &b, &pix);
    color->red = r;
    color->green = g;
    color->blue = b;
    color->pixel = pix;
}

int sort_compare( CONTACT_PTR c1, CONTACT_PTR c2 )
{
	return strcoll( c1->nick, c2->nick );
}

void save_each_group (GroupInfo *ginfo, gpointer udata)
{
  gchar *tmpstr, *tmpstr2 = "";
  gchar *keystr;
  GSList *contact;
  int count = 0;

  for (contact = Contacts; contact != NULL; contact = contact->next)
    if (kontakt->gid == ginfo->gid) {
      tmpstr2 = g_strdup_printf ("%s,%d", tmpstr2, kontakt->uid);
      count++;
    }
  
  if (count == 0) {
    keystr = g_strdup_printf ("Groups/%d", ginfo->gid);
    tmpstr = g_strdup_printf ("%s,0", ginfo->name);
    gnome_config_set_string (keystr, tmpstr);
    g_free (keystr);
    g_free (tmpstr);
    return;
  }

  tmpstr = g_strdup_printf ("%s,%d%s", ginfo->name, count, tmpstr2);

  keystr = g_strdup_printf ("Groups/%d", ginfo->gid);
  gnome_config_set_string (keystr, tmpstr);

  g_free (keystr);
  g_free (tmpstr);
  g_free (tmpstr2);
}
