#!/bin/sh

# libmove sourcelib targetlib
#
# This allows you to move a new shared library into place,
# even on a running system.
libmove() {
  LIBSOURCE=$1
  LIBTARGET=$2
  LIBFOO="`dirname $LIBTARGET`/libfoo.so.0.0.0"
  # link duplicate of target lib so we can safely copy over it:
  if [ -r $LIBTARGET ]; then
    cp -a $LIBTARGET $LIBFOO
    if [ -x /sbin/ldconfig ]; then
      ldconfig -l $LIBFOO 2> /dev/null
    fi
  fi
  mv $LIBSOURCE $LIBTARGET
  if [ -x /sbin/ldconfig ]; then
    ldconfig -l $LIBTARGET 2> /dev/null
  fi
  rm -f $LIBFOO
}

# Before using libmove, try to install everything we can:
( cd lib/incoming
  for file in * ; do
    if [ ! -r ../$file ]; then
      cp -a $file ..
    fi
  done )
if [ -x /sbin/ldconfig ]; then
  /sbin/ldconfig
fi

( cd lib/incoming
  for file in * ; do
    libmove $file ../$file
  done )
#### Now, get rid of the temporary directory:
rm -rf lib/incoming

if [ -x /sbin/ldconfig ]; then
  ( cd lib ; /sbin/ldconfig . )
else # In case there's no ldconfig, make the links manually:
( cd lib ; rm -rf ld-linux.so.2 )
( cd lib ; ln -sf ld-2.2.5.so ld-linux.so.2 )
( cd lib ; rm -rf libc.so.6 )
( cd lib ; ln -sf libc-2.2.5.so libc.so.6 )
( cd lib ; rm -rf libBrokenLocale.so.1 )
( cd lib ; ln -sf libBrokenLocale-2.2.5.so libBrokenLocale.so.1 )
( cd lib ; rm -rf libm.so.6 )
( cd lib ; ln -sf libm-2.2.5.so libm.so.6 )
( cd lib ; rm -rf libdl.so.2 )
( cd lib ; ln -sf libdl-2.2.5.so libdl.so.2 )
( cd lib ; rm -rf libcrypt.so.1 )
( cd lib ; ln -sf libcrypt-2.2.5.so libcrypt.so.1 )
( cd lib ; rm -rf libpthread.so.0 )
( cd lib ; ln -sf libpthread-0.9.so libpthread.so.0 )
( cd lib ; rm -rf libresolv.so.2 )
( cd lib ; ln -sf libresolv-2.2.5.so libresolv.so.2 )
( cd lib ; rm -rf libnss_dns.so.2 )
( cd lib ; ln -sf libnss_dns-2.2.5.so libnss_dns.so.2 )
( cd lib ; rm -rf libanl.so.1 )
( cd lib ; ln -sf libanl-2.2.5.so libanl.so.1 )
( cd lib ; rm -rf libnss_files.so.2 )
( cd lib ; ln -sf libnss_files-2.2.5.so libnss_files.so.2 )
( cd lib ; rm -rf librt.so.1 )
( cd lib ; ln -sf librt-2.2.5.so librt.so.1 )
( cd lib ; rm -rf libthread_db.so.1 )
( cd lib ; ln -sf libthread_db-1.0.so libthread_db.so.1 )
( cd lib ; rm -rf libnss_hesiod.so.2 )
( cd lib ; ln -sf libnss_hesiod-2.2.5.so libnss_hesiod.so.2 )
( cd lib ; rm -rf libnsl.so.1 )
( cd lib ; ln -sf libnsl-2.2.5.so libnsl.so.1 )
( cd lib ; rm -rf libnss_nis.so.2 )
( cd lib ; ln -sf libnss_nis-2.2.5.so libnss_nis.so.2 )
( cd lib ; rm -rf libnss_nisplus.so.2 )
( cd lib ; ln -sf libnss_nisplus-2.2.5.so libnss_nisplus.so.2 )
( cd lib ; rm -rf libnss_compat.so.2 )
( cd lib ; ln -sf libnss_compat-2.2.5.so libnss_compat.so.2 )
( cd lib ; rm -rf libutil.so.1 )
( cd lib ; ln -sf libutil-2.2.5.so libutil.so.1 )
( cd lib ; rm -rf libdb.so.2 )
( cd lib ; ln -sf libdb1.so.2.1.3 libdb.so.2 )
( cd lib ; rm -rf libdb.so.3 )
( cd lib ; ln -sf libdb2.so.3 libdb.so.3 )
( cd lib ; rm -rf libdb1.so.2 )
( cd lib ; ln -sf libdb1.so.2.1.3 libdb1.so.2 )
( cd lib ; rm -rf libdb.so )
( cd lib ; ln -sf libdb-3.1.so libdb.so )
( cd lib ; rm -rf libnss_db.so.2 )
( cd lib ; ln -sf libnss_db-2.2.so libnss_db.so.2 )
fi

# Handle BSD DB links:
( cd lib ; rm -rf libdb.so )
( cd lib ; ln -sf libdb-3.1.so libdb.so )
( cd lib ; rm -rf libdb1.so.2 )
( cd lib ; ln -sf libdb1.so.2.1.3 libdb1.so.2 )
