/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2002 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * types.h - structs and defines used in the program
 */

#ifndef _TYPES_H
#define _TYPES_H 1

/* preferences saved to ~/.xlog/preferences */
typedef struct {
	gchar *version;
	gint x;
	gint y;
	gint width;
	gint height;
	gdouble latitude;
	gint NS;
	gdouble longitude;
	gint EW;
	gint units; /* kilometers or nautical miles */
	gchar *modes;
	gchar *bands;
	gint bandseditbox; /* optionmenu or entry for bands? */
	gint modeseditbox; /* optionmenu or entry modes? */
	gint printall;
	gint printsize;
	gint printpoint;
	gint printstyle;
	gint printdestination;
	gchar *columnsizes;
	gint hamlib; /* hamlib enabled?	0 = no, 1 = yes, 2 = display freq on statusbar */
	gchar *radio; /* what type of radio do you use? */
	gchar *device; /* which serial port does it use? */
	gint round; /* how many digits to round to */
	gint clock; /* clock on the statusbar? */
	gchar *themecolor;
	gint logcolor; /* do we want to color the log? */
	gint autosave;
	gchar *savedir;
	gchar *logstoload;
} preferencestype;

/* structure used for program state */
typedef struct {
	gint minorversion;
	gint majorversion;
	gint sortclicked; /* how the log is sorted */
	gchar *mylocation;
	gint countries;
	gint qsos; /* number of qso's read from the logs */
	gint prefixes;
	gboolean controlkey; /* control key is pressed */
	gchar *rigfrequency; /* frequency read from the rig */
	gchar *rigmode; /* mode read from the rig */
	gchar *rigrst; /* signal strength read from rig */
	gint scounter; /* counter for s-levels stored in array */
	gint hlcounter; /* counter for hamlib */
	gboolean tx; /* transmitting or receiving */
	gboolean statustimer; /* 'ready' timer for the statusbar */
	gint shmid; /* id for shared memory */
	gint logwindows; /*number of logwindows */
} statetype;

/* struct for remote data state */
typedef struct {
	gint version;
	gchar *program;
	gint nr;
} remotetype;

/* struct for the message queue */
typedef struct {
	glong mtype;
	gchar mtext[1024];
} msgtype;

/* fields for the qso array */
#define QSO_FIELDS 11
#define NR 0
#define DATE 1
#define GMT 2
#define CALL 3
#define BAND 4
#define MODE 5
#define RST 6
#define MYRST 7
#define QSLOUT 8
#define QSLIN 9
#define REMARKS 10
#define POWER  11
#define GMTEND  12

/* a number larger than 0 denotes a beta version */
#define betaversion 0

#endif /* _TYPES_H */
