/*
 * Decompiled with CFR 0.152.
 */
package sun.net.spi.nameservice.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import sun.net.spi.nameservice.NameService;
import sun.security.action.GetPropertyAction;

public final class DNSNameService
implements NameService {
    private DirContext ctx;

    public DNSNameService() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.net.spi.nameservice.nameservers"));
        if (string == null || string.length() == 0) {
            throw new NamingException("no nameservers provided");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append("dns://" + string2 + " ");
        }
        properties.setProperty("java.naming.provider.url", stringBuffer.toString());
        this.ctx = new InitialDirContext(properties);
    }

    private Map resolve(String string, String[] stringArray) throws NamingException {
        HashMap hashMap = new HashMap();
        Attributes attributes = null;
        attributes = this.ctx.getAttributes(string, stringArray);
        if (attributes == null) {
            return null;
        }
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
            Attribute attribute = namingEnumeration.next();
            String string2 = attribute.getID();
            ArrayList<String> arrayList = new ArrayList<String>();
            NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
            while (namingEnumeration2.hasMoreElements()) {
                String string3 = (String)namingEnumeration2.nextElement();
                arrayList.add(string3);
            }
            hashMap.put(string2, arrayList);
        }
        return hashMap;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public byte[][] lookupAllHostAddr(String var1_1) throws UnknownHostException {
        block9: {
            var2_2 = new String[]{"A", "AAAA", "CNAME"};
            var3_3 = AccessController.doPrivileged(new GetPropertyAction("sun.net.spi.nameservice.domain"));
            var4_4 = null;
            try {
                var4_4 = this.resolve(var1_1, var2_2);
                break block9;
            }
            catch (Exception var5_5) {
                if (var3_3 == null) {
                    throw new UnknownHostException(var5_5.getMessage());
                }
                var6_7 /* !! */  = null;
                var7_8 = var3_3;
                var8_10 = 0;
                ** while ((var8_10 = var7_8.indexOf((String)".")) != -1 && var8_10 < var7_8.length() - 1)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var4_4 = this.resolve(var1_1 + "." + var7_8, var2_2);
                    var6_7 /* !! */  = null;
                    break;
                }
                catch (Exception var9_12) {
                    var7_8 = var7_8.substring(var8_10 + 1);
                    var6_7 /* !! */  = new UnknownHostException(var9_12.getMessage());
                }
                continue;
            }
lbl22:
            // 2 sources

            if (var6_7 /* !! */  != null) {
                throw var6_7 /* !! */ ;
            }
        }
        if (var4_4 == null) {
            throw new UnknownHostException(var1_1);
        }
        var5_6 = var4_4.entrySet();
        var6_7 /* !! */  = new ArrayList<byte[]>();
        var7_9 = false;
        var8_11 = var5_6.iterator();
        while (var8_11.hasNext()) {
            var9_13 = var8_11.next();
            var6_7 /* !! */ .add(InetAddress.getByName((String)((ArrayList)var9_13.getValue()).get(0)).getAddress());
        }
        var9_13 = new byte[var6_7 /* !! */ .size()][];
        return (byte[][])var6_7 /* !! */ .toArray((T[])var9_13);
    }

    public String getHostByAddr(byte[] byArray) throws UnknownHostException {
        try {
            int n;
            String string = "";
            if (byArray.length == 4) {
                n = byArray.length - 1;
                while (n >= 0) {
                    string = string + (byArray[n] & 0xFF) + ".";
                    --n;
                }
            } else if (byArray.length == 16) {
                n = byArray.length - 1;
                while (n >= 0) {
                    string = string + (byArray[n] & 0xF) + "." + (byArray[n] & 0xF0) + ".";
                    --n;
                }
            }
            if (byArray.length == 4) {
                string = string + "IN-ADDR.ARPA.";
            } else if (byArray.length == 16) {
                string = string + "IP6.INT.";
            }
            String[] stringArray = new String[]{"PTR"};
            Map map = this.resolve(string, stringArray);
            Set set = map.entrySet();
            String string2 = "";
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                string2 = (String)((ArrayList)entry.getValue()).get(0);
            }
            return string2;
        }
        catch (Exception exception) {
            throw new UnknownHostException(exception.getMessage());
        }
    }
}

