/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.LogStream;
import java.rmi.server.RMISocketFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.proxy.RMIDirectSocketFactory;
import sun.rmi.transport.proxy.RMIHttpToCGISocketFactory;
import sun.rmi.transport.proxy.RMIHttpToPortSocketFactory;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetLongAction;
import sun.security.action.GetPropertyAction;

public class RMIMasterSocketFactory
extends RMISocketFactory {
    static int logLevel = LogStream.parseLevel(RMIMasterSocketFactory.getLogLevel());
    static final Log proxyLog = Log.getLog("sun.rmi.transport.tcp.proxy", "transport", logLevel);
    private static long connectTimeout = RMIMasterSocketFactory.getConnectTimeout();
    private Hashtable successTable = new Hashtable();
    private static final int MaxRememberedHosts = 64;
    private Vector hostList = new Vector(64);
    protected RMISocketFactory initialFactory = new RMIDirectSocketFactory();
    protected Vector altFactoryList = new Vector(2);

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.proxy.logLevel"));
    }

    private static long getConnectTimeout() {
        return (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.transport.proxy.connectTimeout", 15000L));
    }

    public RMIMasterSocketFactory() {
        boolean bl2 = false;
        try {
            Boolean bl3;
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("http.proxyHost"));
            if (string == null) {
                string = (String)AccessController.doPrivileged(new GetPropertyAction("proxyHost"));
            }
            if (!(bl3 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.disableHttp"))).booleanValue() && string != null && string.length() > 0) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            bl2 = true;
        }
        if (bl2) {
            this.altFactoryList.addElement(new RMIHttpToPortSocketFactory());
            this.altFactoryList.addElement(new RMIHttpToCGISocketFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Socket createSocket(String var1_1, int var2_2) throws IOException {
        block42: {
            if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) {
                RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "host: " + var1_1 + ", port: " + var2_2);
            }
            if (this.altFactoryList.size() == 0) {
                return this.initialFactory.createSocket(var1_1, var2_2);
            }
            var3_3 = (RMISocketFactory)this.successTable.get(var1_1);
            if (var3_3 != null) {
                if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF) == false) return var3_3.createSocket(var1_1, var2_2);
                RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "previously successful factory found: " + var3_3);
                return var3_3.createSocket(var1_1, var2_2);
            }
            var4_4 = null;
            var5_5 = null;
            var6_6 = new AsyncConnector(this.initialFactory, var1_1, var2_2, AccessController.getContext());
            var7_7 /* !! */  = null;
            try {
                try {
                    var8_8 = var6_6;
                    synchronized (var8_8) {
                        var9_11 = (Thread)AccessController.doPrivileged(new NewThreadAction(var6_6, "AsyncConnector", true));
                        var9_11.start();
                        try {
                            var6_6.wait(RMIMasterSocketFactory.connectTimeout);
                        }
                        catch (InterruptedException var10_15) {
                            // empty catch block
                        }
                        var4_4 = this.checkConnector(var6_6);
                        ** if (var4_4 != null) goto lbl28
                    }
lbl-1000:
                    // 1 sources

                    {
                        throw new NoRouteToHostException("connect timed out: " + var1_1);
                    }
lbl28:
                    // 1 sources

                    RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "direct socket connection successful");
                    var9_11 = var4_4;
                    var13_17 = null;
                    if (var7_7 /* !! */  == null) return var9_11;
                    if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) {
                        RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "direct socket connection failed: ", var7_7 /* !! */ );
                    }
                    var14_21 = 0;
                    if (true) ** GOTO lbl86
                }
                catch (UnknownHostException var8_9) {
                    var7_7 /* !! */  = var8_9;
                    var13_18 = null;
                    if (var7_7 /* !! */  == null) break block42;
                    if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) {
                        RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "direct socket connection failed: ", var7_7 /* !! */ );
                    }
                    var14_22 = 0;
                    if (true) ** GOTO lbl111
                }
                catch (NoRouteToHostException var9_12) {
                    var7_7 /* !! */  = var9_12;
                    var13_19 = null;
                    if (var7_7 /* !! */  == null) break block42;
                    if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) {
                        RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "direct socket connection failed: ", var7_7 /* !! */ );
                    }
                    var14_23 = 0;
                    if (true) ** GOTO lbl136
                }
            }
            catch (Throwable var12_37) {
                var13_20 = null;
                if (var7_7 /* !! */  == null) throw var12_37;
                if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) {
                    RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "direct socket connection failed: ", var7_7 /* !! */ );
                }
                var14_24 = 0;
                if (true) ** GOTO lbl181
            }
            do {
                block44: {
                    var3_3 = (RMISocketFactory)this.altFactoryList.elementAt(var14_21);
                    try {
                        if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) {
                            RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "trying with factory: " + var3_3);
                        }
                        var15_25 = var3_3.createSocket(var1_1, var2_2);
                        var16_29 = var15_25.getInputStream();
                        var17_33 = var16_29.read();
                        var15_25.close();
                    }
                    catch (IOException var15_25) {
                        if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) {
                            RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "factory failed: ", (Throwable)var15_25);
                        }
                        break block44;
                    }
                    RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "factory succeeded");
                    try {
                        var5_5 = var3_3.createSocket(var1_1, var2_2);
                        return var9_11;
                    }
                    catch (IOException var15_25) {
                        return var9_11;
                    }
                }
                ++var14_21;
lbl86:
                // 2 sources

            } while (var14_21 < this.altFactoryList.size());
            return var9_11;
            do {
                block45: {
                    block48: {
                        var3_3 = (RMISocketFactory)this.altFactoryList.elementAt(var14_22);
                        try {}
                        catch (IOException var15_26) {
                            if (!RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) break block45;
                            RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "factory failed: ", (Throwable)var15_26);
                            break block45;
                        }
                        if (!RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) break block48;
                        RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "trying with factory: " + var3_3);
                    }
                    var15_26 = var3_3.createSocket(var1_1, var2_2);
                    var16_30 = var15_26.getInputStream();
                    var17_34 = var16_30.read();
                    var15_26.close();
                    RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "factory succeeded");
                    try {}
                    catch (IOException var15_26) {}
                    var5_5 = var3_3.createSocket(var1_1, var2_2);
                    break block42;
                }
                ++var14_22;
lbl111:
                // 2 sources

            } while (var14_22 < this.altFactoryList.size());
            break block42;
            do {
                block46: {
                    block49: {
                        var3_3 = (RMISocketFactory)this.altFactoryList.elementAt(var14_23);
                        try {}
                        catch (IOException var15_27) {
                            if (!RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) break block46;
                            RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "factory failed: ", (Throwable)var15_27);
                            break block46;
                        }
                        if (!RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) break block49;
                        RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "trying with factory: " + var3_3);
                    }
                    var15_27 = var3_3.createSocket(var1_1, var2_2);
                    var16_31 = var15_27.getInputStream();
                    var17_35 = var16_31.read();
                    var15_27.close();
                    RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "factory succeeded");
                    try {}
                    catch (IOException var15_27) {}
                    var5_5 = var3_3.createSocket(var1_1, var2_2);
                    break;
                }
                ++var14_23;
lbl136:
                // 2 sources

            } while (var14_23 < this.altFactoryList.size());
        }
        var8_10 = this.successTable;
        synchronized (var8_10) {
            try {
                var9_13 = var6_6;
                synchronized (var9_13) {
                    var4_4 = this.checkConnector(var6_6);
                    ** if (var4_4 == null) goto lbl148
                }
lbl-1000:
                // 1 sources

                {
                    if (var5_5 == null) return var4_4;
                    var5_5.close();
                    return var4_4;
                }
lbl148:
                // 1 sources

                var6_6.notUsed();
            }
            catch (UnknownHostException var9_14) {
                var7_7 /* !! */  = var9_14;
            }
            catch (NoRouteToHostException var10_16) {
                var7_7 /* !! */  = var10_16;
            }
            if (var5_5 == null) throw var7_7 /* !! */ ;
            this.rememberFactory(var1_1, var3_3);
            return var5_5;
        }
        do {
            block47: {
                block50: {
                    var3_3 = (RMISocketFactory)this.altFactoryList.elementAt(var14_24);
                    try {}
                    catch (IOException var15_28) {
                        if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) {
                            RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "factory failed: ", (Throwable)var15_28);
                        }
                        break block47;
                    }
                    if (!RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) break block50;
                    RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "trying with factory: " + var3_3);
                }
                var15_28 = var3_3.createSocket(var1_1, var2_2);
                var16_32 = var15_28.getInputStream();
                var17_36 = var16_32.read();
                var15_28.close();
                RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "factory succeeded");
                try {}
                catch (IOException var15_28) {
                    throw var12_37;
                }
                var5_5 = var3_3.createSocket(var1_1, var2_2);
                throw var12_37;
            }
            ++var14_24;
lbl181:
            // 2 sources

        } while (var14_24 < this.altFactoryList.size());
        throw var12_37;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rememberFactory(String string, RMISocketFactory rMISocketFactory) {
        Hashtable hashtable = this.successTable;
        synchronized (hashtable) {
            while (this.hostList.size() >= 64) {
                this.successTable.remove(this.hostList.elementAt(0));
                this.hostList.removeElementAt(0);
            }
            this.hostList.addElement(string);
            this.successTable.put(string, rMISocketFactory);
        }
    }

    Socket checkConnector(AsyncConnector asyncConnector) throws IOException {
        Exception exception = asyncConnector.getException();
        if (exception != null) {
            exception.fillInStackTrace();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new Error("internal error: unexpected checked exception: " + exception.toString());
        }
        return asyncConnector.getSocket();
    }

    public ServerSocket createServerSocket(int n2) throws IOException {
        return this.initialFactory.createServerSocket(n2);
    }

    private class AsyncConnector
    implements Runnable {
        private RMISocketFactory factory;
        private String host;
        private int port;
        private AccessControlContext acc;
        private Exception exception = null;
        private Socket socket = null;
        private boolean cleanUp = false;

        AsyncConnector(RMISocketFactory rMISocketFactory, String string, int n2, AccessControlContext accessControlContext) {
            this.factory = rMISocketFactory;
            this.host = string;
            this.port = n2;
            this.acc = accessControlContext;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(string, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    Socket socket = this.factory.createSocket(this.host, this.port);
                    AsyncConnector asyncConnector = this;
                    synchronized (asyncConnector) {
                        this.socket = socket;
                        this.notify();
                    }
                    RMIMasterSocketFactory.this.rememberFactory(this.host, this.factory);
                    AsyncConnector asyncConnector2 = this;
                    synchronized (asyncConnector2) {
                        if (this.cleanUp) {
                            try {
                                this.socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    AsyncConnector asyncConnector = this;
                    synchronized (asyncConnector) {
                        this.exception = exception;
                        this.notify();
                    }
                }
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                throw throwable;
            }
        }

        private synchronized Exception getException() {
            return this.exception;
        }

        private synchronized Socket getSocket() {
            return this.socket;
        }

        synchronized void notUsed() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.cleanUp = true;
        }
    }
}

