/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.crimson.tree.AttributeNode;
import org.apache.crimson.tree.AttributeNode1;
import org.apache.crimson.tree.AttributeSet;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.ElementEx;
import org.apache.crimson.tree.NamespacedNode;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWriteContext;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementNode2
extends NamespacedNode
implements ElementEx {
    protected AttributeSet attributes;
    private String idAttributeName;
    private Object userObject;
    private static final char[] tagStart = new char[]{'<', '/'};
    private static final char[] tagEnd = new char[]{' ', '/', '>'};

    public ElementNode2(String string, String string2) throws DomEx {
        super(string, string2);
    }

    ElementNode2 makeClone() {
        ElementNode2 elementNode2 = new ElementNode2(this.namespaceURI, this.qName);
        if (this.attributes != null) {
            elementNode2.attributes = new AttributeSet(this.attributes, true);
            elementNode2.attributes.setOwnerElement(elementNode2);
        }
        elementNode2.idAttributeName = this.idAttributeName;
        elementNode2.userObject = this.userObject;
        elementNode2.ownerDocument = this.ownerDocument;
        return elementNode2;
    }

    ElementNode2 createCopyForImportNode(boolean bl2) {
        ElementNode2 elementNode2 = new ElementNode2(this.namespaceURI, this.qName);
        if (this.attributes != null) {
            elementNode2.attributes = new AttributeSet(this.attributes);
            elementNode2.attributes.setOwnerElement(elementNode2);
        }
        elementNode2.userObject = this.userObject;
        if (bl2) {
            Node node;
            elementNode2.ownerDocument = this.ownerDocument;
            int n2 = 0;
            while ((node = this.item(n2)) != null) {
                if (node instanceof ElementNode2) {
                    elementNode2.appendChild(((ElementNode2)node).createCopyForImportNode(true));
                } else {
                    elementNode2.appendChild(node.cloneNode(true));
                }
                ++n2;
            }
        }
        return elementNode2;
    }

    static void checkArguments(String string, String string2) throws DomEx {
        if (string2 == null) {
            throw new DomEx(14);
        }
        int n2 = string2.indexOf(58);
        if (n2 <= 0) {
            if (!XmlNames.isUnqualifiedName(string2)) {
                throw new DomEx(5);
            }
            return;
        }
        int n3 = string2.lastIndexOf(58);
        if (n3 != n2) {
            throw new DomEx(14);
        }
        String string3 = string2.substring(0, n2);
        String string4 = string2.substring(n2 + 1);
        if (!XmlNames.isUnqualifiedName(string3) || !XmlNames.isUnqualifiedName(string4)) {
            throw new DomEx(5);
        }
        if (string == null || string3.equals("xml") && !"http://www.w3.org/XML/1998/namespace".equals(string)) {
            throw new DomEx(14);
        }
    }

    public void trimToSize() {
        super.trimToSize();
        if (this.attributes != null) {
            this.attributes.trimToSize();
        }
    }

    void setAttributes(AttributeSet attributeSet) {
        AttributeSet attributeSet2 = this.attributes;
        if (attributeSet2 != null && attributeSet2.isReadonly()) {
            throw new DomEx(7);
        }
        if (attributeSet != null) {
            attributeSet.setOwnerElement(this);
        }
        this.attributes = attributeSet;
        if (attributeSet2 != null) {
            attributeSet2.setOwnerElement(null);
        }
    }

    void checkChildType(int n2) throws DOMException {
        switch (n2) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return;
            }
        }
        throw new DomEx(3);
    }

    public void setReadonly(boolean bl2) {
        if (this.attributes != null) {
            this.attributes.setReadonly();
        }
        super.setReadonly(bl2);
    }

    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public String toString() {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            XmlWriteContext xmlWriteContext = new XmlWriteContext(charArrayWriter);
            this.writeXml(xmlWriteContext);
            return charArrayWriter.toString();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        if (this.qName == null) {
            throw new IllegalStateException(this.getMessage("EN-002"));
        }
        writer.write(tagStart, 0, 1);
        writer.write(this.qName);
        if (this.attributes != null) {
            this.attributes.writeXml(xmlWriteContext);
        }
        if (!this.hasChildNodes()) {
            writer.write(tagEnd, 0, 3);
        } else {
            writer.write(tagEnd, 2, 1);
            this.writeChildrenXml(xmlWriteContext);
            writer.write(tagStart, 0, 2);
            writer.write(this.qName);
            writer.write(tagEnd, 2, 1);
        }
    }

    public void setIdAttributeName(String string) {
        if (this.readonly) {
            throw new DomEx(7);
        }
        this.idAttributeName = string;
    }

    public String getIdAttributeName() {
        return this.idAttributeName;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public short getNodeType() {
        return 1;
    }

    public String getTagName() {
        return this.qName;
    }

    public boolean hasAttribute(String string) {
        return this.getAttributeNode(string) != null;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.getAttributeNodeNS(string, string2) != null;
    }

    public String getAttribute(String string) {
        return this.attributes == null ? "" : this.attributes.getValue(string);
    }

    public String getAttributeNS(String string, String string2) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = this.getAttributeNodeNS(string, string2);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (this.attributes == null) {
            return null;
        }
        int n2 = 0;
        AttributeNode attributeNode;
        while ((attributeNode = (AttributeNode)this.attributes.item(n2)) != null) {
            if (string2.equals(attributeNode.getLocalName()) && (attributeNode.getNamespaceURI() == string || attributeNode.getNamespaceURI().equals(string))) {
                return attributeNode;
            }
            ++n2;
        }
        return null;
    }

    public void setAttribute(String string, String string2) throws DOMException {
        NodeBase nodeBase;
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!XmlNames.isName(string)) {
            throw new DomEx(5);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        if ((nodeBase = (NodeBase)this.attributes.getNamedItem(string)) != null) {
            nodeBase.setNodeValue(string2);
        } else {
            nodeBase = new AttributeNode1(string, string2, true, null);
            nodeBase.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            this.attributes.setNamedItem(nodeBase);
        }
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        AttributeNode.checkArguments(string, string2);
        Attr attr = this.getAttributeNodeNS(string, XmlNames.getLocalPart(string2));
        if (attr == null) {
            AttributeNode attributeNode = new AttributeNode(string, string2, string3, true, null);
            attributeNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            this.setAttributeNodeNS(attributeNode);
        } else {
            attr.setValue(string3);
            attr.setPrefix(XmlNames.getPrefix(string2));
        }
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (attr.getOwnerDocument() != this.getOwnerDocument()) {
            throw new DomEx(4);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    public void removeAttribute(String string) throws DOMException {
        block4: {
            if (this.readonly) {
                throw new DomEx(7);
            }
            if (this.attributes == null) {
                return;
            }
            try {
                this.attributes.removeNamedItem(string);
            }
            catch (DOMException dOMException) {
                if (dOMException.code == 8) break block4;
                throw dOMException;
            }
        }
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        block3: {
            if (this.readonly) {
                throw new DomEx(7);
            }
            try {
                this.attributes.removeNamedItemNS(string, string2);
            }
            catch (DOMException dOMException) {
                if (dOMException.code == 8) break block3;
                throw dOMException;
            }
        }
    }

    public Attr getAttributeNode(String string) {
        if (this.attributes != null) {
            return (Attr)this.attributes.getNamedItem(string);
        }
        return null;
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(attr instanceof AttributeNode)) {
            throw new DomEx(4);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return (Attr)this.attributes.setNamedItem(attr);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        Attr attr2 = this.getAttributeNode(attr.getNodeName());
        if (attr2 == null) {
            throw new DomEx(8);
        }
        this.removeAttribute(attr2.getNodeName());
        return attr2;
    }

    public Node cloneNode(boolean bl2) {
        try {
            ElementNode2 elementNode2 = this.makeClone();
            if (bl2) {
                Node node;
                int n2 = 0;
                while ((node = this.item(n2)) != null) {
                    elementNode2.appendChild(node.cloneNode(true));
                    ++n2;
                }
            }
            return elementNode2;
        }
        catch (DOMException dOMException) {
            throw new RuntimeException(this.getMessage("EN-001"));
        }
    }

    public void write(Writer writer) throws IOException {
        this.writeXml(new XmlWriteContext(writer));
    }
}

