/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.GraphicsEnvironment;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollPanePeer;
import java.io.Serializable;

public class ScrollPaneAdjustable
implements Adjustable,
Serializable {
    private ScrollPane sp;
    private int orientation;
    private int value;
    private int minimum;
    private int maximum;
    private int visibleAmount;
    private transient boolean isAdjusting;
    private int unitIncrement = 1;
    private int blockIncrement = 1;
    private AdjustmentListener adjustmentListener;
    private static final String SCROLLPANE_ONLY = "Can be set by scrollpane only";
    private static final long serialVersionUID = -3359745691033257079L;
    static /* synthetic */ Class class$java$awt$event$AdjustmentListener;

    private static native void initIDs();

    ScrollPaneAdjustable(ScrollPane scrollPane, AdjustmentListener adjustmentListener, int n2) {
        this.sp = scrollPane;
        this.orientation = n2;
        this.addAdjustmentListener(adjustmentListener);
    }

    void setSpan(int n2, int n3, int n4) {
        this.minimum = n2;
        this.maximum = Math.max(n3, this.minimum + 1);
        this.visibleAmount = Math.min(n4, this.maximum - this.minimum);
        this.visibleAmount = Math.max(this.visibleAmount, 1);
        this.blockIncrement = Math.max((int)((double)n4 * 0.9), 1);
        this.setValue(this.value);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setMinimum(int n2) {
        throw new AWTError(SCROLLPANE_ONLY);
    }

    public int getMinimum() {
        return 0;
    }

    public void setMaximum(int n2) {
        throw new AWTError(SCROLLPANE_ONLY);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public synchronized void setUnitIncrement(int n2) {
        if (n2 != this.unitIncrement) {
            this.unitIncrement = n2;
            if (this.sp.peer != null) {
                ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.sp.peer;
                scrollPanePeer.setUnitIncrement(this, n2);
            }
        }
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public synchronized void setBlockIncrement(int n2) {
        this.blockIncrement = n2;
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public void setVisibleAmount(int n2) {
        throw new AWTError(SCROLLPANE_ONLY);
    }

    public int getVisibleAmount() {
        return this.visibleAmount;
    }

    public void setValueIsAdjusting(boolean bl2) {
        if (this.isAdjusting != bl2) {
            this.isAdjusting = bl2;
            AdjustmentEvent adjustmentEvent = new AdjustmentEvent(this, 601, 5, this.value, bl2);
            this.adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void setValue(int n2) {
        n2 = Math.max(n2, this.minimum);
        if ((n2 = Math.min(n2, this.maximum - this.visibleAmount)) != this.value) {
            this.value = n2;
            AdjustmentEvent adjustmentEvent = new AdjustmentEvent(this, 601, 5, this.value, this.isAdjusting);
            this.adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    public int getValue() {
        return this.value;
    }

    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, adjustmentListener);
    }

    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, adjustmentListener);
    }

    public synchronized AdjustmentListener[] getAdjustmentListeners() {
        return (AdjustmentListener[])AWTEventMulticaster.getListeners(this.adjustmentListener, class$java$awt$event$AdjustmentListener == null ? (class$java$awt$event$AdjustmentListener = ScrollPaneAdjustable.class$("java.awt.event.AdjustmentListener")) : class$java$awt$event$AdjustmentListener);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public String paramString() {
        return (this.orientation == 1 ? "vertical," : "horizontal,") + "[0.." + this.maximum + "]" + ",val=" + this.value + ",vis=" + this.visibleAmount + ",unit=" + this.unitIncrement + ",block=" + this.blockIncrement + ",isAdjusting=" + this.isAdjusting;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            ScrollPaneAdjustable.initIDs();
        }
    }
}

