
# PREFIX is inserted above this line during Make

trap : 2 3

PATH=/bin:$PATH

# Paramaters transferred from nn via .param file:
#	ART_ID		Article id to cancel
#	GROUP		Group of article to cancel
#	WORK		Temporary file for response (w initial contents)
#	FIRST_ACTION	First action to perform
#	EMPTY_CHECK	[empty-response-check]
#	EDITOR		[editor]
#	ED_LINE		First line of body in WORK file
#	SPELL_CHECKER	[spell-checker]
#	PAGER		[pager]
#	APPEND_SIG	[append-signature]
#	QUERY_SIG	[query-signature]
#	NOVICE		[expert]
#	WAIT_PERIOD 	[response-check-pause]
#	RECORD		[mail/news-record]
#	MMDF_SEP	[mmdf-format = ^A^A^A^A]
#	POST		[inews]
#	POST_PIPE	[inews-pipe-input]
#	POSTER_ADR	Reply address for follow-ups
#	MAILER		[mailer]
#	MAILER_PIPE	[mailer-pipe-input]
#	DFLT_ANSW	[response-default-answer]
#	ALIAS_EXPANDER	[mail-alias-expander]

CC=""

if [ "$1" = "COMPLETE" ] ; then
  . ${HOME}/.nn/hold.param
  WORK="$2"
  EMPTY_CHECK=false
  cp ${HOME}/.nn/hold.work $WORK
  rm -f ${HOME}/.nn/hold.*
else
 . ${HOME}/.nn/.param
 OPERATION=$1
fi

# first we handle 'cancel'

case "$OPERATION" in
cancel)
  TRACE="$2"
  $INEWS -h  << EOF > $TRACE 2>&1
Newsgroups: $GROUP
Subject: cancel $ART_ID
Control: cancel $ART_ID

cancel $ART_ID in newsgroup $GROUP
EOF

  x=$?
  case $x in
    0) ;;
    *) echo '' ; cat $TRACE ; sleep 2 ;;
  esac
  rm -f $TRACE
  exit $x
  ;;
post|follow)
  LOOKFOR="Newsgroups:"
  SEND="post article"
  ;;
*)
  LOOKFOR="To:"
  SEND="send letter"
  ;;
esac

TRACE=${WORK}T
FINAL=${WORK}F
COPY=""

if [ "${FIRST_ACTION}" != "send" ] ; then
  COPY=${WORK}C
  cp $WORK $COPY
fi

# loop until sent or aborted.

loop=true
prompt=false
pr="a)bort"
if [ -n "${POSTER_ADR}" ] ; then
  pr="$pr c)c"
fi
pr="$pr e)dit"
pr="$pr h)old"
if [ -n "${SPELL_CHECKER}" ] ; then
  pr="$pr i)spell"
fi
pr="$pr m)ail r)eedit s)end v)iew w)rite"
case "${DFLT_ANSW}" in
  p*|s*) pr1=" (${SEND})"
      ;;
  "") pr1=""
      ;;
  *)  pr1=" (${DFLT_ANSW})"
      ;;
esac

while $loop ; do
  if [ -n "${FIRST_ACTION}" ] ; then
    act="${FIRST_ACTION}"
    FIRST_ACTION=""
  elif $prompt ; then
    echo ''
    echo "${pr}"
    ${AWK} 'END{printf "Action:'"${pr1}"' "}' < /dev/null
    read act
    if [ -z "$act" ] ; then
      act="${DFLT_ANSW}"
    fi
  fi
  prompt=true

  case "$act" in
  a*)
    ${AWK} 'END{printf "Confirm abort: (y) "}' < /dev/null
    read act
    case "$act" in
    ""|y*) rm -f $WORK $COPY ;
	     exit 22 ;;
    esac
    ;;

  c*)
    if [ -n "${POSTER_ADR}" ] ; then
      ${AWK} 'END{printf "CC: '"${POSTER_ADR}"' (y) "}' </dev/null
      read act
      case "$act" in
      ""|"y*")
	echo "Sending copy to poster...."
	CC="${POSTER_ADR}"
	;;
      esac
    else
      echo "Not doing follow-up"
    fi
    ;;

  e*)
    # call editor to enter at line $ED_LINE of work file

    case `basename "${EDITOR-vi}"` in
    vi|emacs|emacsclient )
      # Berkeley vi display editor
      # GNU emacs disply editor
      ${EDITOR-vi} +${ED_LINE} $WORK
      ;;
    ded )
      # QMC ded display editor
      $EDITOR -l${ED_LINE} $WORK
      ;;
    uemacs )
      # micro emacs
      $EDITOR -g${ED_LINE} $WORK
      ;;
    * )
      # Unknown editor
      $EDITOR $WORK
      ;;
    esac

    if [ ! -s $WORK ] ; then
      rm -f $WORK $COPY
      exit 22
    fi

    if ${EMPTY_CHECK} ; then
      if cmp -s $WORK $COPY ; then
        rm -f $WORK $COPY
        exit 22
      fi
    fi

    if [ -n "${LOOKFOR}" ] ; then
      if grep "^${LOOKFOR}" $WORK > /dev/null ; then
	:
      else
	echo "Warning: no $LOOKFOR line in article"
      fi
    fi
    ;;

  h*)
    ${AWK} 'END{printf "Complete response later: (y) "}' < /dev/null
    read act
    case "$act" in
    ""|y*)
	cp $WORK ${HOME}/.nn/hold.work
	cp ${HOME}/.nn/.param ${HOME}/.nn/hold.param
	echo "OPERATION=$OPERATION" >> ${HOME}/.nn/hold.param
	if [ -n "$COPY" ] ; then
	  rm -f $COPY
	fi
	rm -f $WORK
	exit 22 ;;
    esac
    ;;

  i*)
    if [ -n "${SPELL_CHECKER}" ] ; then
      ${SPELL_CHECKER} ${WORK}
    else
      echo "spell-checker not defined"
    fi
    ;;

  m*)
    ${AWK} 'END{printf "To: "}' </dev/null
    read CC
    if [ -n "${CC}" ] ; then
      echo "Sending copy...."
    fi
    ;;

  n*)
    act="abort"
    prompt=false
    ;;

  p*)
    loop=false
    ;;

  r*)
    ${AWK} 'END{printf "Undo all changes? (n) "}' < /dev/null
    read act
    case "$act" in
    "[yY]*") cp $COPY $WORK ;;
    esac
    FIRST_ACTION=edit
    ;;

  s*)
    loop=false
    ;;

  v*)
    ${PAGER-cat} $WORK
    ;;

  w*)
    echo "Append article to file:"
    read FNAME
    if [ -n "$FNAME" ] ; then
      { cat $WORK ; echo ; } >> $FNAME
    fi
    ;;

  y*)
    act="${DFLT_ANSW}"
    prompt=false
    ;;

  ENV)
    set
    ;;
  esac

  if [ -n "${CC}" ] ; then
    echo "To: ${CC}" > $FINAL
    sed -e "s/^To:/X-To:/" -e "/^Orig-To:/d" $WORK >> $FINAL
    if ${MAILER_PIPE} ; then
      $MAILER < $FINAL
      x=$?
    else
      $MAILER $FINAL
      x=$?
    fi
    case $x in
      0) echo Done ;;
      *) echo $MAILER failed ;;
    esac
    CC=""
  fi
done

if [ ${APPEND_SIG} = "true" -a -f $HOME/.signature ] ; then
  if ${QUERY_SIG} ; then
    ${AWK} 'END{printf "Append .signature? (y) "}' < /dev/null
    read ans
  else
    ans=y
  fi
  case $ans in
  ''|y*|Y*)
    echo "-- " >> $WORK
    cat $HOME/.signature >> $WORK
    ;;
  esac
fi

case "$OPERATION" in
  follow|post)
    if ${NOVICE} ; then
      echo "Be patient! Your new article will not show up immediately."
      case ${WAIT_PERIOD-0} in
	0|1) WAIT_PERIOD=2 ;;
      esac
    fi
    ;;
esac

{
  trap 'echo SIGNAL' 1 2 3

  grep -v "^Orig-To: " $WORK > $FINAL

  LOGNAME="${LOGNAME-$USER}"
  if [ -z "${LOGNAME}" ] ; then
    set `who am i`
    LOGNAME="$1"
  fi

  if [ -n "${RECORD}" ] ; then
  {
    # keep a copy of message in $RECORD (in mail format)
    set `date`
    if [ -n "$MMDF_SEP" ] ; then
      echo "$MMDF_SEP"
    fi
    if [ $3 -gt 9 ] ; then
      echo From ${LOGNAME} $1 $2 $3 $4 $6 $7
    else
      echo From ${LOGNAME} $1 $2 " $3" $4 $6 $7
    fi
    echo "From: ${LOGNAME}"
    cat $FINAL
    echo "$MMDF_SEP"
  } >> "$RECORD"
  fi

  case "$OPERATION" in

    reply|forward|mail)
      if [ -n "${ALIAS_EXPANDER}" ] ; then
	${ALIAS_EXPANDER} $FINAL
      fi
      if ${MAILER_PIPE} ; then
        $MAILER < $FINAL
        x=$?
      else
        $MAILER $FINAL
        x=$?
      fi
      case $x in
	0) ;;
	*) echo $MAILER failed ;;
      esac
      ;;

    follow|post)
      {
	if ${POST_PIPE} ; then
	  $POST < $FINAL 2>&1
	  x=$?
	else
	  $POST $FINAL 2>&1
	  x=$?
	fi
	case $x in
	  0) sleep 60 ;;
	  *) echo $INEWS failed ;;
	esac
      } | sed \
		-e "/spooled for later processing/d" \
		-e "/problem has been taken care of/d" \
		-e "/mailing your article to/d" \
		-e "/being mailed to/d" \
		-e "/is moderated/d"
      ;;

    *)
      echo "Invalid operation: $OPERATION -- help"
      OPERATION="nn response operation"
      ;;
  esac > $TRACE 2>&1

  if [ -s $TRACE ] ; then
    if [ -s $HOME/dead.letter ] ; then
      cat $HOME/dead.letter >> $HOME/dead.letters
      echo '' >> $HOME/dead.letters
    fi
    cat $WORK > $HOME/dead.letter

    # Gripe: Error-report is lost if REC_MAIL was the problem
    {
      echo "To: ${LOGNAME}"
      echo "Subject: $OPERATION failed"
      echo ''
      cat $TRACE
      echo ''
      echo 'Your response has been saved in ~/dead.letter'
      echo ''
      echo 'Your article/letter follows:'
      cat $WORK
    } > $FINAL
    if ${MAILER_PIPE} ; then
      $MAILER < $FINAL
    else
      $MAILER $FINAL
    fi
  else
    # keep TRACE file a little while for test at end of script
    sleep 3
  fi
  rm -f $WORK $COPY $TRACE $FINAL

} > /dev/null 2>&1 &

case ${WAIT_PERIOD-0} in
  0) ;;
  *) sleep ${WAIT_PERIOD} ;;
esac

if [ -s "$TRACE" ] ; then
  exit 1
fi

exit 0
