/*
 * METALBASE 5.1
 *
 * Released January 1st, 1993 by Huan-Ti [ t-richj@microsoft.com ]
 *
 */

#ifndef MBASE_H
#define MBASE_H

#include <stdinc.h>


#define verCURRENT 51            /* Signature for current-version relations  */
#define verLOWEST  50            /* Lowest version-compatible signature      */
#define verMINIMUM 40            /* Lowest acceptable signature for mb_old() */


/*
 * COMPILE-TIME OPTIONS -------------------------------------------------------
 *
 * Note:  If you increase MAX_NAME above 128, you will have to change the
 *        default word-length in parse.h (#define MAX_LINE) as well.  See
 *        parse.h and input.h for other compile-time options.
 *
 */

#define MAX_REL     20  /* Maximum relations open at once for any given user */
#if 0
#define MAX_FLD    100  /* Maximum number of fields in a relation            */
#endif
#define MAX_FLD    200  /* Maximum number of fields in a relation            */
#define MAX_IDX     20  /* Maximum number of indices in a relation           */
#define MAX_CACHE  500  /* Maximum number of records to cache before a flush */
#define MAX_NAME    20  /* Maximum length of a field or index name           */
#define MAX_COMP    10  /* Maximum number of fields per composite index      */
#define MAX_MULTI    5  /* Maximum number of multi-length fields per rel     */
#define MAX_CBUF  1024  /* Size of compression/decompression buffer          */
#define MAX_FRAG    25  /* Weight which is first considered off-balance      */


/*
 * ERROR CODES ----------------------------------------------------------------
 *
 */

typedef enum
   {
   MB_OKAY     =    0,
   MB_NO_ROOM  = 1001,    /* MAX_REL is #defined to be too small   */
   MB_NO_MEMORY,          /* not enough memory for requested task  */
   MB_NO_OPEN,            /* cannot open given filename            */
   MB_NO_READ,            /* cannot read given filename            */
   MB_FORMAT,             /* relation is not in MB 5.0+ format     */
   MB_LOCKED,             /* relation is locked by another user    */
   MB_BUSY,               /* relation has too many users at once   */
   MB_BAD_REL,            /* function passed bad relation struct   */
   MB_NO_WRITE,           /* cannot write to given filename        */
   MB_BAD_ARG,            /* one or more arguments are not valid   */
   MB_BAD_REC,            /* a null rec pointer has been received  */
   MB_CORRUPT,            /* a corrupt index has been detected     */
   MB_BAD_DUP,            /* addition would violate a nodups index */
   MB_NO_CURR,            /* current record required for operation */
   MB_BAD_IDX,            /* the specified index does not exist    */
   MB_BAD_FLD,            /* the specified field does not exist    */
   MB_NO_SUCH,            /* the specified record can't be found   */
   MB_UNKNOWN,            /* search command invalid                */
   MB_NO_FIELDS,          /* the new relation has no fields        */
   MB_NO_INDICES,         /* the new relation has no indices       */
   MB_BAD_INDEX,          /* a proposed new index is invalid       */
   MB_BAD_FIELD,          /* a proposed new field is invalid       */
   MB_BAD_SERIAL,         /* serial #'s for records can't change   */
   MB_DUP_SERIAL,         /* only one serial field allowed per rel */
   MB_DISKFULL,           /* there is not enough free space left   */
   MB_TMPDIR,             /* you must define a TMP directory       */
   MB_TMPERR,             /* cannot work with temporary file       */
   MB_STRUCT,             /* unrecognized structure alignment      */
   MB_ABORTED,            /* operation aborted by request          */
   MB_NO_QUEUE,           /* there are no records in queue         */
   MB_NO_DATA,            /* the relation's .DAT file is missing   */
   MB_ASSERT,             /* a logical assertion has failed!       */
   MB_BAD_DATA,           /* a corrupt datafile has been detected  */
   MB_ENCRYPT,            /* the encryption key used is invalid    */
   MB_BAD_LEN             /* the new field must have a length      */
   } mb_err;


/*
 * SEARCH CRITERIA ------------------------------------------------------------
 *
 */

typedef enum
   {
   FRST = 0,
   LAST,
   CURR,
   NEXT,
   PREV,
   GTEQ,
   GTHN,
   LTEQ,
   LTHN,
   EQUL,
   FQUE,
   LQUE,
   NQUE,
   PQUE
   } mb_action;

typedef enum
   {
   T_CHAR = 0,  /*  0 -- length ? (char [])         */
   T_SHORT,     /*  1 -- length 2 (short)           */
   T_USHORT,    /*  2 -- length 2 (unsigned short)  */
   T_LONG,      /*  3 -- length 4 (long)            */
   T_ULONG,     /*  4 -- length 4 (unsigned long)   */
   T_FLOAT,     /*  5 -- length 4 (float)           */
   T_DOUBLE,    /*  6 -- length 8 (double)          */
   T_MONEY,     /*  7 -- length 8 (double)          */
   T_TIME,      /*  8 -- length 4 (long)            */
   T_DATE,      /*  9 -- length 4 (long)            */
   T_SERIAL,    /* 10 -- length 4 (long)            */
   T_PHONE,     /* 11 -- lenght 20 (char [])        */
   T_BYTE,      /* 12 -- length ? (uchar [])        */
   T_MCHAR,     /* 13 -- length ? (mchar)           */
   T_MBYTE      /* 14 -- length ? (mbyte)           */
   } ftype;

#define T_LASTTYPE T_MBYTE

#define FIRST    FRST
#define CURRENT  CURR
#define PREVIOUS PREV
#define GTHAN    GTHN
#define LTHAN    LTHN
#define EQUAL    EQUL

#define FIRST_Q    FQUE
#define PREVIOUS_Q PQUE
#define LAST_Q     LQUE
#define NEXT_Q     NQUE


/*
 * TIME/DATE/PHONE STRUCTURES -------------------------------------------------
 *
 */

typedef long mb_time;
typedef long mb_date;

typedef struct
   {
   ushort area;
   ushort prefix;
   ushort number;
   ulong  ext;
   } mb_phone;


/*
 * Bits in time field:
 *          0000 0000 hhhh hmmm mmms ssss suuu uuuu
 *          ---- ---- ---- ---- ---- ---- ---- ----
 * 1F,19    0000 0000 1111 1000 0000 0000 0000 0000 -- 0x00F80000 - hours
 * 3F,13    0000 0000 0000 0111 1110 0000 0000 0000 -- 0x0007E000 - minutes
 * 3F, 7    0000 0000 0000 0000 0001 1111 1000 0000 -- 0x00001F80 - seconds
 * 7F, 0    0000 0000 0000 0000 0000 0000 0111 1111 -- 0x0000007F - micros
 *
 * Hours are stored as   0-23,  0 = midnight
 * Minutes are stored as 0-59,  0 = on the hour
 * Seconds are stored as 0-59,  0 = on the minute
 * Micros are stored as  0-99,  0 = on the second
 *
 */

#define SetHours(x,n)    x = ( (x & 0xFF07FFFF) | (((mb_time)n & 0x1F) << 19) )
#define SetMinutes(x,n)  x = ( (x & 0xFFF81FFF) | (((mb_time)n & 0x3F) << 13) )
#define SetSeconds(x,n)  x = ( (x & 0xFFFFE07F) | (((mb_time)n & 0x3F) <<  7) )
#define SetMicros(x,n)   x = ( (x & 0xFFFFFF80) | (((mb_time)n & 0x7F)      ) )

#define GetHours(x)      (int)((x >> 19) & 0x1F)
#define GetMinutes(x)    (int)((x >> 13) & 0x3F)
#define GetSeconds(x)    (int)((x >>  7) & 0x3F)
#define GetMicros(x)     (int)(    x     & 0x7F)


/*
 * Bits in date field:
 *          0000 0000 00yy yyyy yyyy yyym mmmd dddd -- y=year,m=month,d=day
 *          ---- ---- ---- ---- ---- ---- ---- ----
 * 1FFF,9   0000 0000 0011 1111 1111 1110 0000 0000 -- 0x003FFE00 - year
 *    4,5   0000 0000 0000 0000 0000 0001 1110 0000 -- 0x000001E0 - month
 *   1F,0   0000 0000 0000 0000 0000 0000 0001 1111 -- 0x0000001F - day
 *
 * Year is stored as 0-8191,  0 = 4096BC  (Get/SetYear use 0=0, not 4096bc)
 * Month is stored as 1-12,   1 = January
 * Day is stored as 1-31,     1 = First of the month
 *
 */

#define ToYear(n)   (mb_date)( ((int)(n)) + 4096 )
#define FromYear(n)     (int)( ((int)(n)) - 4096 )

#define SetYear(x,n)  x = ( (x & 0xFFC001FF) | ((ToYear(n)    & 0x1FFF) << 9) )
#define SetMonth(x,n) x = ( (x & 0xFFFFFE1F) | (((mb_date)(n) & 0x000F) << 5) )
#define SetDay(x,n)   x = ( (x & 0xFFFFFFE0) | (((mb_date)(n) & 0x001F)     ) )

#define GetYear(x)   FromYear((x >> 9) & 0x1FFF)
#define GetMonth(x)     (int)((x >> 5) & 0x000F)
#define GetDay(x)       (int)(   x     & 0x001F)


/*
 * MULTI-LENGTH FIELD STRUCTURE -----------------------------------------------
 *
 * Note that this method wastes (sizeof(file)+sizeof(char *)) bytes in
 * the relation, for each multi-length field.  Big deal.  It's just a
 * little sloppy.  So why store that stuff?  If we don't, the record
 * element will be a different length than the structure element, and
 * our structure packing will be off.  That's a Bad Thing.
 *
 */

typedef struct
   {
   long   pos;         /* Byte offset in .DAT file                           */
   char  *name;        /* Filename (malloc()'ed storage)   -- unused in .REL */
   } mchar;
typedef struct
   {
   long   pos;         /* Byte offset in .DAT file                           */
   char  *name;        /* Filename (malloc()'ed storage)   -- unused in .REL */
   } mbyte;

#define cbMULTI sizeof(mchar)


/*
 * RELATION STRUCTURE ---------------------------------------------------------
 *
 */

typedef struct
   {
   file   fhRel;                         /* File handle for relation       */
   file   fhDat;                         /* File handle for .DAT file      */
   file   fhLock;                        /* Handle for lockfile            */
   int    nIdx;                          /* Number of indices              */
   int    nFld;                          /* Number of fields               */
   int    cbRecord;                      /* Record length, in bytes        */
   int    iSerial;                       /* Serial field index, or nFld    */

   long   pos;                           /* Last record read in            */
   long   posRecZ;                       /* Position of record zero        */
   long   posRes;                        /* Position of reserved data      */
   long   serial;                        /* Serial value last queried      */

   char   relname[30];                   /* Relation name--no path or ext  */

   int    cbStart[MAX_FLD];              /* Offset from record per field   */
   int    cbLen[MAX_FLD];                /* Field lengths                  */
   ftype  fldType[MAX_FLD];              /* Field types                    */
   char   fldName[MAX_FLD][MAX_NAME+1];  /* Field names                    */

   char   idxName[MAX_IDX][MAX_NAME+1];  /* Index name                     */
   int    idxFld[MAX_IDX][MAX_COMP];     /* Index fields                   */
   int    nIdxFld[MAX_IDX];              /* Number of fields in this index */
   bool   fDups[MAX_IDX];                /* TRUE if dups allowed on index  */

   bool   fMulti;                        /* TRUE if has multi-length field */

   bool   fReadOnly;                     /* TRUE if we can't write         */
   bool   fExclusive;                    /* TRUE if we've locked it        */
   char   mask;                          /* Encryption mask                */
   ushort pid;                           /* This Process ID                */
   int    ver;                           /* Version number                 */

   char    strobe[30];      /* Last read strobe value for each strobe      */
   mb_time times[30];       /* Time strobe value last changed              */
   } relation;

#define RNULL (relation *)0


/*
 * GLOBAL VARIABLES -----------------------------------------------------------
 *
 */

#ifdef EXTERN
#undef EXTERN
#endif
#ifdef ASSIGN
#undef ASSIGN
#endif
#ifdef MBASE_C
#define EXTERN
#define ASSIGN(x) x
#else
#define EXTERN    extern
#define ASSIGN(x)
#endif

EXTERN mb_err  mb_errno        ASSIGN( = MB_OKAY );
EXTERN char   *mb_error        ASSIGN( = "" );
EXTERN char    quit_chars[20]  ASSIGN( = "" );


/*
 * CALLBACK DEFINITIONS -------------------------------------------------------
 *
 */

typedef enum
   {
   svcERROR,       /* An error occurred during a request (mb_errno set)   */
   svcPAUSE,       /* Request has been placed in queue for processing     */
   svcTIMEOUT,     /* Another process has terminated with a lock in place */
   svcBUSY,        /* An update, add or delete request is being processed */
   svcOKAY,        /* Sent after svcBUSY to indicate request is complete  */
   svcLOCKED,      /* Sent if a request is blocked by an exclusive lock   */
   svcIN_START,    /* input() just started a multi-length field           */
   svcIN_EDITOR,   /* input() needs the name of an editor to use          */
   svcIN_END       /* input() just left a multi-length field              */
   } mb_service;

EXTERN bool (*gfnService) XARGS( (mb_service) )  ASSIGN( = NULL );

#define SetNoService()  gfnService = NULL
#define SetService(fn)  gfnService = fn
#define CallService(s) (gfnService ? (*gfnService)(s) : \
                        (s==svcLOCKED) ? FALSE : TRUE)


/*
 * DEFINITIONS ----------------------------------------------------------------
 *
 */

#define mb_inc(a,b)    mb_open(a,b,FALSE)
#define mb_old(a,b)    mb_open(a,b,TRUE)
#define mb_tst(a)      mb_test(a,0)
#define mb_add(a,b)    mb_addfn(a,b,TRUE)
#define mb_add_q(a,b)  mb_addfn(a,b,FALSE)

#define MB_IncludeRelation    mb_inc
#define MB_IncludeOldRelation mb_old
#define MB_TestInclude        mb_tst
#define MB_RemoveRelation     mb_rmv
#define MB_CloseAllRelations  mb_die
#define MB_NumberOfRecords    mb_num
#define MB_NumberOfRecords_q  mb_num_q
#define MB_AddRecord          mb_add
#define MB_AddRecord_q        mb_add_q
#define MB_DeleteRecord       mb_del
#define MB_UpdateRecord       mb_upd
#define MB_SelectRecord       mb_sel
#define MB_LockRelation       mb_lck
#define MB_UnlockRelation     mb_unl
#define MB_TransferRecord     mb_xfer

#define MB_MallocRelation     mb_new
#define MB_CreateNewIndex     mb_addindex
#define MB_CreateNewField     mb_addfield
#define MB_CreateRelation     mb_create

#define FormatDate            fmt_date
#define FormatTime            fmt_time
#define FormatPhone           fmt_phone
#define ScanDate              scn_date
#define ScanTime              scn_time
#define ScanPhone             scn_phone
#define CopyPhone             phncpy

#define curtime()  tmtotime((struct tm *)0)
#define curdate()  tmtodate((struct tm *)0)


/*
 * FUNCTION PROTOTYPES --------------------------------------------------------
 *
 */


/* MB_TIME.C --------------------------------------------------------------- */

   int        DaysPerYear   XARGS( (int) );
   int        DaysPerMonth  XARGS( (mb_date) );
   int        DayOfWeek     XARGS( (mb_date) );
   int        DayJulian     XARGS( (mb_date) );
   int        PhaseOfMoon   XARGS( (mb_date) );
   long       elap_t        XARGS( (mb_time) );
   mb_time    tmtotime      XARGS( (struct tm *) );
   mb_date    tmtodate      XARGS( (struct tm *) );
   struct tm *datetimetotm  XARGS( (mb_date, mb_time) );
   char      *fmt_date      XARGS( (mb_date, int) );
   char      *fmt_time      XARGS( (mb_time, int) );
   char      *fmt_phone     XARGS( (mb_phone *, int) );
   mb_date    scn_date      XARGS( (char *) );
   mb_time    scn_time      XARGS( (char *) );
   void       scn_phone     XARGS( (mb_phone *, char *) );
   mb_phone  *phncpy        XARGS( (mb_phone *, mb_phone *) );
   double     tomoney       XARGS( (double) );


/* MB_INC.C ---------------------------------------------------------------- */

   relation  *mb_open       XARGS( (char *, char *, bool) );
   mb_err     mb_test       XARGS( (char *, bool) );


/* MB_CREAT.C -------------------------------------------------------------- */

   bool       fSerialIdx    XARGS( (relation *, int) );
   bool       fMultiIdx     XARGS( (relation *, int) );
   relation  *mb_new        XARGS( (void) );
   mb_err     mb_addindex   XARGS( (relation *, char *, bool, char *) );
   mb_err     mb_addfield   XARGS( (relation *, char *, ftype, long) );
   mb_err     mb_create     XARGS( (relation *, char *, bool) );


/* MB_RMV.C ---------------------------------------------------------------- */

   mb_err     mb_rmv        XARGS( (relation *) );
   void       mb_exit       XARGS( (int) );
   void       mb_die        XARGS( (void) );
   char      *GetTmpDir     XARGS( (char *) );
   char      *GetTmpName    XARGS( (char *) );


/* MB_LOCK.C --------------------------------------------------------------- */

   mb_err     mb_unl        XARGS( (relation *) );
   mb_err     mb_lck        XARGS( (relation *) );


/* MB_MISC.C --------------------------------------------------------------- */

   void       SetError      XARGS( (mb_err) );
   mb_err     mb_addfn      XARGS( (relation *, dataptr, bool) );
   mb_err     mb_upd        XARGS( (relation *, dataptr) );
   mb_err     mb_del        XARGS( (relation *) );
   long       mb_num        XARGS( (relation *) );
   mb_err     mb_sel   XARGS( (relation *, int, dataptr, mb_action, dataptr) );
   mb_err     mb_xfer       XARGS( (relation *) );
   long       mb_num_q      XARGS( (relation *) );


/* MB_UTIL.C --------------------------------------------------------------- */

   byte      *numcpy        XARGS( (byte *,  byte *,  int) );
   charptr    strzcpy       XARGS( (charptr, charptr, int) );
   int        idxnum        XARGS( (relation *, charptr) );
   int        fldnum        XARGS( (relation *, charptr) );
   void       hextostr      XARGS( (charptr, dataptr, int) );
   void       strtohex      XARGS( (dataptr, charptr, int) );
   int        compare       XARGS( (relation *, dataptr, dataptr, int) );


/* MB_MULTI.C -------------------------------------------------------------- */

   mb_err     fieldInit     XARGS( (relation *, dataptr, int, char *) );
   char      *fieldFile     XARGS( (relation *, dataptr, int) );
   file       fieldOpen     XARGS( (relation *, dataptr, int) );
   mb_err     recInit       XARGS( (relation *, dataptr) );
   void       recFree       XARGS( (relation *, dataptr) );
   mb_err     recClean      XARGS( (relation *, dataptr) );


#endif  /* MBASE_H */

