#include <mbase.h>
#include "example4.h"

/*
 * PROTOTYPES -----------------------------------------------------------------
 *
 */

   void main XARGS( (void) );


/*
 * CODE -----------------------------------------------------------------------
 *
 */

void
main ()
{
   relation *rel;
   example4  rec;


/*
 * First step in adding new records is, of course, opening the relation...
 *
 */

   if ((rel = mb_inc ("example4", "")) == RNULL)
      {
      fprintf (stderr, "mb_inc() failed: %s\n", mb_error);
      mb_exit (1);
      }


/*
 * Got it.  Now add a couple of records...
 *
 */

   strcpy (rec.composer, "Bach");
   strcpy (rec.piece,    "Fugue in G-minor");
   rec.price = 15.79;

   if (mb_add (rel, &rec) != MB_OKAY)
      {
      fprintf (stderr, "mb_add() failed: %s\n", mb_error);
      mb_exit (1);
      }


   strcpy (rec.composer, "Beethoven");
   strcpy (rec.piece,    "9th symphony");
   rec.price = 21.50;

   if (mb_add (rel, &rec) != MB_OKAY)
      {
      fprintf (stderr, "mb_add() failed: %s\n", mb_error);
      mb_exit (1);
      }


   strcpy (rec.composer, "Fat Boys");
   strcpy (rec.piece,    "On and on");
   rec.price = 11.99;

   if (mb_add (rel, &rec) != MB_OKAY)
      {
      fprintf (stderr, "mb_add() failed: %s\n", mb_error);
      mb_exit (1);
      }


/*
 * Now close the relation, and exit
 *
 */

   printf ("records added successfully\n");

   mb_rmv (rel);
   mb_exit (0);
}

