/* $Header: debug.c,v 2.2 90/02/23 14:16:42 chip Exp $
 *
 * Debugging output.
 *
 * $Log:	debug.c,v $
 * Revision 2.2  90/02/23  14:16:42  chip
 * Support "#!" in delivery files.
 * Support "user|program" and "user?error" from delivery files.
 * Improve debugging and error message formatting.
 * Rearrange code for clarity.
 * 
 * Revision 2.1  89/06/09  12:25:17  network
 * Update RCS revisions.
 * 
 * Revision 1.4  89/06/09  12:23:42  network
 * Baseline for 2.0 release.
 * 
 */

#include "deliver.h"

/*----------------------------------------------------------------------
 * Print out a complete dump of all destinations
 */

dumpdests(when)
char    *when;
{
	DEST    *d, **dv;
	int	i, count;

	message("Destinations %s:\n", when);

	/*
	 * Get and sort the array of destinations.
	 */

	if ((dv = dest_array(&count)) == NULL)
	{
		message("\tnone\n");
		return;
	}

	/*
	 * Now print them in the order we just created.
	 */

	for (i = 0; i < count; ++i)
	{
		char	*e;
		int	len;

		d = dv[i];

		message("\t%s", d->d_name);

		switch (d->d_class)
		{
		case CL_USER:
			/* it's understood */
			break;
		case CL_MBOX:
			message(", mailbox='%s'", d->d_param);
			break;
		case CL_UUCP:
			message(" (UUCP)");
			break;
		case CL_PROG:
			message(", program='%s'", d->d_param);
			break;
		}

		e = (d->d_state == ST_ERROR) ? derrmsg(d) : "";
		len = strlen(d->d_name) + strlen(e);
		if (d->d_param)
			len += strlen(d->d_param);
		message(":%s", (len > 60) ? "\n\t\t" : " ");

		switch (d->d_state)
		{
		case ST_WORKING:
			message("Working");
			break;
		case ST_HOLD:
			message("Hold");
			break;
		case ST_DONE:
			message("Done");
			break;
		case ST_ERROR:
			message("Error (%s)", derrmsg(d));
			break;
		}
		message("\n");
	}

	/* It's our job to free the array. */

	free((char *) dv);
}
