.\" Man page for man (and the former manpath)
.\"
.\" Copyright (c) 1990, 1991, John W. Eaton.
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the README file that comes with the man 1.0
.\" distribution.  
.\"
.\" John W. Eaton
.\" jwe@che.utexas.edu
.\" Department of Chemical Engineering
.\" The University of Texas at Austin
.\" Austin, Texas  78712
.\"
.\" Many changes - aeb
.\"
.TH man 1 "2. September 1995" "dk" "Linux brugerkommandoer" 
.LO 1
.SH NAVN
man \- formaterer og viser online manual siderne
.br
manpath \- udskriver brugerens sgesti for manual siderne
.SH SYNTAKS
man [\-adfhkKtwW] [\-m system] [\-p streng] [\-C konfigurationsfil] [\-M sti]
[\-P pager] [\-S kapitelliste] [kapitel] opslagsord ...
.SH BESKRIVELSE
.B man
formaterer og viser online manual siderne.  Denne version genkender
MANPATH og (MAN)PAGER variablerne, s du kan derfor faststte dit personlige
set manual sider og vlge hvilket program du fortrkker til at vise de formaterede
sider med. Hvis
.I kapitel
er angivet vil
.B man
kun gennemsge dette kapitel af manualen.
Man kan ogs angive hvilken rkkeflge kapittlerne gennemsges for opslag i
og hvilke preprocessore som kres p kildteksten via kommandolinie parametre
eller shellvariabler.
Hvis
.I opslagsordet
indeholder en skrstreg ('/') bliver det frst testet som et filnavn, 
s man kan anfre
.I "man ./foo.5"
eller selv
.I "man /cd/foo/bar.1.gz\fR.\fP"
.SH PARAMETRE
.TP
.B \-\^C " konfigurations_fil"
Angiver hvilken konfigurations_fil som bruges. Normalt anvendes
@man_config_file@. (Se man.config(5).)
.TP
.B \-\^M " sti"
Angiver hvilke kataloger som gennemsges efter manualsider.
Hvis en sdan parameter ikke er angivet bruges shellvariablen
.BR MANPATH .
Hvis ingen sdan shellvariabel findes, konsulteres
.I @man_config_file@
for at opbygge en standardliste.
Hvis MANPATH indeholder et tom delstreng bruges standardlisten.
.TP
.B \-\^P " pager"
Angiver hvilket 'pager' program som skal bruges. 
Denne parameter tilsidestter
.B MANPAGER
shellvariablen, som igen overskygger
.B PAGER
variablen.  Normalt bruger 'man'
.IR @pager@ .
.TP
.B \-\^S " afsnits_liste"
Afsnits_liste er en kolon sepereret liste af manualafsnit 
som skal gennemsges.
Denne parameter tilsidestter 
.B MANSECT
shellvariablen.
.TP
.B \-\^a
Normalt vil man afslutte efter visning af den frste fundne manualside
Brug af denne parameter tvinger 'man' til ikke kun at vise den frst fundne
side men alle sider der matcher 
.BR opslagsord . 
.TP
.B \-\^c 
Reformater kildesiden, selvom der findes en preformateret side
der er up to date.
Denne mulighed bruges hvis for eksempel manualsiden er preformateret
til en skrm med en anden bredde end den man aktuelt anvender.
.TP
.B \-\^d
Siden vises ikke; men der udskrives adskillige fejlfindingsinformationer
i stedet.
.TP
.B \-\^D
Udskiver bde siden og fejlfindingsinformation.
.TP
.B \-\^f
kvivalent med
.B whatis.
.TP
.B \-\^h
Udskriv en kort hjlpetekst og afslut programmet.
.TP
.B \-\^k
kvivalent med
.B apropos.
.TP
.B \-\^K
Gennemsger *alle* manualsiderne efter den angivne streng. Advarsel: det
kan godt g meget langsomt. Det hjper at specifisere et kapitel. P
en typisk maskine tager det omkring 1 minut at gennemsge 500 manualsider.
.TP
.B \-\^m " system"
System angiver et alternativt set manualsider. 
.TP
.B \-\^p " string"
Angiver den sekvens af preprocessore som kres fr nroff eller troff.
Ikke alle installationer har et fuldt set preprocessore.
Bogstaverne som betegner nogle af preprocessorene er: 
eqn (e), grap (g), pic (p), tbl (t), vgrind (v), refer (r).
Denne parameter tilsidestter
.B MANROFFSEQ
shellvariablen.
.TP
.B u-\^t
Brug
.B @troff@
til formattering af manualside, uddata sendes til  
.B stdout.
Uddata fra
.B @troff@
m muligvis viderebearbejdes gennem et filter fr udskrift.
.TP
.BR \-\^w or \-\-path
Manualsiderne vises ikke, men udskriv findestedet for filerne
som ville blive formateret eller vist. Hvis ingen argumenter er angivet
udskrives hvilke kataloger som 
.B man
gennemsger efter manualsider.
Hvis
.B manpath
er et link til man, s er 'manpath' kvivalent med 'man --path'.
.TP
.B \-\^W
Som \-\^w, men udskriver filnavne en per linie, uden yderligere information.
Dette er smart i shell kommandoer ssom
.ft CW
man -aW man | xargs ls -l
.ft

.SH "PREFORMATEREDE SIDER"
.B man
vil prve p at gemme de formaterede manualsider, for at spare
formatteringstid nste gang der er brug for siderne.
Traditionelt bliver de formatterede sider fra KATALOG/manX gemt i
KATALOG/catX, men rute fra manual kataloget til preformat kataloget
kan angives i
.I @man_config_file@.
Ingen preformaterede sider bliver gemt hvis forlangte katalog ikke eksisterer.
.TP
Det er muligt at stte 'man' suid til bruger man. Hvis cat kataloget har ejer
man og tilgangsrettighed 0755 (kum skrivetilladelse for man),
og cat-filerne har ejer man og tilgangsrettighed 0644 eller 0444
(kun skrivetilladelse for man, eller ingen skriveltilladelse overhovedet),
kan ingen ordinr bruger ndre de preformaterede sider eller
anbringe andre filer i katalog for preformaterede sider. 
Hvis 'man' ikke er suid, skal kataloget for preformaterede sider have 
tilgangrettighed 0777 hvis alle brugere skal have mulighed for at gemme 
preformaterede sider.
.TP
Parameteren -c gennemtvinger reformattering af en side,
selvom en frisk preformateret side eksisterer.


.SH SHELLVARIABLE
.TP
.B MANPATH
Hvis
.B MANPATH
er sat, bruges dens vrdi som sgesti til manualsiderne.
.TP
.B MANROFFSEQ
Hvis
.B MANROFFSEQ
is sat, bruges dennes vrdi til at bestemme hvilke preprocessore som 
gennemkres fr nroff eller troff. Normalt bliver siderne sendt gennem 
tabel preprocessoren fr nroff.
.TP
.B MANSECT
Hvis
.B MANSECT
er sat, bruges dens vrdi til at faststte hvilken manualsektioner 
som gennemsges.
.TP
.B MANWIDTH
Hvis
.B MANWIDTH
is sat, bruges dens vrdi som den brede manualsiderne bliver vist med.
Hvis ikke 
.B MANWIDTH 
er sat bruges hele skrmens bredde.
.TP
.B MANPAGER
Hvis
.B MANPAGER
is sat, anvendes dets vrdi som navnet p det program som bruges til at vise
manualsiderne med. Hvis ikke s bruges
.BR PAGER .
Hvis denne heller ikke har nogen vrdi bruges
.BR @pager@ .
.TP
.B LANG
Hvis
.B LANG
er sat, bruges dets vrdi til at definere i hvilket underkatalog man
frst kigger efter manualsider. Sledes vil kommandoen `LANG=dk man 1 foo'
f man til at lede efter foo manualsiden i .../dk/man1/foo.1,
og hvis der ikke kan finde en sdan fil fortsttes der i .../man1/foo.1,
hvor ... er et katalog p sgestien.
.TP
.B "NLSPATH, LC_MESSAGES, LANG"
Shellvariablerne 
.B NLSPATH
og
.B LC_MESSAGES
(eller
.B LANG
nr den sidste ikke findes)
spiller en rolle i at lokalisere meddelelses kataloget.
(Engelske meddelelser er compilet ind i programmet s derfor behves intet
katalog.)
Bemrk at programmer ssom col(1) kaldt af man ogs bruger LC_CTYPE.
.TP
.B STI
.B STI
bliver brugt til konstruktion af den normale sgesti for manualsiderne.
.TP
.B SYSTEM
.B SYSTEM
bliver brugt til at angive et andet system navn med (for brug
med 
.B \-m
valgmuligheden). 
.SH "SE OGS"
apropos(1), whatis(1), less(1), groff(1).
.SH FEJL
.B \-t
parametren virker kun hvis der er installeret et troff-lignende program.
