#! /bin/bash

# if there is no info directory, then create a minimal one
if [ ! -f usr/info/dir ]; then 
  echo '  --- PLEASE ADD DOCUMENTATION TO THIS TREE. (See INFO topic first.) ---' >usr/info/dir 
  echo '* Menu:' >>usr/info/dir 
fi

# if there is no reference to an emacspeak info page, then add it
TEXT="* Emacspeak:(emacspeak).  A speech interface to Emacs"
if fgrep "$TEXT" usr/info/dir 1> /dev/null 2> /dev/null; then 
  echo >/dev/null
else 
  echo "$TEXT" >>usr/info/dir
fi 

# the original config file was missing the `$' characters on the
# variable names -- insert them if necessary
if [ -f /etc/emacspeak.conf ]; then
    sed 's/^if  *\[  *"DTK/if \[ "$DTK/' /etc/emacspeak.conf >/etc/tmp.$$
    mv /etc/tmp.$$ /etc/emacspeak.conf
    if grep 'export' /etc/emacspeak.conf >/dev/null; then
	true;
    else
	cat >>/etc/emacspeak.conf <<\EOF
export DTK_PROGRAM DTK_PORT DTK_TCL
EOF
    fi
fi
