\begindata{text,538270272}
\textdsversion{12}
\template{default}
\define{global
}
-- italicize.n


--	\bold{Italicize the reserved words in Ness code}


-- To italicize all the Ness reserved words in  the current selection:

--	Type ESC-ESC to get the Ness: prompt  

--			(or do whatever action you have bound to ness-dostmt)

--	At the Ness: prompt, type

--		italicize_selection()


-- To italicize the Ness reserved words in a file give the sheell command

--		nessrun italicize.n \italic{filename}

--  The output will be a copy of \italic{filename} with italicized reserved 
words

--   written to file \italic{filename}.i



\italic{\italic{marker}} reserved := " \italic{\italic{marker}} 
\italic{\italic{subseq}} \italic{\italic{boolean}} \italic{\italic{integer}} 
\italic{\italic{real}} \italic{\italic{object}} \italic{\italic{void}} 
\italic{\italic{function}} \italic{\italic{end}} \italic{\italic{on}} 
\italic{\italic{extend}} \italic{\italic{mouse}} \italic{\italic{menu}} 
\italic{\italic{keys}} \italic{\italic{event}} \italic{\italic{return}} 
\italic{\italic{while}} \italic{\italic{do}} \italic{\italic{if}} 
\italic{\italic{then}} \italic{\italic{else}} \italic{\italic{elif}} 
\italic{\italic{exit}} \italic{\italic{True}} \italic{\italic{False}} 
\italic{\italic{null}} \italic{\italic{and}} \italic{\italic{or}} 
\italic{\italic{not}} "


\italic{\italic{marker}} \bold{alpha} := "qwertyuiopasdfghjklzxcvbnm"

	~ "QWERTYUIOPASDFGHJKLZXCVBNM"

\italic{marker} \bold{filechars} := alpha ~ "0123456879./"


\italic{function} \bold{italicizereservedwords}(s)

	\italic{\italic{marker}} t := token(start(s), alpha)

	\italic{\italic{while}} t /= "" \italic{\italic{and}} extent(t, s) /= "" 
\italic{\italic{do}}

		\italic{\italic{if}} search(reserved, " " ~ t ~ " ") /= "" 
\italic{\italic{then}}

			addstyles(t, "\italic{italic}")

		\italic{\italic{end}} \italic{\italic{if}}

		t := token(finish(t), alpha)

	\italic{\italic{end}} \italic{\italic{while}

	\italic{return}} s

\italic{end} \italic{function}


\italic{function} \bold{italicize_selection}()

	\italic{\italic{marker}} s := currentselection(defaulttext)

	italicizereservedwords(s)

\italic{end} \italic{function}


\italic{\italic{function}} \bold{main}(args)

	\italic{marker} filename := token(args, filechars)

	printline(filename ~ " => " ~ filename ~ ".i")

	writefile(filename~".i", italicizereservedwords(readfile(filename)))

\italic{\italic{end}} \italic{\italic{function}}


-- 
\begindata{bp,537558784}
\enddata{bp,537558784}
\view{bpv,537558784,25,0,0}

-- Copyright 1992 Carnegie Mellon University and IBM.  All rights reserved.

\smaller{\smaller{-- $Disclaimer: 

-- Permission to use, copy, modify, and distribute this software and its 

-- documentation for any purpose is hereby granted without fee, 

-- provided that the above copyright notice appear in all copies and that 

-- both that copyright notice, this permission notice, and the following 

-- disclaimer appear in supporting documentation, and that the names of 

-- IBM, Carnegie Mellon University, and other copyright holders, not be 

-- used in advertising or publicity pertaining to distribution of the software 

-- without specific, written prior permission.

-- 

-- IBM, CARNEGIE MELLON UNIVERSITY, AND THE OTHER COPYRIGHT HOLDERS 

-- DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING 

-- ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT 

-- SHALL IBM, CARNEGIE MELLON UNIVERSITY, OR ANY OTHER COPYRIGHT HOLDER 

-- BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY 

-- DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 

-- WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 

-- ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 

-- OF THIS SOFTWARE.

--  $

}}\enddata{text,538270272}
