/* valadelegate.c generated by valac, the Vala compiler
 * generated from valadelegate.vala, do not modify */

/* valadelegate.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaDelegatePrivate {
	ValaDataType* _sender_type;
	ValaList* type_parameters;
	ValaList* parameters;
	ValaDataType* _return_type;
	gboolean* _has_target;
	ValaList* error_types;
};

static gint ValaDelegate_private_offset;
static gpointer vala_delegate_parent_class = NULL;
static ValaCallableIface * vala_delegate_vala_callable_parent_iface = NULL;

static gboolean* _bool_dup (gboolean* self);
static gint vala_delegate_real_get_type_parameter_index (ValaTypeSymbol* base,
                                                  const gchar* name);
static void vala_delegate_real_add_parameter (ValaCallable* base,
                                       ValaParameter* param);
static ValaList* vala_delegate_real_get_parameters (ValaCallable* base);
static void vala_delegate_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor);
static void vala_delegate_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static gboolean vala_delegate_real_is_reference_type (ValaTypeSymbol* base);
static void vala_delegate_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference);
static void vala_delegate_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type);
static gboolean vala_delegate_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context);
static void vala_delegate_finalize (ValaCodeNode * obj);
static GType vala_delegate_get_type_once (void);

static inline gpointer
vala_delegate_get_instance_private (ValaDelegate* self)
{
	return G_STRUCT_MEMBER_P (self, ValaDelegate_private_offset);
}

static ValaDataType*
vala_delegate_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaDelegate* self;
	ValaDataType* _tmp0_;
	self = (ValaDelegate*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_delegate_real_set_return_type (ValaCallable* base,
                                    ValaDataType* value)
{
	ValaDelegate* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaDelegate*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_delegate_get_has_target (ValaDelegate* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_target;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_target", TRUE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_has_target);
		self->priv->_has_target = _tmp2_;
	}
	_tmp3_ = self->priv->_has_target;
	result = *_tmp3_;
	return result;
}

void
vala_delegate_set_has_target (ValaDelegate* self,
                              gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_has_target);
	self->priv->_has_target = _tmp0_;
	if (value) {
		vala_code_node_remove_attribute_argument ((ValaCodeNode*) self, "CCode", "has_target");
	} else {
		vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_target", FALSE, NULL);
	}
}

ValaDataType*
vala_delegate_get_sender_type (ValaDelegate* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sender_type;
	result = _tmp0_;
	return result;
}

void
vala_delegate_set_sender_type (ValaDelegate* self,
                               ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_sender_type);
	self->priv->_sender_type = _tmp0_;
}

/**
 * Creates a new delegate.
 *
 * @param name              delegate type name
 * @param return_type       return type
 * @param source_reference  reference to source code
 * @return                  newly created delegate
 */
ValaDelegate*
vala_delegate_construct (GType object_type,
                         const gchar* name,
                         ValaDataType* return_type,
                         ValaSourceReference* source_reference,
                         ValaComment* comment)
{
	ValaDelegate* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaDelegate*) vala_typesymbol_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaDelegate*
vala_delegate_new (const gchar* name,
                   ValaDataType* return_type,
                   ValaSourceReference* source_reference,
                   ValaComment* comment)
{
	return vala_delegate_construct (VALA_TYPE_DELEGATE, name, return_type, source_reference, comment);
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_delegate_add_type_parameter (ValaDelegate* self,
                                  ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, p);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) p);
}

ValaList*
vala_delegate_get_type_parameters (ValaDelegate* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	result = _tmp0_;
	return result;
}

gboolean
vala_delegate_has_type_parameters (ValaDelegate* self)
{
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->type_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_parameters;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gint
vala_delegate_real_get_type_parameter_index (ValaTypeSymbol* base,
                                             const gchar* name)
{
	ValaDelegate * self;
	gint i = 0;
	gint result = 0;
	self = (ValaDelegate*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp0_;
		gint _parameter_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _parameter_index = 0;
		_tmp0_ = self->priv->type_parameters;
		_parameter_list = _tmp0_;
		_tmp1_ = _parameter_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_parameter_size = _tmp3_;
		_parameter_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			_parameter_index = _parameter_index + 1;
			_tmp4_ = _parameter_index;
			_tmp5_ = _parameter_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _parameter_list;
			_tmp7_ = vala_list_get (_tmp6_, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp7_;
			_tmp8_ = parameter;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				return result;
			}
			_tmp11_ = i;
			i = _tmp11_ + 1;
			_vala_code_node_unref0 (parameter);
		}
	}
	result = -1;
	return result;
}

/**
 * Appends parameter to this callback function.
 *
 * @param param a formal parameter
 */
static void
vala_delegate_real_add_parameter (ValaCallable* base,
                                  ValaParameter* param)
{
	ValaDelegate * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaDelegate*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

/**
 * Return the parameter list.
 *
 * @return parameter list
 */
static ValaList*
vala_delegate_real_get_parameters (ValaCallable* base)
{
	ValaDelegate * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaDelegate*) base;
	_tmp0_ = self->priv->parameters;
	result = _tmp0_;
	return result;
}

/**
 * Checks whether the arguments and return type of the specified method
 * matches this callback.
 *
 * @param m a method
 * @return  true if the specified method is compatible to this callback
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

gboolean
vala_delegate_matches_method (ValaDelegate* self,
                              ValaMethod* m,
                              ValaDataType* dt)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	gboolean _tmp11_;
	ValaList* method_params = NULL;
	ValaList* _tmp12_;
	ValaList* _tmp13_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp14_;
	ValaIterator* _tmp15_;
	gboolean _tmp16_ = FALSE;
	ValaDataType* _tmp17_;
	gboolean first = FALSE;
	gboolean _tmp84_ = FALSE;
	gboolean _tmp85_ = FALSE;
	gboolean _tmp86_ = FALSE;
	ValaIterator* _tmp100_;
	ValaArrayList* method_error_types = NULL;
	GEqualFunc _tmp101_;
	ValaArrayList* _tmp102_;
	ValaArrayList* _tmp103_;
	gboolean _tmp104_ = FALSE;
	gboolean _tmp105_ = FALSE;
	ValaList* _tmp106_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	g_return_val_if_fail (dt != NULL, FALSE);
	_tmp1_ = vala_method_get_coroutine (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !VALA_IS_SIGNAL (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_data_type_get_actual_type (_tmp8_, dt, NULL, (ValaCodeNode*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = !vala_data_type_stricter (_tmp6_, _tmp10_);
	_vala_code_node_unref0 (_tmp10_);
	if (_tmp11_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = vala_callable_get_parameters ((ValaCallable*) m);
	_tmp13_ = _vala_iterable_ref0 (_tmp12_);
	method_params = _tmp13_;
	_tmp14_ = method_params;
	_tmp15_ = vala_iterable_iterator ((ValaIterable*) _tmp14_);
	method_params_it = _tmp15_;
	_tmp17_ = self->priv->_sender_type;
	if (_tmp17_ != NULL) {
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp18_ = method_params;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->parameters;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp16_ = _tmp20_ == (_tmp23_ + 1);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaIterator* _tmp24_;
		ValaParameter* method_param = NULL;
		ValaIterator* _tmp25_;
		gpointer _tmp26_;
		ValaDataType* _tmp27_;
		ValaParameter* _tmp28_;
		ValaDataType* _tmp29_;
		ValaDataType* _tmp30_;
		_tmp24_ = method_params_it;
		vala_iterator_next (_tmp24_);
		_tmp25_ = method_params_it;
		_tmp26_ = vala_iterator_get (_tmp25_);
		method_param = (ValaParameter*) _tmp26_;
		_tmp27_ = self->priv->_sender_type;
		_tmp28_ = method_param;
		_tmp29_ = vala_variable_get_variable_type ((ValaVariable*) _tmp28_);
		_tmp30_ = _tmp29_;
		if (!vala_data_type_stricter (_tmp27_, _tmp30_)) {
			result = FALSE;
			_vala_code_node_unref0 (method_param);
			_vala_iterator_unref0 (method_params_it);
			_vala_iterable_unref0 (method_params);
			return result;
		}
		_vala_code_node_unref0 (method_param);
	}
	first = TRUE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp31_;
		gint _param_size = 0;
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _param_index = 0;
		_tmp31_ = self->priv->parameters;
		_param_list = _tmp31_;
		_tmp32_ = _param_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_param_size = _tmp34_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			ValaParameter* param = NULL;
			ValaList* _tmp37_;
			gpointer _tmp38_;
			ValaParameter* method_param = NULL;
			ValaDataType* method_param_type = NULL;
			gboolean _tmp39_ = FALSE;
			gboolean _tmp40_ = FALSE;
			gboolean _tmp55_ = FALSE;
			ValaParameter* _tmp56_;
			ValaParameter* _tmp77_;
			ValaDataType* _tmp78_;
			ValaDataType* _tmp79_;
			ValaDataType* _tmp80_;
			ValaDataType* _tmp81_;
			ValaDataType* _tmp82_;
			gboolean _tmp83_;
			_param_index = _param_index + 1;
			_tmp35_ = _param_index;
			_tmp36_ = _param_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _param_list;
			_tmp38_ = vala_list_get (_tmp37_, _param_index);
			param = (ValaParameter*) _tmp38_;
			method_param = NULL;
			if (first) {
				ValaMemberBinding _tmp41_;
				ValaMemberBinding _tmp42_;
				_tmp41_ = vala_method_get_binding (m);
				_tmp42_ = _tmp41_;
				_tmp40_ = _tmp42_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp40_ = FALSE;
			}
			if (_tmp40_) {
				gboolean _tmp43_;
				gboolean _tmp44_;
				_tmp43_ = vala_delegate_get_has_target (self);
				_tmp44_ = _tmp43_;
				_tmp39_ = !_tmp44_;
			} else {
				_tmp39_ = FALSE;
			}
			if (_tmp39_) {
				ValaSymbol* _tmp45_;
				ValaSymbol* _tmp46_;
				ValaDataType* _tmp47_;
				first = FALSE;
				_tmp45_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp46_);
				_vala_code_node_unref0 (method_param_type);
				method_param_type = _tmp47_;
			} else {
				ValaIterator* _tmp48_;
				ValaIterator* _tmp49_;
				gpointer _tmp50_;
				ValaParameter* _tmp51_;
				ValaDataType* _tmp52_;
				ValaDataType* _tmp53_;
				ValaDataType* _tmp54_;
				_tmp48_ = method_params_it;
				if (!vala_iterator_next (_tmp48_)) {
					_vala_code_node_unref0 (method_param_type);
					_vala_code_node_unref0 (method_param);
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp49_ = method_params_it;
				_tmp50_ = vala_iterator_get (_tmp49_);
				_vala_code_node_unref0 (method_param);
				method_param = (ValaParameter*) _tmp50_;
				_tmp51_ = method_param;
				_tmp52_ = vala_variable_get_variable_type ((ValaVariable*) _tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = _vala_code_node_ref0 (_tmp53_);
				_vala_code_node_unref0 (method_param_type);
				method_param_type = _tmp54_;
			}
			_tmp56_ = method_param;
			if (_tmp56_ != NULL) {
				gboolean _tmp57_ = FALSE;
				ValaParameter* _tmp58_;
				gboolean _tmp59_;
				gboolean _tmp60_;
				_tmp58_ = param;
				_tmp59_ = vala_parameter_get_ellipsis (_tmp58_);
				_tmp60_ = _tmp59_;
				if (_tmp60_) {
					_tmp57_ = TRUE;
				} else {
					ValaParameter* _tmp61_;
					gboolean _tmp62_;
					gboolean _tmp63_;
					_tmp61_ = param;
					_tmp62_ = vala_parameter_get_params_array (_tmp61_);
					_tmp63_ = _tmp62_;
					_tmp57_ = _tmp63_;
				}
				_tmp55_ = _tmp57_;
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				gboolean _tmp64_ = FALSE;
				ValaParameter* _tmp65_;
				gboolean _tmp66_;
				gboolean _tmp67_;
				ValaParameter* _tmp68_;
				gboolean _tmp69_;
				gboolean _tmp70_;
				_tmp65_ = param;
				_tmp66_ = vala_parameter_get_ellipsis (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = method_param;
				_tmp69_ = vala_parameter_get_ellipsis (_tmp68_);
				_tmp70_ = _tmp69_;
				if (_tmp67_ != _tmp70_) {
					_tmp64_ = TRUE;
				} else {
					ValaParameter* _tmp71_;
					gboolean _tmp72_;
					gboolean _tmp73_;
					ValaParameter* _tmp74_;
					gboolean _tmp75_;
					gboolean _tmp76_;
					_tmp71_ = param;
					_tmp72_ = vala_parameter_get_params_array (_tmp71_);
					_tmp73_ = _tmp72_;
					_tmp74_ = method_param;
					_tmp75_ = vala_parameter_get_params_array (_tmp74_);
					_tmp76_ = _tmp75_;
					_tmp64_ = _tmp73_ != _tmp76_;
				}
				if (_tmp64_) {
					result = FALSE;
					_vala_code_node_unref0 (method_param_type);
					_vala_code_node_unref0 (method_param);
					_vala_code_node_unref0 (param);
					_vala_iterator_unref0 (method_params_it);
					_vala_iterable_unref0 (method_params);
					return result;
				}
				_vala_code_node_unref0 (method_param_type);
				_vala_code_node_unref0 (method_param);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp77_ = param;
			_tmp78_ = vala_variable_get_variable_type ((ValaVariable*) _tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = vala_data_type_get_actual_type (_tmp79_, dt, NULL, (ValaCodeNode*) self);
			_tmp81_ = _tmp80_;
			_tmp82_ = method_param_type;
			_tmp83_ = !vala_data_type_stricter (_tmp81_, _tmp82_);
			_vala_code_node_unref0 (_tmp81_);
			if (_tmp83_) {
				result = FALSE;
				_vala_code_node_unref0 (method_param_type);
				_vala_code_node_unref0 (method_param);
				_vala_code_node_unref0 (param);
				_vala_iterator_unref0 (method_params_it);
				_vala_iterable_unref0 (method_params);
				return result;
			}
			_vala_code_node_unref0 (method_param_type);
			_vala_code_node_unref0 (method_param);
			_vala_code_node_unref0 (param);
		}
	}
	if (first) {
		gboolean _tmp87_;
		gboolean _tmp88_;
		_tmp87_ = vala_delegate_get_has_target (self);
		_tmp88_ = _tmp87_;
		_tmp86_ = !_tmp88_;
	} else {
		_tmp86_ = FALSE;
	}
	if (_tmp86_) {
		gboolean _tmp89_ = FALSE;
		ValaMemberBinding _tmp90_;
		ValaMemberBinding _tmp91_;
		_tmp90_ = vala_method_get_binding (m);
		_tmp91_ = _tmp90_;
		if (_tmp91_ == VALA_MEMBER_BINDING_INSTANCE) {
			_tmp89_ = TRUE;
		} else {
			gboolean _tmp92_;
			gboolean _tmp93_;
			_tmp92_ = vala_method_get_closure (m);
			_tmp93_ = _tmp92_;
			_tmp89_ = _tmp93_;
		}
		_tmp85_ = _tmp89_;
	} else {
		_tmp85_ = FALSE;
	}
	if (_tmp85_) {
		gboolean _tmp94_ = FALSE;
		ValaList* _tmp95_;
		gint _tmp96_;
		gint _tmp97_;
		_tmp95_ = self->priv->parameters;
		_tmp96_ = vala_collection_get_size ((ValaCollection*) _tmp95_);
		_tmp97_ = _tmp96_;
		if (_tmp97_ == 0) {
			_tmp94_ = TRUE;
		} else {
			gboolean _tmp98_;
			gboolean _tmp99_;
			_tmp98_ = vala_method_get_closure (m);
			_tmp99_ = _tmp98_;
			_tmp94_ = _tmp99_;
		}
		_tmp84_ = _tmp94_;
	} else {
		_tmp84_ = FALSE;
	}
	if (_tmp84_) {
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_iterable_unref0 (method_params);
		return result;
	}
	_tmp100_ = method_params_it;
	if (vala_iterator_next (_tmp100_)) {
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_iterable_unref0 (method_params);
		return result;
	}
	_tmp101_ = g_direct_equal;
	_tmp102_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp101_);
	method_error_types = _tmp102_;
	_tmp103_ = method_error_types;
	vala_code_node_get_error_types ((ValaCodeNode*) m, (ValaCollection*) _tmp103_, NULL);
	_tmp106_ = self->priv->error_types;
	if (_tmp106_ != NULL) {
		ValaList* _tmp107_;
		gint _tmp108_;
		gint _tmp109_;
		_tmp107_ = self->priv->error_types;
		_tmp108_ = vala_collection_get_size ((ValaCollection*) _tmp107_);
		_tmp109_ = _tmp108_;
		_tmp105_ = _tmp109_ > 0;
	} else {
		_tmp105_ = FALSE;
	}
	if (_tmp105_) {
		ValaArrayList* _tmp110_;
		gint _tmp111_;
		gint _tmp112_;
		_tmp110_ = method_error_types;
		_tmp111_ = vala_collection_get_size ((ValaCollection*) _tmp110_);
		_tmp112_ = _tmp111_;
		_tmp104_ = _tmp112_ == 0;
	} else {
		_tmp104_ = FALSE;
	}
	if (_tmp104_) {
		result = FALSE;
		_vala_iterable_unref0 (method_error_types);
		_vala_iterator_unref0 (method_params_it);
		_vala_iterable_unref0 (method_params);
		return result;
	}
	{
		ValaArrayList* _method_error_type_list = NULL;
		ValaArrayList* _tmp113_;
		gint _method_error_type_size = 0;
		ValaArrayList* _tmp114_;
		gint _tmp115_;
		gint _tmp116_;
		gint _method_error_type_index = 0;
		_tmp113_ = method_error_types;
		_method_error_type_list = _tmp113_;
		_tmp114_ = _method_error_type_list;
		_tmp115_ = vala_collection_get_size ((ValaCollection*) _tmp114_);
		_tmp116_ = _tmp115_;
		_method_error_type_size = _tmp116_;
		_method_error_type_index = -1;
		while (TRUE) {
			gint _tmp117_;
			gint _tmp118_;
			ValaDataType* method_error_type = NULL;
			ValaArrayList* _tmp119_;
			gpointer _tmp120_;
			gboolean match = FALSE;
			ValaList* _tmp121_;
			_method_error_type_index = _method_error_type_index + 1;
			_tmp117_ = _method_error_type_index;
			_tmp118_ = _method_error_type_size;
			if (!(_tmp117_ < _tmp118_)) {
				break;
			}
			_tmp119_ = _method_error_type_list;
			_tmp120_ = vala_list_get ((ValaList*) _tmp119_, _method_error_type_index);
			method_error_type = (ValaDataType*) _tmp120_;
			match = FALSE;
			_tmp121_ = self->priv->error_types;
			if (_tmp121_ != NULL) {
				{
					ValaList* _delegate_error_type_list = NULL;
					ValaList* _tmp122_;
					gint _delegate_error_type_size = 0;
					ValaList* _tmp123_;
					gint _tmp124_;
					gint _tmp125_;
					gint _delegate_error_type_index = 0;
					_tmp122_ = self->priv->error_types;
					_delegate_error_type_list = _tmp122_;
					_tmp123_ = _delegate_error_type_list;
					_tmp124_ = vala_collection_get_size ((ValaCollection*) _tmp123_);
					_tmp125_ = _tmp124_;
					_delegate_error_type_size = _tmp125_;
					_delegate_error_type_index = -1;
					while (TRUE) {
						gint _tmp126_;
						gint _tmp127_;
						ValaDataType* delegate_error_type = NULL;
						ValaList* _tmp128_;
						gpointer _tmp129_;
						ValaDataType* _tmp130_;
						ValaDataType* _tmp131_;
						_delegate_error_type_index = _delegate_error_type_index + 1;
						_tmp126_ = _delegate_error_type_index;
						_tmp127_ = _delegate_error_type_size;
						if (!(_tmp126_ < _tmp127_)) {
							break;
						}
						_tmp128_ = _delegate_error_type_list;
						_tmp129_ = vala_list_get (_tmp128_, _delegate_error_type_index);
						delegate_error_type = (ValaDataType*) _tmp129_;
						_tmp130_ = method_error_type;
						_tmp131_ = delegate_error_type;
						if (vala_data_type_compatible (_tmp130_, _tmp131_)) {
							match = TRUE;
							_vala_code_node_unref0 (delegate_error_type);
							break;
						}
						_vala_code_node_unref0 (delegate_error_type);
					}
				}
			}
			if (!match) {
				result = FALSE;
				_vala_code_node_unref0 (method_error_type);
				_vala_iterable_unref0 (method_error_types);
				_vala_iterator_unref0 (method_params_it);
				_vala_iterable_unref0 (method_params);
				return result;
			}
			_vala_code_node_unref0 (method_error_type);
		}
	}
	result = TRUE;
	_vala_iterable_unref0 (method_error_types);
	_vala_iterator_unref0 (method_params_it);
	_vala_iterable_unref0 (method_params);
	return result;
}

static void
vala_delegate_real_accept (ValaCodeNode* base,
                           ValaCodeVisitor* visitor)
{
	ValaDelegate * self;
	self = (ValaDelegate*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_delegate (visitor, self);
}

static void
vala_delegate_real_accept_children (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaDelegate * self;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaList* _tmp20_;
	self = (ValaDelegate*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		gint _p_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = self->priv->type_parameters;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeParameter* _tmp8_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = vala_list_get (_tmp6_, _p_index);
			p = (ValaTypeParameter*) _tmp7_;
			_tmp8_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (p);
		}
	}
	_tmp9_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp10_ = _tmp9_;
	vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp11_;
		gint _param_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _param_index = 0;
		_tmp11_ = self->priv->parameters;
		_param_list = _tmp11_;
		_tmp12_ = _param_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_param_size = _tmp14_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaParameter* param = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaParameter* _tmp19_;
			_param_index = _param_index + 1;
			_tmp15_ = _param_index;
			_tmp16_ = _param_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _param_list;
			_tmp18_ = vala_list_get (_tmp17_, _param_index);
			param = (ValaParameter*) _tmp18_;
			_tmp19_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
			_vala_code_node_unref0 (param);
		}
	}
	_tmp20_ = self->priv->error_types;
	if (_tmp20_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp21_;
			gint _error_type_size = 0;
			ValaList* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gint _error_type_index = 0;
			_tmp21_ = self->priv->error_types;
			_error_type_list = _tmp21_;
			_tmp22_ = _error_type_list;
			_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
			_tmp24_ = _tmp23_;
			_error_type_size = _tmp24_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp25_;
				gint _tmp26_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp27_;
				gpointer _tmp28_;
				ValaDataType* _tmp29_;
				_error_type_index = _error_type_index + 1;
				_tmp25_ = _error_type_index;
				_tmp26_ = _error_type_size;
				if (!(_tmp25_ < _tmp26_)) {
					break;
				}
				_tmp27_ = _error_type_list;
				_tmp28_ = vala_list_get (_tmp27_, _error_type_index);
				error_type = (ValaDataType*) _tmp28_;
				_tmp29_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp29_, visitor);
				_vala_code_node_unref0 (error_type);
			}
		}
	}
}

static gboolean
vala_delegate_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaDelegate * self;
	gboolean result = FALSE;
	self = (ValaDelegate*) base;
	result = FALSE;
	return result;
}

/**
 * Adds an error type to the exceptions that can be
 * thrown by this delegate.
 */
void
vala_delegate_add_error_type (ValaDelegate* self,
                              ValaDataType* error_type)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	_tmp0_ = self->priv->error_types;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->error_types);
		self->priv->error_types = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->error_types;
	vala_collection_add ((ValaCollection*) _tmp3_, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, (ValaCodeNode*) self);
}

static void
vala_delegate_real_get_error_types (ValaCodeNode* base,
                                    ValaCollection* collection,
                                    ValaSourceReference* source_reference)
{
	ValaDelegate * self;
	ValaList* _tmp0_;
	self = (ValaDelegate*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->error_types;
	if (_tmp0_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp1_;
			gint _error_type_size = 0;
			ValaList* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _error_type_index = 0;
			_tmp1_ = self->priv->error_types;
			_error_type_list = _tmp1_;
			_tmp2_ = _error_type_list;
			_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			_error_type_size = _tmp4_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp7_;
				gpointer _tmp8_;
				_error_type_index = _error_type_index + 1;
				_tmp5_ = _error_type_index;
				_tmp6_ = _error_type_size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = _error_type_list;
				_tmp8_ = vala_list_get (_tmp7_, _error_type_index);
				error_type = (ValaDataType*) _tmp8_;
				if (source_reference != NULL) {
					ValaDataType* type = NULL;
					ValaDataType* _tmp9_;
					ValaDataType* _tmp10_;
					ValaDataType* _tmp11_;
					ValaDataType* _tmp12_;
					_tmp9_ = error_type;
					_tmp10_ = vala_data_type_copy (_tmp9_);
					type = _tmp10_;
					_tmp11_ = type;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp11_, source_reference);
					_tmp12_ = type;
					vala_collection_add (collection, _tmp12_);
					_vala_code_node_unref0 (type);
				} else {
					ValaDataType* _tmp13_;
					_tmp13_ = error_type;
					vala_collection_add (collection, _tmp13_);
				}
				_vala_code_node_unref0 (error_type);
			}
		}
	}
}

static void
vala_delegate_real_replace_type (ValaCodeNode* base,
                                 ValaDataType* old_type,
                                 ValaDataType* new_type)
{
	ValaDelegate * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaList* _tmp2_;
	self = (ValaDelegate*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp2_ = self->priv->error_types;
	if (_tmp2_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					ValaList* _tmp5_;
					gint _tmp6_;
					gint _tmp7_;
					ValaList* _tmp8_;
					gpointer _tmp9_;
					ValaDataType* _tmp10_;
					gboolean _tmp11_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = self->priv->error_types;
					_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
					_tmp7_ = _tmp6_;
					if (!(i < _tmp7_)) {
						break;
					}
					_tmp8_ = self->priv->error_types;
					_tmp9_ = vala_list_get (_tmp8_, i);
					_tmp10_ = (ValaDataType*) _tmp9_;
					_tmp11_ = _tmp10_ == old_type;
					_vala_code_node_unref0 (_tmp10_);
					if (_tmp11_) {
						ValaList* _tmp12_;
						_tmp12_ = self->priv->error_types;
						vala_list_set (_tmp12_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_delegate_real_check (ValaCodeNode* base,
                          ValaCodeContext* context)
{
	ValaDelegate * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceReference* _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaTypeSymbol* _tmp30_;
	ValaTypeSymbol* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSemanticAnalyzer* _tmp33_;
	ValaDataType* _tmp34_;
	ValaTypeSymbol* _tmp35_;
	ValaTypeSymbol* _tmp36_;
	ValaList* _tmp54_;
	ValaSemanticAnalyzer* _tmp81_;
	ValaSemanticAnalyzer* _tmp82_;
	ValaSourceFile* _tmp83_;
	gboolean _tmp84_;
	gboolean _tmp85_;
	gboolean result = FALSE;
	self = (ValaDelegate*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaSemanticAnalyzer* _tmp11_;
		ValaSemanticAnalyzer* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceFile* _tmp15_;
		ValaSourceFile* _tmp16_;
		_tmp11_ = vala_code_context_get_analyzer (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_source_reference_get_file (_tmp14_);
		_tmp16_ = _tmp15_;
		vala_semantic_analyzer_set_current_source_file (_tmp12_, _tmp16_);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp17_;
		gint _p_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _p_index = 0;
		_tmp17_ = self->priv->type_parameters;
		_p_list = _tmp17_;
		_tmp18_ = _p_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_p_size = _tmp20_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaTypeParameter* _tmp25_;
			_p_index = _p_index + 1;
			_tmp21_ = _p_index;
			_tmp22_ = _p_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _p_list;
			_tmp24_ = vala_list_get (_tmp23_, _p_index);
			p = (ValaTypeParameter*) _tmp24_;
			_tmp25_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp25_, context);
			_vala_code_node_unref0 (p);
		}
	}
	_tmp26_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp27_ = _tmp26_;
	vala_code_node_check ((ValaCodeNode*) _tmp27_, context);
	_tmp28_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_data_type_get_type_symbol (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_code_context_get_analyzer (context);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_->va_list_type;
	_tmp35_ = vala_data_type_get_type_symbol (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp31_ == _tmp36_) {
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaTypeSymbol* _tmp41_;
		ValaTypeSymbol* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_get_type_symbol (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
		_tmp44_ = _tmp43_;
		vala_report_error (_tmp38_, "`%s' not supported as return type", _tmp44_);
		_g_free0 (_tmp44_);
		result = FALSE;
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp45_;
		gint _param_size = 0;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _param_index = 0;
		_tmp45_ = self->priv->parameters;
		_param_list = _tmp45_;
		_tmp46_ = _param_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_param_size = _tmp48_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			ValaParameter* param = NULL;
			ValaList* _tmp51_;
			gpointer _tmp52_;
			ValaParameter* _tmp53_;
			_param_index = _param_index + 1;
			_tmp49_ = _param_index;
			_tmp50_ = _param_size;
			if (!(_tmp49_ < _tmp50_)) {
				break;
			}
			_tmp51_ = _param_list;
			_tmp52_ = vala_list_get (_tmp51_, _param_index);
			param = (ValaParameter*) _tmp52_;
			_tmp53_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp53_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp54_ = self->priv->error_types;
	if (_tmp54_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp55_;
			gint _error_type_size = 0;
			ValaList* _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			gint _error_type_index = 0;
			_tmp55_ = self->priv->error_types;
			_error_type_list = _tmp55_;
			_tmp56_ = _error_type_list;
			_tmp57_ = vala_collection_get_size ((ValaCollection*) _tmp56_);
			_tmp58_ = _tmp57_;
			_error_type_size = _tmp58_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp59_;
				gint _tmp60_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp61_;
				gpointer _tmp62_;
				ValaDataType* _tmp63_;
				ValaDataType* _tmp70_;
				ValaSemanticAnalyzer* _tmp71_;
				ValaSemanticAnalyzer* _tmp72_;
				ValaDataType* _tmp73_;
				_error_type_index = _error_type_index + 1;
				_tmp59_ = _error_type_index;
				_tmp60_ = _error_type_size;
				if (!(_tmp59_ < _tmp60_)) {
					break;
				}
				_tmp61_ = _error_type_list;
				_tmp62_ = vala_list_get (_tmp61_, _error_type_index);
				error_type = (ValaDataType*) _tmp62_;
				_tmp63_ = error_type;
				if (!VALA_IS_ERROR_TYPE (_tmp63_)) {
					ValaDataType* _tmp64_;
					ValaSourceReference* _tmp65_;
					ValaSourceReference* _tmp66_;
					ValaDataType* _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp64_ = error_type;
					_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp64_);
					_tmp66_ = _tmp65_;
					_tmp67_ = error_type;
					_tmp68_ = vala_code_node_to_string ((ValaCodeNode*) _tmp67_);
					_tmp69_ = _tmp68_;
					vala_report_error (_tmp66_, "`%s' is not an error type", _tmp69_);
					_g_free0 (_tmp69_);
				}
				_tmp70_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp70_, context);
				_tmp71_ = vala_code_context_get_analyzer (context);
				_tmp72_ = _tmp71_;
				_tmp73_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp72_, (ValaSymbol*) self, _tmp73_)) {
					ValaSourceReference* _tmp74_;
					ValaSourceReference* _tmp75_;
					ValaDataType* _tmp76_;
					gchar* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp75_ = _tmp74_;
					_tmp76_ = error_type;
					_tmp77_ = vala_code_node_to_string ((ValaCodeNode*) _tmp76_);
					_tmp78_ = _tmp77_;
					_tmp79_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp80_ = _tmp79_;
					vala_report_error (_tmp75_, "error type `%s' is less accessible than delegate `%s'", _tmp78_, _tmp80_);
					_g_free0 (_tmp80_);
					_g_free0 (_tmp78_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
		}
	}
	_tmp81_ = vala_code_context_get_analyzer (context);
	_tmp82_ = _tmp81_;
	_tmp83_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp82_, _tmp83_);
	_tmp84_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp85_ = _tmp84_;
	result = !_tmp85_;
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_delegate_class_init (ValaDelegateClass * klass,
                          gpointer klass_data)
{
	vala_delegate_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_delegate_finalize;
	g_type_class_adjust_private_offset (klass, &ValaDelegate_private_offset);
	((ValaTypeSymbolClass *) klass)->get_type_parameter_index = (gint (*) (ValaTypeSymbol*, const gchar*)) vala_delegate_real_get_type_parameter_index;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_delegate_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_delegate_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_delegate_real_is_reference_type;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_delegate_real_get_error_types;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_delegate_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_delegate_real_check;
}

static void
vala_delegate_vala_callable_interface_init (ValaCallableIface * iface,
                                            gpointer iface_data)
{
	vala_delegate_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_delegate_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_delegate_real_get_parameters;
	iface->get_return_type = vala_delegate_real_get_return_type;
	iface->set_return_type = vala_delegate_real_set_return_type;
}

static void
vala_delegate_instance_init (ValaDelegate * self,
                             gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_delegate_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_parameters = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->parameters = (ValaList*) _tmp3_;
}

static void
vala_delegate_finalize (ValaCodeNode * obj)
{
	ValaDelegate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_DELEGATE, ValaDelegate);
	_vala_code_node_unref0 (self->priv->_sender_type);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_code_node_unref0 (self->priv->_return_type);
	_g_free0 (self->priv->_has_target);
	_vala_iterable_unref0 (self->priv->error_types);
	VALA_CODE_NODE_CLASS (vala_delegate_parent_class)->finalize (obj);
}

/**
 * Represents a function callback type.
 */
static GType
vala_delegate_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaDelegateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_delegate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDelegate), 0, (GInstanceInitFunc) vala_delegate_instance_init, NULL };
	static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_delegate_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_delegate_type_id;
	vala_delegate_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaDelegate", &g_define_type_info, 0);
	g_type_add_interface_static (vala_delegate_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
	ValaDelegate_private_offset = g_type_add_instance_private (vala_delegate_type_id, sizeof (ValaDelegatePrivate));
	return vala_delegate_type_id;
}

GType
vala_delegate_get_type (void)
{
	static volatile gsize vala_delegate_type_id__volatile = 0;
	if (g_once_init_enter (&vala_delegate_type_id__volatile)) {
		GType vala_delegate_type_id;
		vala_delegate_type_id = vala_delegate_get_type_once ();
		g_once_init_leave (&vala_delegate_type_id__volatile, vala_delegate_type_id);
	}
	return vala_delegate_type_id__volatile;
}

