/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.List;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.parser.sparql.ast.ASTDatasetClause;
import org.openrdf.query.parser.sparql.ast.ASTIRI;
import org.openrdf.query.parser.sparql.ast.ASTQueryContainer;

public class DatasetDeclProcessor {
    public static Dataset process(ASTQueryContainer qc) throws MalformedQueryException {
        DatasetImpl dataset = null;
        List<ASTDatasetClause> datasetClauses = qc.getQuery().getDatasetClauseList();
        if (!datasetClauses.isEmpty()) {
            dataset = new DatasetImpl();
            for (ASTDatasetClause dc : datasetClauses) {
                ASTIRI astIri = dc.jjtGetChild(ASTIRI.class);
                try {
                    URIImpl uri = new URIImpl(astIri.getValue());
                    if (dc.isNamed()) {
                        dataset.addNamedGraph(uri);
                        continue;
                    }
                    dataset.addDefaultGraph(uri);
                }
                catch (IllegalArgumentException e) {
                    throw new MalformedQueryException(e.getMessage(), e);
                }
            }
        }
        return dataset;
    }
}

