.\" $XFree86$
.\"
.\" Copyright 2004 Red Hat Inc., Durham, North Carolina.
.\" All Rights Reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation on the rights to use, copy, modify, merge,
.\" publish, distribute, sublicense, and/or sell copies of the Software,
.\" and to permit persons to whom the Software is furnished to do so,
.\" subject to the following conditions:
.\"
.\" he above copyright notice and this permission notice (including the
.\" next paragraph) shall be included in all copies or substantial
.\" portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
.\" NON-INFRINGEMENT.  IN NO EVENT SHALL RED HAT AND/OR THEIR SUPPLIERS
.\" BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
.\" ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.TH DMXDesktopAttributes __libmansuffix__ __vendorversion__
.SH NAME
DMXGetDesktopAttributes \- determine global bounding box
.SH SYNOPSIS
.B #include <X11/extensions/dmxext.h>
.sp
.nf
.BI "Bool DMXGetDesktopAttributes(Display " *dpy ,
.BI "                             DMXDesktopAttributes " *attr );
.fi
.SH DESCRIPTION
.B DMXGetDesktopAttributes()
returns information about the desktop in
.BR DMXDesktopAttributes :
.sp
.nf
typedef struct {
    unsigned int width;
    unsigned int height;
    int          shiftX;
    int          shiftY;
} DMXDesktopAttributes;
.fi
.PP
The size of the global bounding box is given in
.IR width ", and " height .
The
.IR shiftX " and " shiftY
values will always be 0.  The global bounding box is computed whether or
not Xinerama is active, but it is only useful when using Xinerama.
.PP
The global bounding box used by
.BR Xdmx (1)
may be larger than the Xinerama screen size because of information in
the configuration file.
.SH "RETURN VALUE"
.B DMXGetDesktopAttributes()
returns
.B True
unless there is a protocol error.
.SH "SEE ALSO"
.BR DMXChangeDesktopAttributes "(__libmansuffix__), " DMX "(__libmansuffix__), " Xdmx (1)
