/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory.model;

import java.util.Arrays;
import org.openrdf.sail.memory.model.MemStatement;

public class MemStatementList {
    private MemStatement[] statements;
    private int size;

    public MemStatementList() {
        this(4);
    }

    public MemStatementList(int capacity) {
        this.statements = new MemStatement[capacity];
        this.size = 0;
    }

    public MemStatementList(MemStatementList other) {
        this(other.size);
        this.addAll(other);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public MemStatement get(int index) {
        if (index < 0 || index >= this.size) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index < 0");
            }
            throw new IndexOutOfBoundsException("index >= size");
        }
        return this.statements[index];
    }

    public void add(MemStatement st) {
        if (this.size == this.statements.length) {
            this.growArray(this.size == 0 ? 1 : 2 * this.size);
        }
        this.statements[this.size] = st;
        ++this.size;
    }

    public void addAll(MemStatementList other) {
        if (this.size + other.size >= this.statements.length) {
            this.growArray(this.size + other.size);
        }
        System.arraycopy(other.statements, 0, this.statements, this.size, other.size);
        this.size += other.size;
    }

    public void remove(int index) {
        if (index < 0 || index >= this.size) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index < 0");
            }
            throw new IndexOutOfBoundsException("index >= size");
        }
        if (index == this.size - 1) {
            this.statements[index] = null;
            --this.size;
        } else {
            --this.size;
            this.statements[index] = this.statements[this.size];
            this.statements[this.size] = null;
        }
    }

    public void remove(MemStatement st) {
        for (int i = 0; i < this.size; ++i) {
            if (this.statements[i] != st) continue;
            this.remove(i);
            return;
        }
    }

    public void clear() {
        Arrays.fill(this.statements, 0, this.size, null);
        this.size = 0;
    }

    private void growArray(int newSize) {
        MemStatement[] newArray = new MemStatement[newSize];
        System.arraycopy(this.statements, 0, newArray, 0, this.size);
        this.statements = newArray;
    }
}

