/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.util;

public class URIUtil {
    public static int getLocalNameIndex(String uri) {
        int separatorIdx = uri.indexOf(35);
        if (separatorIdx < 0) {
            separatorIdx = uri.lastIndexOf(47);
        }
        if (separatorIdx < 0) {
            separatorIdx = uri.lastIndexOf(58);
        }
        if (separatorIdx < 0) {
            throw new IllegalArgumentException("No separator character founds in URI: " + uri);
        }
        return separatorIdx + 1;
    }

    public static boolean isCorrectURISplit(String namespace, String localName) {
        assert (namespace != null) : "namespace must not be null";
        assert (localName != null) : "localName must not be null";
        if (namespace.length() == 0) {
            return false;
        }
        int nsLength = namespace.length();
        char lastNsChar = namespace.charAt(nsLength - 1);
        if (lastNsChar == '#' && namespace.lastIndexOf(35, nsLength - 2) == -1) {
            return true;
        }
        if (localName.indexOf(35) == -1 && localName.indexOf(47) == -1) {
            if (lastNsChar == '/') {
                return true;
            }
            if (lastNsChar == ':' && localName.indexOf(58) == -1) {
                return true;
            }
        }
        return false;
    }
}

