/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;

public abstract class ValueFactoryBase
implements ValueFactory {
    private int nextBNodeID;
    private String bnodePrefix;

    public ValueFactoryBase() {
        this.initBNodeParams();
    }

    protected void initBNodeParams() {
        this.bnodePrefix = "node" + Long.toString(System.currentTimeMillis(), 32) + "x";
        this.nextBNodeID = 1;
    }

    public BNode createBNode() {
        if (this.nextBNodeID == Integer.MAX_VALUE) {
            this.initBNodeParams();
        }
        return this.createBNode(this.bnodePrefix + this.nextBNodeID++);
    }

    public Literal createLiteral(boolean b) {
        return this.createLiteral(Boolean.toString(b), XMLSchema.BOOLEAN);
    }

    public Literal createLiteral(byte value) {
        return this.createIntegerLiteral(value, XMLSchema.BYTE);
    }

    public Literal createLiteral(short value) {
        return this.createIntegerLiteral(value, XMLSchema.SHORT);
    }

    public Literal createLiteral(int value) {
        return this.createIntegerLiteral(value, XMLSchema.INT);
    }

    public Literal createLiteral(long value) {
        return this.createIntegerLiteral(value, XMLSchema.LONG);
    }

    protected Literal createIntegerLiteral(Number value, URI datatype) {
        return this.createNumericLiteral(value, datatype);
    }

    public Literal createLiteral(float value) {
        return this.createFPLiteral(Float.valueOf(value), XMLSchema.FLOAT);
    }

    public Literal createLiteral(double value) {
        return this.createFPLiteral(value, XMLSchema.DOUBLE);
    }

    protected Literal createFPLiteral(Number value, URI datatype) {
        return this.createNumericLiteral(value, datatype);
    }

    protected Literal createNumericLiteral(Number number, URI datatype) {
        return this.createLiteral(number.toString(), datatype);
    }

    public Literal createLiteral(XMLGregorianCalendar calendar) {
        return this.createLiteral(calendar.toXMLFormat(), XMLDatatypeUtil.qnameToURI(calendar.getXMLSchemaType()));
    }
}

