#ifndef INC_Token_hpp__
#define INC_Token_hpp__

/**
 * <b>SOFTWARE RIGHTS</b>
 * <p>
 * ANTLR 2.6.0 MageLang Insitute, 1999
 * <p>
 * We reserve no legal rights to the ANTLR--it is fully in the
 * public domain. An individual or company may do whatever
 * they wish with source code distributed with ANTLR or the
 * code generated by ANTLR, including the incorporation of
 * ANTLR, or its output, into commerical software.
 * <p>
 * We encourage users to develop software with ANTLR. However,
 * we do ask that credit is given to us for developing
 * ANTLR. By "credit", we mean that if you use ANTLR or
 * incorporate any source code into one of your programs
 * (commercial product, research project, or otherwise) that
 * you acknowledge this fact somewhere in the documentation,
 * research report, etc... If you like ANTLR and have
 * developed a nice tool with the output, please mention that
 * you developed it using ANTLR. In addition, we ask that the
 * headers remain intact in our source code. As long as these
 * guidelines are kept, we expect to continue enhancing this
 * system and expect to make other tools available as they are
 * completed.
 * <p>
 * The ANTLR gang:
 * @version ANTLR 2.6.0 MageLang Insitute, 1999
 * @author Terence Parr, <a href=http://www.MageLang.com>MageLang Institute</a>
 * @author <br>John Lilley, <a href=http://www.Empathy.com>Empathy Software</a>
 * @author <br><a href="mailto:pete@yamuna.demon.co.uk">Pete Wells</a>
 */

#include "antlr/antlr_export.h"
#include "antlr/config.hpp"
#include "antlr/RefCount.hpp"
#include <string>

ANTLR_BEGIN_NAMESPACE(antlr)

/** A token is minimally a token type.  Subclasses can add the text matched
 *  for the token and line info.
 */

class Token;
typedef RefCount<Token> RefToken;

class ANTLR_EXPORT Token {
public:
	// constants
#ifndef NO_STATIC_CONSTS
	static const int MIN_USER_TYPE = 4;
	static const int NULL_TREE_LOOKAHEAD = 3;
	static const int INVALID_TYPE = 0;
	static const int EOF_TYPE = 1;
	static const int SKIP = -1;
#else
	enum {
		MIN_USER_TYPE = 4,
		NULL_TREE_LOOKAHEAD = 3,
		INVALID_TYPE = 0,
		EOF_TYPE = 1,
		SKIP = -1
	};
#endif

	// each Token has at least a token type
	int type; //=INVALID_TYPE;

public:
	// the illegal token object
	static RefToken badToken; // = new Token(INVALID_TYPE, "<no text>");

	Token();
	Token(int t);
	Token(int t, const ANTLR_USE_NAMESPACE(std)string& txt);

	virtual int getColumn() const;
	virtual int getLine() const;
	virtual ANTLR_USE_NAMESPACE(std)string getText() const;
	virtual int getType() const;

	virtual void setColumn(int c);

	virtual void setLine(int l);
	virtual void setText(const ANTLR_USE_NAMESPACE(std)string& t);
	virtual void setType(int t);

	virtual ANTLR_USE_NAMESPACE(std)string toString() const;

	virtual ~Token();
private:
	Token(const Token&);
	const Token& operator=(const Token&);
};

#ifdef NEEDS_OPERATOR_LESS_THAN
inline bool operator<(RefToken l,RefToken r); //{return true;}
#endif

extern ANTLR_EXPORT RefToken nullToken;

ANTLR_END_NAMESPACE

#endif //INC_Token_hpp__
