#! /bin/sh
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is Mozilla Build System
#
# The Initial Developer of the Original Code is
# Ben Turner <mozilla@songbirdnest.com>
#
# Portions created by the Initial Developer are Copyright (C) 2007
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

MOZ_APP_NAME=sunbird
# This sets the default for nightly branding, and may get overriden by options
# in configure.in depending on the arguments passed.
MOZ_BRANDING_DIRECTORY=$MOZ_BUILD_APP/sunbird/branding/nightly
MOZ_UPDATER=1
MOZ_SUNBIRD=1
MOZ_CALENDAR=1
MOZ_APP_VERSION=$SUNBIRD_VERSION
NECKO_PROTOCOLS_DEFAULT="about data file ftp http res viewsource"
MOZ_NO_ACTIVEX_SUPPORT=1
MOZ_ACTIVEX_SCRIPTING_SUPPORT=
MOZ_INSTALLER=
MOZ_MATHML=
NECKO_COOKIES=
MOZ_EXTENSIONS_DEFAULT=
MOZ_UNIVERSALCHARDET=

# Needed for the mozilla-central build side of the system.
# Can be dropped when we branch MOZILLA_1_9_2_BRANCH
MOZILLA_BRANCH_VERSION=`echo ${MOZILLA_VERSION} | sed -e 's/^\([0-9]\.[0-9]\.[0-9]\).*/\1/;'`

if test "$MOZILLA_BRANCH_VERSION" = "1.9.2"; then
  MOZ_APP_VERSION_TXT=$topsrcdir/$MOZ_BUILD_APP/sunbird/config/version-192.txt
  MOZ_NO_XPCOM_OBSOLETE=1
  # MOZ_OJI is only required to be cleared for MOZILLA_1_9_2_BRANCH (OS X).
  MOZ_OJI=
else
  MOZ_APP_VERSION_TXT=$topsrcdir/$MOZ_BUILD_APP/sunbird/config/version.txt
fi

MOZ_APP_VERSION=`cat $MOZ_APP_VERSION_TXT`

SUNBIRD_VERSION=$MOZ_APP_VERSION
MOZ_OFFICIAL_BRANDING_DIRECTORY=other-licenses/branding/sunbird

# Until we can build with libxul, we can't have ipc either
MOZ_ENABLE_LIBXUL=
MOZ_IPC=
