/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.LogicalConnection;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.stmtcache.JDBCStatementCache;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.client.net.NetXAConnection;
import org.apache.derby.jdbc.ClientBaseDataSource;
import org.apache.derby.jdbc.ClientDriver;

public class ClientPooledConnection
implements PooledConnection {
    private boolean newPC_ = true;
    private ArrayList listeners_ = null;
    Connection physicalConnection_ = null;
    NetConnection netPhysicalConnection_ = null;
    NetXAConnection netXAPhysicalConnection_ = null;
    private final JDBCStatementCache statementCache;
    LogicalConnection logicalConnection_ = null;
    protected LogWriter logWriter_ = null;
    protected int rmId_ = 0;
    private ClientBaseDataSource ds_;
    private String user_;
    private String password_;

    public ClientPooledConnection(ClientBaseDataSource clientBaseDataSource, LogWriter logWriter, String string, String string2) throws SQLException {
        this.logWriter_ = logWriter;
        this.ds_ = clientBaseDataSource;
        this.user_ = string;
        this.password_ = string2;
        this.listeners_ = new ArrayList();
        this.statementCache = clientBaseDataSource.maxStatementsToPool() <= 0 ? null : new JDBCStatementCache(clientBaseDataSource.maxStatementsToPool());
        try {
            this.netPhysicalConnection_ = (NetConnection)ClientDriver.getFactory().newNetConnection((NetLogWriter)this.logWriter_, string, string2, clientBaseDataSource, -1, false, this);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        this.physicalConnection_ = this.netPhysicalConnection_;
    }

    public ClientPooledConnection(ClientBaseDataSource clientBaseDataSource, LogWriter logWriter, String string, String string2, int n) throws SQLException {
        this.logWriter_ = logWriter;
        this.ds_ = clientBaseDataSource;
        this.user_ = string;
        this.password_ = string2;
        this.rmId_ = n;
        this.listeners_ = new ArrayList();
        this.statementCache = clientBaseDataSource.maxStatementsToPool() <= 0 ? null : null;
        try {
            this.netXAPhysicalConnection_ = this.getNetXAConnection(clientBaseDataSource, (NetLogWriter)this.logWriter_, string, string2, n);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        this.physicalConnection_ = this.netXAPhysicalConnection_.getNetConnection();
    }

    public boolean isStatementPoolingEnabled() {
        return this.statementCache != null;
    }

    protected void finalize() throws Throwable {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "finalize");
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        try {
            if (this.logWriter_ != null) {
                this.logWriter_.traceEntry(this, "close");
            }
            if (this.logicalConnection_ != null) {
                this.logicalConnection_.nullPhysicalConnection();
                this.logicalConnection_ = null;
            }
            if (this.physicalConnection_ == null) {
                return;
            }
            this.physicalConnection_.closeResources();
        }
        finally {
            this.physicalConnection_ = null;
        }
    }

    public synchronized java.sql.Connection getConnection() throws SQLException {
        try {
            if (this.logWriter_ != null) {
                this.logWriter_.traceEntry(this, "getConnection");
            }
            this.createLogicalConnection();
            if (!this.newPC_) {
                this.physicalConnection_.reset(this.logWriter_, this.user_, this.password_, this.ds_, true);
            } else {
                this.physicalConnection_.lightReset();
            }
            this.newPC_ = false;
            if (this.logWriter_ != null) {
                this.logWriter_.traceExit((Object)this, "getConnection", this.logicalConnection_);
            }
            return this.logicalConnection_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void createLogicalConnection() throws SqlException {
        if (this.physicalConnection_ == null) {
            throw new SqlException(this.logWriter_, new ClientMessageId("08003.C.1"));
        }
        try {
            if (this.physicalConnection_.transactionInProgress()) {
                this.physicalConnection_.rollback();
            }
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        if (this.logicalConnection_ != null) {
            this.logicalConnection_.closeWithoutRecyclingToPool();
        }
        this.logicalConnection_ = this.statementCache == null ? ClientDriver.getFactory().newLogicalConnection(this.physicalConnection_, this) : ClientDriver.getFactory().newCachingLogicalConnection(this.physicalConnection_, this, this.statementCache);
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry((Object)this, "addConnectionEventListener", connectionEventListener);
        }
        this.listeners_.add(connectionEventListener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry((Object)this, "removeConnectionEventListener", connectionEventListener);
        }
        this.listeners_.remove(connectionEventListener);
    }

    public synchronized void recycleConnection() {
        if (this.physicalConnection_.agent_.loggingEnabled()) {
            this.physicalConnection_.agent_.logWriter_.traceEntry(this, "recycleConnection");
        }
        this.logicalConnection_ = null;
        Iterator iterator = this.listeners_.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informListeners(SqlException sqlException) {
        if (sqlException.getErrorCode() < 40000) {
            return;
        }
        ClientPooledConnection clientPooledConnection = this;
        synchronized (clientPooledConnection) {
            Iterator iterator = this.listeners_.iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
                SQLException sQLException = sqlException.getSQLException();
                ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
                connectionEventListener.connectionErrorOccurred(connectionEvent);
            }
        }
    }

    public synchronized void nullLogicalConnection() {
        this.logicalConnection_ = null;
    }

    public void onStatementClose(PreparedStatement preparedStatement) {
    }

    public void onStatementErrorOccurred(PreparedStatement preparedStatement, SQLException sQLException) {
    }

    protected NetXAConnection getNetXAConnection(ClientBaseDataSource clientBaseDataSource, NetLogWriter netLogWriter, String string, String string2, int n) throws SqlException {
        return new NetXAConnection(netLogWriter, string, string2, clientBaseDataSource, n, true, this);
    }
}

