/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.wizards.panels;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationProvider;
import org.netbeans.modules.profiler.ui.wizards.AttachWizardContext;
import org.netbeans.modules.profiler.ui.wizards.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.ui.wizards.panels.ManualIntegrationPanelUI;
import org.netbeans.modules.profiler.ui.wizards.providers.TargetPlatformEnum;
import org.openide.util.HelpCtx;

public class ManualIntegrationPanel
extends AttachWizardPanel {
    private static final String HELP_CTX_KEY = "ManualIntegrationPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ManualIntegrationPanel.HelpCtx");
    private ManualIntegrationPanelUI panel = null;
    private Model model = new Model();

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        return true;
    }

    public boolean canBack(AttachWizardContext context) {
        return true;
    }

    public boolean canFinish(AttachWizardContext context) {
        return false;
    }

    public boolean canNext(AttachWizardContext context) {
        return true;
    }

    public boolean onCancel(AttachWizardContext context) {
        return true;
    }

    public void onEnter(AttachWizardContext context) {
    }

    public void onExit(AttachWizardContext context) {
        this.model.setJvm(null);
    }

    public void onFinish(AttachWizardContext context) {
        this.model.setJvm(null);
    }

    public void onPanelShow() {
        this.panel.refresh();
    }

    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new ManualIntegrationPanelUI(this.model);
        }
        return this.panel;
    }

    class Model {
        private TargetPlatformEnum jvm = null;

        Model() {
        }

        public String getApplication() {
            return ManualIntegrationPanel.this.getContext().getAttachSettings().getServerType();
        }

        public String getApplicationType() {
            return ManualIntegrationPanel.this.getContext().getAttachSettings().getTargetType();
        }

        public IntegrationProvider.IntegrationHints getIntegrationHints() {
            return ManualIntegrationPanel.this.getContext().getIntegrationProvider().getModificationHints(ManualIntegrationPanel.this.getContext().getAttachSettings());
        }

        public void setJvm(TargetPlatformEnum jvm) {
            this.jvm = jvm;
            if (jvm != null) {
                ManualIntegrationPanel.this.getContext().getIntegrationProvider().setTargetJava(jvm.toString());
            }
        }

        public TargetPlatformEnum getJvm() {
            return this.jvm;
        }

        public List getSupportedJvms() {
            LinkedList<TargetPlatformEnum> supportedJvms = new LinkedList<TargetPlatformEnum>();
            if (ManualIntegrationPanel.this.getContext() != null) {
                AttachSettings settings = ManualIntegrationPanel.this.getContext().getAttachSettings();
                Iterator it = TargetPlatformEnum.iterator();
                while (it.hasNext()) {
                    TargetPlatformEnum jvm = (TargetPlatformEnum)it.next();
                    if (!settings.isDirect() && !settings.isRemote() && (!settings.isDynamic16() || !jvm.equals(TargetPlatformEnum.JDK6) && !jvm.equals(TargetPlatformEnum.JDK7)) || !ManualIntegrationPanel.this.getContext().getIntegrationProvider().supportsJVM(jvm)) continue;
                    supportedJvms.add(jvm);
                }
            }
            return supportedJvms;
        }
    }
}

