/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.wizards.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.ui.wizards.panels.AttachSettingsPanel;
import org.netbeans.modules.profiler.ui.wizards.panels.components.ButtonGroupEx;
import org.netbeans.modules.profiler.ui.wizards.panels.components.ResizableHintPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AttachSettingsPanelUI
extends JPanel {
    private final String SELECT_GROUP_TITLE = NbBundle.getMessage(this.getClass(), (String)"AttachWizard_SelectTargetTypeForceString");
    private final String SELECT_TARGET_TITLE = NbBundle.getMessage(this.getClass(), (String)"AttachWizard_SelectTargetForceString");
    private JPanel blankPanel;
    private JRadioButton buttonDirect;
    private JRadioButton buttonDynamic16;
    private JRadioButton buttonLocal;
    private JRadioButton buttonRemote;
    private JComboBox comboGroups;
    private JComboBox comboTargets;
    private ButtonGroupEx groupInvocation;
    private ButtonGroupEx groupMethod;
    private ResizableHintPanel hintPanel;
    private JLabel labelTargetName;
    private JLabel labelTargetType;
    private JPanel panelDetails;
    private JPanel panelInvocation;
    private JPanel panelMethod;
    private JPanel panelType;
    private AttachSettingsPanel.PanelModel model;

    public AttachSettingsPanelUI(AttachSettingsPanel.PanelModel model) {
        this.model = model;
        this.initComponents();
        this.loadModel();
    }

    private void initComponents() {
        this.groupMethod = new ButtonGroupEx();
        this.groupInvocation = new ButtonGroupEx();
        this.panelType = new JPanel();
        this.labelTargetType = new JLabel();
        this.comboGroups = new JComboBox();
        this.labelTargetName = new JLabel();
        this.comboTargets = new JComboBox();
        this.panelDetails = new JPanel();
        this.panelMethod = new JPanel();
        this.buttonLocal = new JRadioButton();
        this.buttonRemote = new JRadioButton();
        this.blankPanel = new JPanel();
        this.panelInvocation = new JPanel();
        this.buttonDirect = new JRadioButton();
        this.buttonDynamic16 = new JRadioButton();
        this.hintPanel = new ResizableHintPanel();
        this.setMaximumSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(300, 300));
        this.setPreferredSize(new Dimension(500, 400));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/profiler/ui/wizards/panels/Bundle");
        this.panelType.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("TargetTypeWizardPanelUI_SelectAttachTargetString"), 0, 0, UIManager.getFont("TitledBorder.font").deriveFont(1)));
        this.labelTargetType.setLabelFor(this.comboGroups);
        Mnemonics.setLocalizedText((JLabel)this.labelTargetType, (String)bundle.getString("TargetTypeWizardPanelUI_TargetTypeString"));
        this.comboGroups.setModel(this.getGroupsModel());
        this.comboGroups.setMaximumSize(new Dimension(130, 24));
        this.comboGroups.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttachSettingsPanelUI.this.comboGroupsActionPerformed(evt);
            }
        });
        this.labelTargetName.setLabelFor(this.comboTargets);
        Mnemonics.setLocalizedText((JLabel)this.labelTargetName, (String)bundle.getString("TargetTypeWizardPanelUI_TargetNameTypeString"));
        this.comboTargets.setModel(this.getTargetsModel(true));
        this.comboTargets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttachSettingsPanelUI.this.comboTargetsActionPerformed(evt);
            }
        });
        GroupLayout panelTypeLayout = new GroupLayout((Container)this.panelType);
        this.panelType.setLayout((LayoutManager)panelTypeLayout);
        panelTypeLayout.setHorizontalGroup((GroupLayout.Group)panelTypeLayout.createParallelGroup(1).add((GroupLayout.Group)panelTypeLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelTypeLayout.createParallelGroup(1).add((GroupLayout.Group)panelTypeLayout.createSequentialGroup().add((Component)this.labelTargetType).addPreferredGap(0, 399, -2)).add((Component)this.comboGroups, 0, 458, Short.MAX_VALUE).add((Component)this.comboTargets, 0, 458, Short.MAX_VALUE).add((Component)this.labelTargetName)).addContainerGap()));
        panelTypeLayout.setVerticalGroup((GroupLayout.Group)panelTypeLayout.createParallelGroup(1).add((GroupLayout.Group)panelTypeLayout.createSequentialGroup().addContainerGap().add((Component)this.labelTargetType).addPreferredGap(0).add((Component)this.comboGroups, -2, -1, -2).add(14, 14, 14).add((Component)this.labelTargetName).addPreferredGap(0).add((Component)this.comboTargets, -2, -1, -2).addContainerGap(30, Short.MAX_VALUE)));
        this.comboGroups.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AttachSettingsPanelUI.class, (String)"AttachSettingsPanelUI.comboGroups.AccessibleContext.accessibleName"));
        this.comboGroups.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachSettingsPanelUI.class, (String)"AttachSettingsPanelUI.comboGroups.AccessibleContext.accessibleDescription"));
        this.comboTargets.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachSettingsPanelUI.class, (String)"AttachSettingsPanelUI.comboTargets.AccessibleContext.accessibleDescription"));
        this.panelDetails.setLayout(new BoxLayout(this.panelDetails, 2));
        this.panelMethod.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("AttachWizard_AttachMethodString"), 0, 0, UIManager.getFont("TitledBorder.font").deriveFont(1)));
        this.groupMethod.add(this.buttonLocal);
        this.buttonLocal.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonLocal, (String)bundle.getString("TargetSettingsWizardPanelUI_LocalRadioName"));
        this.buttonLocal.setToolTipText(bundle.getString("TargetSettingsWizardPanelUI_LocalRadioAccessDescr"));
        this.buttonLocal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonLocal.setMargin(new Insets(0, 0, 0, 0));
        this.buttonLocal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttachSettingsPanelUI.this.buttonLocalActionPerformed(evt);
            }
        });
        this.groupMethod.add(this.buttonRemote);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonRemote, (String)bundle.getString("TargetSettingsWizardPanelUI_RemoteRadioName"));
        this.buttonRemote.setToolTipText(bundle.getString("TargetSettingsWizardPanelUI_RemoteRadioAccessDescr"));
        this.buttonRemote.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonRemote.setMargin(new Insets(0, 0, 0, 0));
        this.buttonRemote.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttachSettingsPanelUI.this.buttonRemoteActionPerformed(evt);
            }
        });
        GroupLayout panelMethodLayout = new GroupLayout((Container)this.panelMethod);
        this.panelMethod.setLayout((LayoutManager)panelMethodLayout);
        panelMethodLayout.setHorizontalGroup((GroupLayout.Group)panelMethodLayout.createParallelGroup(1).add((GroupLayout.Group)panelMethodLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelMethodLayout.createParallelGroup(1).add((Component)this.buttonLocal).add((Component)this.buttonRemote)).addContainerGap(125, Short.MAX_VALUE)));
        panelMethodLayout.setVerticalGroup((GroupLayout.Group)panelMethodLayout.createParallelGroup(1).add((GroupLayout.Group)panelMethodLayout.createSequentialGroup().addContainerGap().add((Component)this.buttonLocal).addPreferredGap(0).add((Component)this.buttonRemote).add(0, 26, Short.MAX_VALUE)));
        this.panelDetails.add(this.panelMethod);
        this.blankPanel.setMaximumSize(new Dimension(80, 10));
        this.blankPanel.setMinimumSize(new Dimension(20, 10));
        this.blankPanel.setPreferredSize(new Dimension(20, 10));
        GroupLayout blankPanelLayout = new GroupLayout((Container)this.blankPanel);
        this.blankPanel.setLayout((LayoutManager)blankPanelLayout);
        blankPanelLayout.setHorizontalGroup((GroupLayout.Group)blankPanelLayout.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        blankPanelLayout.setVerticalGroup((GroupLayout.Group)blankPanelLayout.createParallelGroup(1).add(0, 10, Short.MAX_VALUE));
        this.panelDetails.add(this.blankPanel);
        this.panelInvocation.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("AttachWizard_AttachInvocationString"), 0, 0, UIManager.getFont("TitledBorder.font").deriveFont(1)));
        this.groupInvocation.add(this.buttonDirect);
        this.buttonDirect.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonDirect, (String)bundle.getString("TargetSettingsWizardPanelUI_DirectRadioName"));
        this.buttonDirect.setToolTipText(bundle.getString("TargetSettingsWizardPanelUI_DirectRadioAccessDescr"));
        this.buttonDirect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonDirect.setMargin(new Insets(0, 0, 0, 0));
        this.buttonDirect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttachSettingsPanelUI.this.buttonDirectActionPerformed(evt);
            }
        });
        this.groupInvocation.add(this.buttonDynamic16);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonDynamic16, (String)NbBundle.getMessage(AttachSettingsPanelUI.class, (String)"TargetSettingsWizardPanelUI_Dynamic16RadioName"));
        this.buttonDynamic16.setToolTipText(NbBundle.getMessage(AttachSettingsPanelUI.class, (String)"AttachSettingsPanelUI.buttonDynamic16.toolTipText"));
        this.buttonDynamic16.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonDynamic16.setMargin(new Insets(0, 0, 0, 0));
        this.buttonDynamic16.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttachSettingsPanelUI.this.buttonDynamic16ActionPerformed(evt);
            }
        });
        GroupLayout panelInvocationLayout = new GroupLayout((Container)this.panelInvocation);
        this.panelInvocation.setLayout((LayoutManager)panelInvocationLayout);
        panelInvocationLayout.setHorizontalGroup((GroupLayout.Group)panelInvocationLayout.createParallelGroup(1).add((GroupLayout.Group)panelInvocationLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelInvocationLayout.createParallelGroup(1).add((Component)this.buttonDirect).add((Component)this.buttonDynamic16)).addContainerGap(127, Short.MAX_VALUE)));
        panelInvocationLayout.setVerticalGroup((GroupLayout.Group)panelInvocationLayout.createParallelGroup(1).add((GroupLayout.Group)panelInvocationLayout.createSequentialGroup().addContainerGap().add((Component)this.buttonDirect).addPreferredGap(0).add((Component)this.buttonDynamic16).addContainerGap(26, Short.MAX_VALUE)));
        this.panelDetails.add(this.panelInvocation);
        this.hintPanel.setMaximumSize(new Dimension(500, 150));
        this.hintPanel.setMinimumSize(new Dimension(500, 40));
        this.hintPanel.setPreferredSize(new Dimension(500, 80));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.panelType, -1, -1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(13, 13, 13).add((Component)this.panelDetails, -1, 477, Short.MAX_VALUE))).addContainerGap()).add((Component)this.hintPanel, -1, 500, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.panelType, -2, -1, -2).addPreferredGap(0).add((Component)this.panelDetails, -2, 99, -2).addPreferredGap(0, 21, Short.MAX_VALUE).add((Component)this.hintPanel, -2, 98, -2)));
        this.hintPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AttachSettingsPanelUI.class, (String)"AttachSettingsPanelUI.hintPanel.AccessibleContext.accessibleName"));
    }

    private void buttonDynamic16ActionPerformed(ActionEvent evt) {
        this.model.setDynamicAttach16(this.buttonDynamic16.isEnabled());
        this.loadModel();
    }

    private void buttonDirectActionPerformed(ActionEvent evt) {
        this.model.setDirectAttach(this.buttonDirect.isEnabled());
        this.loadModel();
    }

    private void buttonRemoteActionPerformed(ActionEvent evt) {
        this.model.setRemote(this.buttonRemote.isEnabled());
        this.loadModel();
    }

    private void buttonLocalActionPerformed(ActionEvent evt) {
        this.model.setLocal(this.buttonLocal.isEnabled());
        this.loadModel();
    }

    private void comboTargetsActionPerformed(ActionEvent evt) {
        if (!((ForceSelectionComboBoxModel)this.comboTargets.getModel()).isSelectionMade()) {
            return;
        }
        this.model.setTarget((AttachSettingsPanel.Target)this.comboTargets.getSelectedItem());
        this.loadModel();
    }

    private void comboGroupsActionPerformed(ActionEvent evt) {
        if (!((ForceSelectionComboBoxModel)this.comboGroups.getModel()).isSelectionMade()) {
            return;
        }
        if (this.model.getTargetGroup() != null && this.comboGroups.getSelectedItem() != null && this.model.getTargetGroup().equals(this.comboGroups.getSelectedItem())) {
            return;
        }
        this.model.setTargetGroup((AttachSettingsPanel.TargetGroup)this.comboGroups.getSelectedItem());
        if (this.model.getTargetGroup().isSingular()) {
            this.comboTargets.setModel(this.getTargetsModel(false));
            this.comboTargets.getModel().setSelectedItem(this.model.getTargetGroup().getTargets()[0]);
            this.model.setTarget((AttachSettingsPanel.Target)this.comboTargets.getModel().getSelectedItem());
        } else {
            this.comboTargets.setModel(this.getTargetsModel(true));
            this.comboTargets.getModel().setSelectedItem(null);
            this.model.setTarget(null);
        }
        this.loadModel();
    }

    void init() {
        this.loadModel();
    }

    void applyCombos() {
        AttachSettingsPanel.Target selectedTarget = this.model.getTarget();
        this.comboTargets.setModel(this.getTargetsModel(true));
        this.comboGroups.setSelectedItem(this.model.getTargetGroup());
        this.comboTargets.setSelectedItem(selectedTarget);
    }

    void loadModel() {
        boolean invocationEnabled;
        AttachSettingsPanel.Target target = this.model.getTarget();
        if (this.model.getTargetGroup() != null && !this.model.getTargetGroup().isNull() && !this.model.getTargetGroup().isSingular()) {
            Mnemonics.setLocalizedText((JLabel)this.labelTargetName, (String)MessageFormat.format(NbBundle.getBundle(AttachSettingsPanel.class).getString("TargetTypeWizardPanelUI_TargetNameTypeString"), this.model.getTargetGroup().getName()));
            this.labelTargetName.setVisible(true);
            this.comboTargets.setVisible(true);
        } else {
            this.labelTargetName.setVisible(false);
            this.comboTargets.setVisible(false);
        }
        if (this.model.getTarget() == null) {
            this.panelDetails.setVisible(false);
            this.hintPanel.setVisible(false);
            return;
        }
        this.panelDetails.setVisible(true);
        this.hintPanel.setVisible(true);
        String platform = IntegrationUtils.getLocalJavaPlatform();
        boolean remote = target.supportsRemoteProfiling() && this.model.isRemote();
        boolean local = target.supportsLocalProfiling() && this.model.isLocal() || !target.supportsRemoteProfiling();
        boolean directEnabled = target.supportsDirectAttach();
        boolean dynamicEnabled16 = target.supportsDynamicAttach() && this.model.isLocal() && (platform.equals(IntegrationUtils.PLATFORM_JAVA_60) || platform.equals(IntegrationUtils.PLATFORM_JAVA_70));
        boolean direct = directEnabled && this.model.isDirectAttach() || !dynamicEnabled16 && this.model.isDynamicAttach16();
        boolean dynamic16 = dynamicEnabled16 && this.model.isDynamicAttach16() && this.model.isLocal();
        this.buttonRemote.setSelected(remote);
        this.buttonLocal.setSelected(local);
        this.buttonRemote.setEnabled(target.supportsRemoteProfiling());
        this.buttonLocal.setEnabled(target.supportsLocalProfiling());
        this.buttonDynamic16.setEnabled(dynamicEnabled16);
        this.buttonDirect.setEnabled(directEnabled);
        boolean methodEnabled = this.buttonLocal.isEnabled() || this.buttonRemote.isEnabled();
        boolean bl = invocationEnabled = directEnabled || dynamicEnabled16;
        if (!methodEnabled) {
            this.groupMethod.clearSelection();
        }
        if (!invocationEnabled) {
            this.groupInvocation.clearSelection();
        } else {
            this.buttonDynamic16.setSelected(dynamic16);
            this.buttonDirect.setSelected(direct);
        }
        if (direct) {
            this.model.setDirectAttach(direct);
        }
        if (dynamic16) {
            this.model.setDynamicAttach16(dynamic16);
        }
        this.hintPanel.setHint(this.model.getHints());
    }

    public ComboBoxModel getGroupsModel() {
        return new ForceSelectionComboBoxModel(this.SELECT_GROUP_TITLE, this.model.getTargetGroups());
    }

    public ComboBoxModel getTargetsModel(boolean forcedModel) {
        if (forcedModel) {
            return new ForceSelectionComboBoxModel(this.SELECT_TARGET_TITLE, this.model.getTargetGroup() != null ? this.model.getTargetGroup().getTargets() : new Object[]{});
        }
        return new ForceSelectionComboBoxModel(this.model.getTargetGroup().getTargets());
    }

    private class ForceSelectionComboBoxModel
    extends DefaultComboBoxModel {
        private String firstLine;
        private boolean internalChange;
        private Object selectedItem;

        public ForceSelectionComboBoxModel(Object[] options) {
            super(options);
            this.firstLine = "";
            this.internalChange = false;
        }

        public ForceSelectionComboBoxModel(String selectionText, Object[] options) {
            super(options);
            this.firstLine = "";
            this.internalChange = false;
            this.insertElementAt(selectionText, 0);
            this.firstLine = selectionText;
            this.selectedItem = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelectedItem(Object anObject) {
            if (this.internalChange) {
                return;
            }
            if (anObject == null || anObject.equals(this.firstLine)) {
                this.selectedItem = null;
                return;
            }
            if (this.getElementAt(0).equals(this.firstLine)) {
                try {
                    this.internalChange = true;
                    this.removeElementAt(0);
                }
                finally {
                    this.internalChange = false;
                }
            }
            this.selectedItem = anObject;
            super.setSelectedItem(anObject);
        }

        public Object getSelectedItem() {
            if (this.selectedItem == null && this.getSize() > 0 && this.getElementAt(0).equals(this.firstLine)) {
                return this.firstLine;
            }
            return super.getSelectedItem();
        }

        public boolean isSelectionMade() {
            return this.selectedItem != null;
        }
    }
}

