/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.heapwalk.SummaryController;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class SummaryControllerUI
extends JPanel {
    private static final String VIEW_TITLE = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_ViewTitle");
    private static final String VIEW_DESCR = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_ViewDescr");
    private static final String IN_PROGRESS_MSG = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_InProgressMsg");
    private static final String NOT_AVAILABLE_MSG = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_NotAvailableMsg");
    private static final String SYSTEM_PROPERTIES_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_SystemPropertiesString");
    private static final String SUMMARY_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_SummaryString");
    private static final String ENVIRONMENT_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_EnvironmentString");
    private static final String FILE_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_FileItemString");
    private static final String FILE_SIZE_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_FileSizeItemString");
    private static final String DATE_TAKEN_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_DateTakenItemString");
    private static final String TOTAL_BYTES_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_TotalBytesItemString");
    private static final String TOTAL_CLASSES_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_TotalClassesItemString");
    private static final String TOTAL_INSTANCES_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_TotalInstancesItemString");
    private static final String CLASSLOADERS_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_ClassloadersItemString");
    private static final String GCROOTS_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_GcRootsItemString");
    private static final String OS_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_OsItemString");
    private static final String ARCHITECTURE_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_ArchitectureItemString");
    private static final String JAVA_HOME_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_JavaHomeItemString");
    private static final String JVM_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_JvmItemString");
    private static final String SHOW_SYSPROPS_LINK_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_ShowSysPropsLinkString");
    private AbstractButton presenter;
    private HTMLTextArea dataArea;
    private JSplitPane contentsSplit;
    private Properties systemProperties;
    private SummaryController summaryController;
    private boolean systemPropertiesComputed = false;

    public SummaryControllerUI(SummaryController summaryController) {
        this.summaryController = summaryController;
        this.initComponents();
        this.createData(false);
    }

    public AbstractButton getPresenter() {
        if (this.presenter == null) {
            this.presenter = new Presenter();
        }
        return this.presenter;
    }

    private Properties getSystemProperties() {
        if (!this.systemPropertiesComputed) {
            this.systemProperties = this.summaryController.getHeapFragmentWalker().getHeapFragment().getSystemProperties();
            this.systemPropertiesComputed = true;
        }
        return this.systemProperties;
    }

    private String computeEnvironment() {
        Properties systemProperties = this.getSystemProperties();
        if (systemProperties == null) {
            return NOT_AVAILABLE_MSG;
        }
        String patchLevel = systemProperties.getProperty("sun.os.patch.level", "");
        String os = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(OS_ITEM_STRING, systemProperties.getProperty("os.name", NOT_AVAILABLE_MSG), systemProperties.getProperty("os.version", ""), "unknown".equals(patchLevel) ? "" : patchLevel);
        String arch = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(ARCHITECTURE_ITEM_STRING, systemProperties.getProperty("os.arch", NOT_AVAILABLE_MSG), systemProperties.getProperty("sun.arch.data.model", "?") + "bit");
        String jdk = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(JAVA_HOME_ITEM_STRING, systemProperties.getProperty("java.home", NOT_AVAILABLE_MSG));
        String jvm = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(JVM_ITEM_STRING, systemProperties.getProperty("java.vm.name", NOT_AVAILABLE_MSG), systemProperties.getProperty("java.vm.version", ""), systemProperties.getProperty("java.vm.info", ""));
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/sysinfo.png'>&nbsp;&nbsp;" + ENVIRONMENT_STRING + "</b><br><hr>" + os + "<br>" + arch + "<br>" + jdk + "<br>" + jvm;
    }

    private String computeSummary() {
        File file = this.summaryController.getHeapFragmentWalker().getHeapDumpFile();
        Heap heap = this.summaryController.getHeapFragmentWalker().getHeapFragment();
        HeapSummary hsummary = heap.getSummary();
        int nclassloaders = 0;
        JavaClass cl = heap.getJavaClassByName("java.lang.ClassLoader");
        if (cl != null) {
            nclassloaders = cl.getInstancesCount();
            Collection jcs = cl.getSubClasses();
            for (JavaClass jc : jcs) {
                nclassloaders += jc.getInstancesCount();
            }
        }
        String filename = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(FILE_ITEM_STRING, file != null && file.exists() ? file.getAbsolutePath() : NOT_AVAILABLE_MSG);
        String filesize = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(FILE_SIZE_ITEM_STRING, file != null && file.exists() ? file.length() / 0x100000L + " MB" : NOT_AVAILABLE_MSG);
        String dateTaken = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(DATE_TAKEN_ITEM_STRING, new Date(hsummary.getTime()).toString());
        String liveBytes = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_BYTES_ITEM_STRING, NumberFormat.getInstance().format(hsummary.getTotalLiveBytes()));
        String liveClasses = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_CLASSES_ITEM_STRING, NumberFormat.getInstance().format(heap.getAllClasses().size()));
        String liveInstances = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_INSTANCES_ITEM_STRING, NumberFormat.getInstance().format(hsummary.getTotalLiveInstances()));
        String classloaders = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(CLASSLOADERS_ITEM_STRING, NumberFormat.getInstance().format(nclassloaders));
        String gcroots = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(GCROOTS_ITEM_STRING, NumberFormat.getInstance().format(heap.getGCRoots().size()));
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/resources/memory.png'>&nbsp;&nbsp;" + SUMMARY_STRING + "</b><br><hr>" + dateTaken + "<br>" + filename + "<br>" + filesize + "<br><br>" + liveBytes + "<br>" + liveClasses + "<br>" + liveInstances + "<br>" + classloaders + "<br>" + gcroots;
    }

    private String computeSystemProperties(boolean showSystemProperties) {
        Properties systemProperties = this.getSystemProperties();
        if (systemProperties == null) {
            return NOT_AVAILABLE_MSG;
        }
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/properties.png'>&nbsp;&nbsp;" + SYSTEM_PROPERTIES_STRING + "</b><br><hr>" + (showSystemProperties ? this.formatSystemProperties(systemProperties) : "&nbsp;&nbsp;&nbsp;&nbsp;<a href='#'>" + SHOW_SYSPROPS_LINK_STRING + "</a><br>&nbsp;");
    }

    private void createData(final boolean showSystemProperties) {
        if (!showSystemProperties) {
            this.dataArea.setText(IN_PROGRESS_MSG);
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                String summary = "<nobr>" + SummaryControllerUI.this.computeSummary() + "</nobr>";
                String environment = "<nobr>" + SummaryControllerUI.this.computeEnvironment() + "</nobr>";
                String properties = "<nobr>" + SummaryControllerUI.this.computeSystemProperties(showSystemProperties) + "</nobr>";
                final String dataAreaText = summary + "<br><br>" + environment + "<br><br>" + properties;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SummaryControllerUI.this.dataArea.setText(dataAreaText);
                        SummaryControllerUI.this.dataArea.setCaretPosition(0);
                    }
                });
            }
        });
    }

    private String formatSystemProperties(Properties properties) {
        StringBuffer text = new StringBuffer(200);
        ArrayList<Object> keys = new ArrayList<Object>(properties.keySet());
        Collections.sort(keys);
        for (String string : keys) {
            String val = properties.getProperty(string);
            text.append("<nobr>&nbsp;&nbsp;&nbsp;&nbsp;<b>");
            text.append(string);
            text.append("</b>=");
            text.append(val);
            text.append("</nobr><br>");
        }
        return text.toString();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JSeparator separator = new JSeparator(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, 1);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 1);
            }
        };
        separator.setBackground(this.getBackground());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)separator, constraints);
        this.dataArea = new HTMLTextArea(){

            protected void showURL(URL url) {
                SummaryControllerUI.this.createData(true);
            }
        };
        JScrollPane dataAreaScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
        dataAreaScrollPane.setBorder(BorderFactory.createEmptyBorder());
        dataAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        dataAreaScrollPane.setBackground(this.dataArea.getBackground());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)dataAreaScrollPane, constraints);
        this.setBackground(this.dataArea.getBackground());
    }

    private static class Presenter
    extends JToggleButton {
        private static ImageIcon ICON_INFO = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/infoTab.png"));

        public Presenter() {
            this.setText(VIEW_TITLE);
            this.setToolTipText(VIEW_DESCR);
            this.setIcon(ICON_INFO);
            this.setMargin(new Insets(this.getMargin().top, this.getMargin().top, this.getMargin().bottom, this.getMargin().top));
        }
    }
}

