/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.text.MessageFormat;
import java.util.List;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.profiler.heapwalk.model.ArrayNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.openide.util.NbBundle;

public class ObjectArrayNode
extends ArrayNode {
    private static final String ITEMS_NUMBER_STRING = NbBundle.getMessage(ObjectArrayNode.class, (String)"ObjectArrayNode_ItemsNumberString");
    private static final String LOOP_TO_STRING = NbBundle.getMessage(ObjectArrayNode.class, (String)"ObjectArrayNode_LoopToString");

    public ObjectArrayNode(ObjectArrayInstance instance, String name, HeapWalkerNode parent) {
        super((Instance)instance, name, parent);
    }

    public ObjectArrayNode(ObjectArrayInstance instance, String name, HeapWalkerNode parent, int mode) {
        super((Instance)instance, name, parent, mode);
    }

    public ObjectArrayInstance getInstance() {
        return (ObjectArrayInstance)super.getInstance();
    }

    public boolean isPrimitive() {
        return false;
    }

    protected ChildrenComputer getChildrenComputer() {
        return new ChildrenComputer(){

            public HeapWalkerNode[] computeChildren() {
                HeapWalkerNode[] children;
                block10: {
                    block9: {
                        children = null;
                        if (ObjectArrayNode.this.getMode() != 1) break block9;
                        int fieldsSize = ObjectArrayNode.this.getInstance().getLength();
                        if (fieldsSize == 0) {
                            children = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoItemsNode(ObjectArrayNode.this)};
                        } else if (fieldsSize > HeapWalkerNodeFactory.ITEMS_COLLAPSE_UNIT_SIZE) {
                            int childrenCount = fieldsSize;
                            BrowserUtils.GroupingInfo groupingInfo = BrowserUtils.getGroupingInfo(childrenCount);
                            int containersCount = groupingInfo.containersCount;
                            int collapseUnitSize = groupingInfo.collapseUnitSize;
                            children = new HeapWalkerNode[containersCount];
                            for (int i = 0; i < containersCount; ++i) {
                                int unitStartIndex = collapseUnitSize * i;
                                int unitEndIndex = Math.min(unitStartIndex + collapseUnitSize, childrenCount) - 1;
                                children[i] = HeapWalkerNodeFactory.createArrayItemContainerNode(ObjectArrayNode.this, unitStartIndex, unitEndIndex);
                            }
                        } else {
                            List fields = ObjectArrayNode.this.getInstance().getValues();
                            children = new HeapWalkerNode[fields.size()];
                            for (int i = 0; i < children.length; ++i) {
                                children[i] = HeapWalkerNodeFactory.createObjectArrayItemNode(ObjectArrayNode.this, i, (Instance)fields.get(i));
                            }
                        }
                        break block10;
                    }
                    if (ObjectArrayNode.this.getMode() != 2) break block10;
                    List fields = ObjectArrayNode.this.getInstance().getReferences();
                    if (fields.size() == 0) {
                        children = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoReferencesNode(ObjectArrayNode.this)};
                    } else {
                        children = new HeapWalkerNode[fields.size()];
                        for (int i = 0; i < children.length; ++i) {
                            children[i] = HeapWalkerNodeFactory.createReferenceNode((Value)fields.get(i), ObjectArrayNode.this);
                        }
                    }
                }
                return children;
            }
        };
    }

    protected String computeValue() {
        if (!this.hasInstance()) {
            return super.computeValue();
        }
        return super.computeValue() + " " + MessageFormat.format(ITEMS_NUMBER_STRING, this.getInstance().getLength());
    }

    public static abstract class RootNode
    extends ObjectArrayNode
    implements org.netbeans.modules.profiler.heapwalk.model.RootNode {
        public RootNode(ObjectArrayInstance instance, String name, HeapWalkerNode parent) {
            super(instance, name, parent);
        }

        public RootNode(ObjectArrayInstance instance, String name, HeapWalkerNode parent, int mode) {
            super(instance, name, parent, mode);
        }

        public abstract void refreshView();
    }

    public static class ArrayItem
    extends ObjectArrayNode
    implements org.netbeans.modules.profiler.heapwalk.model.ArrayItem {
        private int itemIndex;

        public ArrayItem(int itemIndex, ObjectArrayInstance instance, HeapWalkerNode parent) {
            this(itemIndex, instance, parent, parent == null ? 1 : parent.getMode());
        }

        public ArrayItem(int itemIndex, ObjectArrayInstance instance, HeapWalkerNode parent, int mode) {
            super(instance, null, parent, mode);
            this.itemIndex = itemIndex;
        }

        public int getItemIndex() {
            return this.itemIndex;
        }

        protected String computeName() {
            String name = "[" + this.itemIndex + "]";
            if (this.isLoop()) {
                return name + " " + MessageFormat.format(LOOP_TO_STRING, BrowserUtils.getFullNodeName(this.getLoopTo()));
            }
            return name;
        }

        protected String computeType() {
            if (!this.hasInstance()) {
                return "<" + BrowserUtils.getArrayItemType(this.getType()) + ">";
            }
            return super.computeType();
        }
    }
}

