/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.Type;
import org.netbeans.modules.profiler.heapwalk.memorylint.Distribution;

public final class Walker {
    private static final Type OBJECT = new Type(){

        public String getName() {
            return "object";
        }
    };
    private Distribution log = new Distribution();

    public Distribution getResults() {
        return this.log;
    }

    public void walk(Instance in) {
        this.walk(in, null);
    }

    public void walk(Instance in, Filter f) {
        LinkedList<Instance> q = new LinkedList<Instance>();
        q.add(in);
        this.log.add(in);
        while (!q.isEmpty()) {
            List out;
            Instance act = (Instance)q.poll();
            if (act instanceof ObjectArrayInstance) {
                out = ((ObjectArrayInstance)act).getValues();
                int i = 0;
                for (Instance target : out) {
                    if (target != null && f.accept(new ArrayEntryValue(i, act, target)) && !this.log.isCounted(target)) {
                        this.log.add(target);
                        q.add(target);
                    }
                    ++i;
                }
            }
            out = act.getFieldValues();
            for (FieldValue fv : out) {
                Instance target;
                if (!(fv instanceof ObjectFieldValue)) continue;
                ObjectFieldValue ofv = (ObjectFieldValue)fv;
                if (f != null && !f.accept(ofv) || (target = ofv.getInstance()) == null || this.log.isCounted(target)) continue;
                this.log.add(target);
                q.add(target);
            }
        }
    }

    public static interface Filter {
        public boolean accept(ObjectFieldValue var1);
    }

    private class ArrayEntryValue
    implements ObjectFieldValue,
    Field {
        int idx;
        private Instance src;
        private Instance target;

        public ArrayEntryValue(int idx, Instance src, Instance target) {
            this.idx = idx;
            this.src = src;
            this.target = target;
        }

        public Instance getInstance() {
            return this.target;
        }

        public Field getField() {
            return this;
        }

        public String getValue() {
            return "Instance #" + this.target.getInstanceId();
        }

        public Instance getDefiningInstance() {
            return this.src;
        }

        public JavaClass getDeclaringClass() {
            return this.src.getJavaClass();
        }

        public String getName() {
            return "[" + this.idx + "]";
        }

        public boolean isStatic() {
            return false;
        }

        public Type getType() {
            return OBJECT;
        }
    }
}

