/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Comparator;
import java.util.concurrent.CountDownLatch;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.ui.ReferencesBrowserControllerUI;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public class ReferencesBrowserController
extends AbstractController {
    private static final String NO_INSTANCE_SELECTED_STRING = NbBundle.getMessage(ReferencesBrowserController.class, (String)"ReferencesBrowserController_NoInstanceSelectedString");
    private static final String NONE_STRING = NbBundle.getMessage(ReferencesBrowserController.class, (String)"ReferencesBrowserController_NoneString");
    private static final String PROGRESS_DIALOG_CAPTION = NbBundle.getMessage(ReferencesBrowserController.class, (String)"ReferencesBrowserController_ProgressDialogCaption");
    private static final String PROGRESS_MSG = NbBundle.getMessage(ReferencesBrowserController.class, (String)"ReferencesBrowserController_ProgressMsg");
    private static final String SELF_GCROOT_MSG = NbBundle.getMessage(ReferencesBrowserController.class, (String)"ReferencesBrowserController_SelfGcRootMsg");
    private static final String NO_GCROOT_MSG = NbBundle.getMessage(ReferencesBrowserController.class, (String)"ReferencesBrowserController_NoGcRootMsg");
    public static final AbstractHeapWalkerNode EMPTY_INSTANCE_NODE = new AbstractHeapWalkerNode(null){

        protected String computeName() {
            return NO_INSTANCE_SELECTED_STRING;
        }

        protected String computeType() {
            return NONE_STRING;
        }

        protected String computeValue() {
            return NONE_STRING;
        }

        protected Icon computeIcon() {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    };
    private static final int DEFAULT_WIDTH = 350;
    private static final int DEFAULT_HEIGHT = 100;
    private Handler referencesControllerHandler;
    private Instance instance;

    public ReferencesBrowserController(Handler referencesControllerHandler) {
        this.referencesControllerHandler = referencesControllerHandler;
    }

    public HeapWalkerNode getFilteredSortedFields(String filterValue, int sortingColumn, boolean sortingOrder) {
        if (this.instance == null) {
            return EMPTY_INSTANCE_NODE;
        }
        return this.getSortedFields(this.getFilteredFields(this.getFields(this.instance), filterValue), sortingColumn, sortingOrder);
    }

    public void setInstance(Instance instance) {
        this.instance = instance;
        this.update();
    }

    public void createNavigationHistoryPoint() {
        this.referencesControllerHandler.getHeapFragmentWalker().createNavigationHistoryPoint();
    }

    public void navigateToClass(JavaClass javaClass) {
        this.referencesControllerHandler.showClass(javaClass);
    }

    public void navigateToInstance(Instance instance) {
        this.referencesControllerHandler.showInstance(instance);
    }

    public void navigateToNearestGCRoot(final InstanceNode instanceNode) {
        new NBSwingWorker(true){
            private Dialog progress;
            HeapWalkerNode gcRootNode;
            {
                super(x0);
                this.progress = null;
                this.gcRootNode = null;
            }

            public void doInBackground() {
                this.gcRootNode = BrowserUtils.computeChildrenToNearestGCRoot(instanceNode);
            }

            public void nonResponding() {
                final CountDownLatch latch = new CountDownLatch(1);
                this.progress = ReferencesBrowserController.this.createProgressPanel(PROGRESS_MSG);
                this.progress.addHierarchyListener(new HierarchyListener(){

                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) > 0L) {
                            latch.countDown();
                        }
                    }
                });
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        progress.setVisible(true);
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            public void done() {
                if (this.progress != null) {
                    this.progress.setVisible(false);
                    this.progress.dispose();
                }
                if (this.gcRootNode != null) {
                    if (instanceNode == this.gcRootNode) {
                        NetBeansProfiler.getDefaultNB().displayInfo(SELF_GCROOT_MSG);
                    } else {
                        ReferencesBrowserControllerUI controlerUI = (ReferencesBrowserControllerUI)((Object)ReferencesBrowserController.this.getPanel());
                        controlerUI.selectNode(this.gcRootNode);
                    }
                } else {
                    NetBeansProfiler.getDefaultNB().displayInfo(NO_GCROOT_MSG);
                }
            }
        }.execute();
    }

    public void showInstance(Instance instance) {
        if (this.instance != instance) {
            this.setInstance(instance);
        }
    }

    public void update() {
        ((ReferencesBrowserControllerUI)((Object)this.getPanel())).update();
    }

    protected AbstractButton createControllerPresenter() {
        return ((ReferencesBrowserControllerUI)((Object)this.getPanel())).getPresenter();
    }

    protected JPanel createControllerUI() {
        return new ReferencesBrowserControllerUI(this);
    }

    Dialog createProgressPanel(String message) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(10, 10));
        panel.setBorder(new EmptyBorder(15, 15, 15, 15));
        panel.add((Component)new JLabel(message), "North");
        Dimension ps = panel.getPreferredSize();
        ps.setSize(Math.max(ps.getWidth(), 350.0), Math.max(ps.getHeight(), 100.0));
        panel.setPreferredSize(ps);
        JProgressBar progress = new JProgressBar();
        progress.setIndeterminate(true);
        panel.add((Component)progress, "South");
        Dialog dialog = ProfilerDialogs.createDialog(new DialogDescriptor((Object)panel, PROGRESS_DIALOG_CAPTION, true, new Object[0], DialogDescriptor.CANCEL_OPTION, 1, null, null));
        return dialog;
    }

    private HeapWalkerNode getFields(Instance instance) {
        return HeapWalkerNodeFactory.createRootInstanceNode(instance, "this", new Runnable(){

            public void run() {
                ((ReferencesBrowserControllerUI)((Object)ReferencesBrowserController.this.getPanel())).refreshView();
            }
        }, 2, this.referencesControllerHandler.getHeapFragmentWalker().getHeapFragment());
    }

    private HeapWalkerNode getFilteredFields(HeapWalkerNode fields, String filterValue) {
        return fields;
    }

    private HeapWalkerNode getSortedFields(HeapWalkerNode filteredFields, int sortingColumn, boolean sortingOrder) {
        return filteredFields;
    }

    private boolean matchesFilter(FieldValue field) {
        return true;
    }

    private class FieldsComparator
    implements Comparator {
        private boolean sortingOrder;
        private int sortingColumn;

        public FieldsComparator(int sortingColumn, boolean sortingOrder) {
            this.sortingColumn = sortingColumn;
            this.sortingOrder = sortingOrder;
        }

        public int compare(Object o1, Object o2) {
            FieldValue field1 = this.sortingOrder ? (FieldValue)o1 : (FieldValue)o2;
            FieldValue field2 = this.sortingOrder ? (FieldValue)o2 : (FieldValue)o1;
            switch (this.sortingColumn) {
                case 0: {
                    return field1.getField().getName().compareTo(field2.getField().getName());
                }
                case 1: {
                    return field1.getField().getType().getName().compareTo(field2.getField().getType().getName());
                }
                case 2: {
                    return field1.getValue().compareTo(field2.getValue());
                }
            }
            throw new RuntimeException("Unsupported compare operation for " + o1 + ", " + o2);
        }
    }

    public static interface Handler {
        public HeapFragmentWalker getHeapFragmentWalker();

        public void showClass(JavaClass var1);

        public void showInstance(Instance var1);
    }
}

