/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl.writer;

import com.sun.xml.internal.txw2.TypedXmlWriter;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.model.CheckedException;
import com.sun.xml.internal.ws.api.model.JavaMethod;
import com.sun.xml.internal.ws.api.wsdl.writer.WSDLGenExtnContext;
import com.sun.xml.internal.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.internal.ws.wsdl.writer.UsingAddressing;
import javax.xml.ws.Action;
import javax.xml.ws.FaultAction;
import javax.xml.ws.soap.AddressingFeature;

public class W3CAddressingWSDLGeneratorExtension
extends WSDLGeneratorExtension {
    private boolean enabled;
    private boolean required = false;

    public void start(WSDLGenExtnContext wSDLGenExtnContext) {
        WSBinding wSBinding = wSDLGenExtnContext.getBinding();
        TypedXmlWriter typedXmlWriter = wSDLGenExtnContext.getRoot();
        this.enabled = wSBinding.isFeatureEnabled(AddressingFeature.class);
        if (!this.enabled) {
            return;
        }
        AddressingFeature addressingFeature = wSBinding.getFeature(AddressingFeature.class);
        this.required = addressingFeature.isRequired();
        typedXmlWriter._namespace(AddressingVersion.W3C.wsdlNsUri, AddressingVersion.W3C.getWsdlPrefix());
    }

    public void addOperationInputExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod) {
        if (!this.enabled) {
            return;
        }
        Action action = javaMethod.getSEIMethod().getAnnotation(Action.class);
        if (action != null && !action.input().equals("")) {
            this.addAttribute(typedXmlWriter, action.input());
        }
    }

    public void addOperationOutputExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod) {
        if (!this.enabled) {
            return;
        }
        Action action = javaMethod.getSEIMethod().getAnnotation(Action.class);
        if (action != null && !action.output().equals("")) {
            this.addAttribute(typedXmlWriter, action.output());
        }
    }

    public void addOperationFaultExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod, CheckedException checkedException) {
        if (!this.enabled) {
            return;
        }
        Action action = javaMethod.getSEIMethod().getAnnotation(Action.class);
        Class<?>[] classArray = javaMethod.getSEIMethod().getExceptionTypes();
        if (classArray == null) {
            return;
        }
        if (action != null && action.fault() != null) {
            for (FaultAction faultAction : action.fault()) {
                if (!faultAction.className().getName().equals(checkedException.getExceptionClass().getName())) continue;
                if (faultAction.value().equals("")) {
                    return;
                }
                this.addAttribute(typedXmlWriter, faultAction.value());
                return;
            }
        }
    }

    private void addAttribute(TypedXmlWriter typedXmlWriter, String string) {
        typedXmlWriter._attribute(AddressingVersion.W3C.wsdlActionTag, (Object)string);
    }

    public void addBindingExtension(TypedXmlWriter typedXmlWriter) {
        if (!this.enabled) {
            return;
        }
        UsingAddressing usingAddressing = typedXmlWriter._element(AddressingVersion.W3C.wsdlExtensionTag, UsingAddressing.class);
    }
}

