/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CachedJarFile;
import com.sun.deploy.cache.CachedJarFile14;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.SyncFileAccess;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class CacheEntry {
    private File indexFile = null;
    private SyncFileAccess indexFileSyncAccess = null;
    private File tempDataFile = null;
    private int busy = 1;
    private int incomplete = 0;
    private int forceUpdate = 0;
    private int noHref = 0;
    private int cacheVersion = Cache.getCacheVersion();
    private int contentLength = 0;
    private int isShortcutImage = 0;
    private long lastModified = 0L;
    private long expirationDate = 0L;
    private String version = null;
    private String url = "";
    private String namespaceID = "";
    private MessageHeader headerFields = new MessageHeader();
    private String filename = null;
    private String codebaseIP = null;
    private static final String CODEBASEIP_HEADER_KEY = "deploy_resource_codebase_ip";
    private static final String META_FILE_DIR = "META-INF/";
    private static final String JAR_INDEX_NAME = "META-INF/INDEX.LIST";
    private SoftReference manifestRef = null;
    private long manifestPosition = -1L;
    private boolean doneReadManifest = false;
    private SoftReference signerMapRef;
    private SoftReference signersRef = null;
    private SoftReference signerMapCertRef;
    private SoftReference certificatesRef = null;
    private static Map emptyMap = Collections.unmodifiableMap(new HashMap(1));

    public CacheEntry(File file) {
        String string = file.getPath();
        this.filename = string.substring(0, string.length() - 4);
        this.indexFile = file;
        this.indexFileSyncAccess = new SyncFileAccess(this.indexFile);
        this.tempDataFile = new File(this.filename + "-temp");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CacheEntry.this.readIndexFile();
                return null;
            }
        });
    }

    public void generateShortcutImage() throws IOException {
        if (this.getIsShortcutImage() == 0) {
            this.setIsShortcutImage(1);
            this.writeFileToDisk();
        }
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return ((Object)principal2).equals(principal = x509Certificate2.getSubjectDN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile openLockIndexFile(String string, boolean bl) throws IOException {
        RandomAccessFile randomAccessFile;
        block2: {
            SyncFileAccess.RandomAccessFileLock randomAccessFileLock = null;
            RandomAccessFile randomAccessFile2 = null;
            try {
                randomAccessFileLock = this.indexFileSyncAccess.openLockRandomAccessFile(string, 1000, bl);
                randomAccessFile = randomAccessFile2 = randomAccessFileLock != null ? randomAccessFileLock.getRandomAccessFile() : null;
                Object var7_6 = null;
                if (randomAccessFileLock == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (randomAccessFileLock == null) break block3;
                    randomAccessFileLock.release();
                }
                throw throwable;
            }
            randomAccessFileLock.release();
        }
        return randomAccessFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readIndexFile() {
        block15: {
            RandomAccessFile randomAccessFile;
            block14: {
                randomAccessFile = null;
                if (!this.indexFile.exists()) break block14;
                randomAccessFile = this.openLockIndexFile("r", false);
                this.setBusy(randomAccessFile.read());
                this.setIncomplete(randomAccessFile.read());
                this.setCacheVersion(randomAccessFile.readInt());
                if (this.getCacheVersion() == Cache.getCacheVersion()) {
                    this.setForceUpdate(randomAccessFile.read());
                    this.setNoHref(randomAccessFile.read());
                    this.setIsShortcutImage(randomAccessFile.read());
                    this.setContentLength(randomAccessFile.readInt());
                    this.setLastModified(randomAccessFile.readLong());
                    this.setExpirationDate(randomAccessFile.readLong());
                    this.setVersion(randomAccessFile.readUTF());
                    this.setURL(randomAccessFile.readUTF());
                    this.setNamespaceID(randomAccessFile.readUTF());
                    File file = new File(this.getResourceFilename());
                    if (!file.exists()) {
                        this.setIncomplete(1);
                    }
                } else {
                    this.setIncomplete(1);
                }
                if (this.getIncomplete() != 0) break block14;
                this.readHeaders(randomAccessFile);
                if (!this.isJarFile(this.url)) break block14;
                this.manifestPosition = randomAccessFile.getFilePointer();
            }
            Object var4_4 = null;
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                break block15;
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            break block15;
            {
                catch (IOException iOException) {
                    this.setIncomplete(1);
                    Trace.ignoredException(iOException);
                    Object var4_5 = null;
                    try {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {
                        Trace.ignoredException(iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                throw throwable;
            }
        }
    }

    public void setBusy(int n) {
        this.busy = n;
    }

    int getBusy() {
        return this.busy;
    }

    private void setCacheVersion(int n) {
        this.cacheVersion = n;
    }

    int getCacheVersion() {
        return this.cacheVersion;
    }

    public void setIncomplete(int n) {
        this.incomplete = n;
    }

    int getIncomplete() {
        return this.incomplete;
    }

    public boolean isValidEntry() {
        return this.busy == 0 && this.incomplete == 0;
    }

    public void setIsShortcutImage(int n) {
        this.isShortcutImage = n;
    }

    public int getIsShortcutImage() {
        return this.isShortcutImage;
    }

    private void setForceUpdate(int n) {
        this.forceUpdate = n;
    }

    private int getForceUpdate() {
        return this.forceUpdate;
    }

    void setNoHref(int n) {
        this.noHref = n;
    }

    private int getNoHref() {
        return this.noHref;
    }

    boolean removeBefore(CacheEntry cacheEntry) {
        long l;
        long l2;
        if (this.getIncomplete() == 1) {
            return true;
        }
        if (cacheEntry.getIncomplete() == 1) {
            return false;
        }
        long l3 = this.getIndexFile().lastModified();
        if (l3 < (l2 = cacheEntry.getIndexFile().lastModified())) {
            return true;
        }
        if (l3 > l2) {
            return false;
        }
        long l4 = System.currentTimeMillis();
        long l5 = this.getExpirationDate();
        if (l5 != (l = cacheEntry.getExpirationDate())) {
            if (l5 < l4) {
                return true;
            }
            if (l < l4) {
                return false;
            }
        }
        return this.getContentLength() >= cacheEntry.getContentLength();
    }

    void setContentLength(int n) {
        this.contentLength = n;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Map getCertificateMap() {
        if (!this.doneReadManifest || this.signerMapCertRef != null && this.signerMapCertRef.get() == null) {
            try {
                this.readManifest();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
        if (this.signerMapCertRef == null) {
            return emptyMap;
        }
        return (Map)this.signerMapCertRef.get();
    }

    public Map getSignerMap() {
        if (!this.doneReadManifest || this.signerMapRef != null && this.signerMapRef.get() == null) {
            try {
                this.readManifest();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
        if (this.signerMapRef == null) {
            return emptyMap;
        }
        return (Map)this.signerMapRef.get();
    }

    public CodeSigner[] getCodeSigners() {
        if (!this.doneReadManifest || this.signersRef != null && this.signersRef.get() == null) {
            try {
                this.readManifest();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
        if (this.signersRef == null) {
            return null;
        }
        return (CodeSigner[])this.signersRef.get();
    }

    public Certificate[] getCertificates() {
        if (!this.doneReadManifest || this.certificatesRef != null && this.certificatesRef.get() == null) {
            try {
                this.readManifest();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
        if (this.certificatesRef == null) {
            return null;
        }
        return (Certificate[])this.certificatesRef.get();
    }

    void setLastModified(long l) {
        this.lastModified = l;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    void setExpirationDate(long l) {
        this.expirationDate = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateExpirationInIndexFile(long l) {
        block12: {
            if (this.getExpirationDate() == l) {
                return;
            }
            this.setExpirationDate(l);
            RandomAccessFile randomAccessFile = null;
            randomAccessFile = this.openLockIndexFile("rw", true);
            randomAccessFile.seek(21L);
            randomAccessFile.writeLong(this.expirationDate);
            Object var6_3 = null;
            try {
                if (null != randomAccessFile) {
                    randomAccessFile.close();
                }
                break block12;
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            break block12;
            {
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                    Object var6_4 = null;
                    try {
                        if (null != randomAccessFile) {
                            randomAccessFile.close();
                        }
                        break block12;
                    }
                    catch (IOException iOException2) {
                        Trace.ignoredException(iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    if (null != randomAccessFile) {
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                throw throwable;
            }
        }
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public boolean isExpired() {
        return this.expirationDate == 0L || System.currentTimeMillis() >= this.expirationDate;
    }

    void setURL(String string) {
        this.url = string;
    }

    public String getURL() {
        return this.url;
    }

    void setVersion(String string) {
        this.version = string == null || string.equals("") ? null : string;
    }

    public String getVersion() {
        return this.version;
    }

    private void setNamespaceID(String string) {
        this.namespaceID = string;
    }

    private String getNamespaceID() {
        return this.namespaceID;
    }

    public JarFile getJarFile() {
        JarFile jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (Config.isJavaVersionAtLeast15()) {
                    CachedJarFile cachedJarFile = null;
                    try {
                        cachedJarFile = new CachedJarFile(CacheEntry.this);
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException(iOException);
                    }
                    return cachedJarFile;
                }
                CachedJarFile14 cachedJarFile14 = null;
                try {
                    cachedJarFile14 = new CachedJarFile14(CacheEntry.this);
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                return cachedJarFile14;
            }
        });
        return jarFile;
    }

    public String getResourceFilename() {
        return this.filename;
    }

    public File getDataFile() {
        File file = null;
        if (this.filename != null && !this.url.equals("")) {
            file = new File(this.filename);
            MemoryCache.addResourceReference(file, this.url);
        }
        return file;
    }

    File getTempDataFile() {
        return this.tempDataFile;
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    public long getSize() {
        return this.getDataFile().length() + this.getIndexFile().length();
    }

    void setHeaders(MessageHeader messageHeader) {
        this.headerFields = messageHeader;
    }

    public Map getHeaders() {
        return this.headerFields.getHeaders();
    }

    public boolean isHttpNoCacheEnabled() {
        String string = this.headerFields.getValue(this.headerFields.getKey("cache-control"));
        if (string != null && string.equals("no-cache")) {
            return true;
        }
        String string2 = this.headerFields.getValue(this.headerFields.getKey("pragma"));
        return string2 != null && string2.equals("no-cache");
    }

    boolean processTempDataFile(boolean bl, DownloadEngine.DownloadDelegate downloadDelegate, URL uRL, URL uRL2, String string) {
        boolean bl2 = false;
        if (bl) {
            String string2 = null;
            String string3 = uRL2.getQuery().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "&");
            String string4 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                if (!string4.startsWith("current-version-id")) continue;
                string2 = string4.substring("current-version-id".length() + 1);
                break;
            }
            CacheEntry cacheEntry = null;
            cacheEntry = Cache.getCacheEntry(uRL, null, string2);
            File file = null;
            if (cacheEntry != null) {
                file = new File(cacheEntry.getResourceFilename());
            }
            File file2 = null;
            try {
                Trace.println(ResourceManager.getString("cacheEntry.applyJarDiff", uRL == null ? "" : uRL.toString(), string2, string), TraceLevel.NETWORK);
                file2 = DownloadEngine.applyPatch(file, this.tempDataFile, uRL, string, downloadDelegate, this.filename);
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            this.tempDataFile.delete();
            if (file2 != null) {
                bl2 = true;
            }
        }
        if (this.tempDataFile.renameTo(new File(this.filename))) {
            bl2 = true;
        }
        return bl2;
    }

    public Manifest getManifest() {
        if (!this.doneReadManifest || this.manifestRef != null && this.manifestRef.get() == null) {
            try {
                this.readManifest();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
        if (this.manifestRef == null) {
            return null;
        }
        return (Manifest)this.manifestRef.get();
    }

    private void setCodebaseIP(String string) {
        this.codebaseIP = string;
    }

    public String getCodebaseIP() {
        return this.codebaseIP;
    }

    private void setManifest(Manifest manifest) {
        if (manifest != null) {
            CachedJarFile.makeManifestImmutable(manifest);
            this.manifestRef = new SoftReference<Manifest>(manifest);
        } else {
            this.manifestRef = null;
        }
    }

    public void writeFileToDisk() throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        CacheEntry.this.writeFileToDisk(1, null);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    private boolean hasMimeType(String string) {
        if (this.headerFields != null) {
            Object v = this.getHeaders().get("content-type");
            if (!(v instanceof List)) {
                return false;
            }
            List list = (List)v;
            return list.contains(string);
        }
        return false;
    }

    private boolean hasRequestType(String string) {
        if (this.headerFields != null) {
            Object v = this.getHeaders().get("deploy-request-content-type");
            if (!(v instanceof List)) {
                return false;
            }
            List list = (List)v;
            return list.contains(string);
        }
        return false;
    }

    private boolean isJarFile(String string) {
        if (this.hasRequestType("application/x-java-archive")) {
            return true;
        }
        int n = string.indexOf(";");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("?")) != -1) {
            string = string.substring(0, n);
        }
        return string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith(".jarjar") || this.hasMimeType("application/x-java-archive") || this.hasMimeType("application/java-archive") || this.hasMimeType("application/x-java-archive-diff");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writeFileToDisk(int n, DownloadEngine.DownloadDelegate downloadDelegate) throws IOException {
        ZipFile zipFile;
        block18: {
            zipFile = null;
            RandomAccessFile randomAccessFile = null;
            try {
                try {
                    Object object;
                    randomAccessFile = this.openLockIndexFile("rw", false);
                    randomAccessFile.writeByte(this.busy);
                    randomAccessFile.writeByte(this.incomplete);
                    randomAccessFile.writeInt(this.cacheVersion);
                    randomAccessFile.writeByte(this.forceUpdate);
                    randomAccessFile.writeByte(this.noHref);
                    randomAccessFile.writeByte(this.isShortcutImage);
                    randomAccessFile.writeInt(this.contentLength);
                    randomAccessFile.writeLong(this.lastModified);
                    randomAccessFile.writeLong(this.expirationDate);
                    randomAccessFile.writeUTF(this.version == null ? "" : this.version);
                    randomAccessFile.writeUTF(this.url);
                    randomAccessFile.writeUTF(this.namespaceID);
                    InetAddress inetAddress = null;
                    if (this.url != null && !this.url.equals("")) {
                        object = new URL(this.url);
                        String string = ((URL)object).getHost();
                        inetAddress = Cache.getHostIP(string);
                    }
                    if (this.headerFields != null || inetAddress != null) {
                        if (inetAddress != null) {
                            if (this.headerFields == null) {
                                this.headerFields = new MessageHeader();
                            }
                            this.headerFields.add(CODEBASEIP_HEADER_KEY, inetAddress.getHostAddress());
                        }
                        this.writeHeaders(randomAccessFile);
                    } else {
                        randomAccessFile.writeInt(0);
                    }
                    if (this.incomplete == 0) {
                        if (this.isJarFile(this.url)) {
                            zipFile = new JarFile(new File(this.filename));
                            object = ((JarFile)zipFile).getManifest();
                            this.manifestPosition = randomAccessFile.getFilePointer();
                            this.writeManifest(randomAccessFile, (JarFile)zipFile, (Manifest)object, n, downloadDelegate);
                            this.setManifest((Manifest)object);
                        }
                        DownloadEngine.addToUpdateCheckDoneList(this.url);
                        Cache.addToCleanupThreadLoadedResourceList(this.url);
                    }
                }
                catch (Exception exception) {
                    Trace.ignoredException(exception);
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                        randomAccessFile = null;
                    }
                    if (zipFile != null) {
                        zipFile.close();
                        zipFile = null;
                    }
                    Cache.removeCacheEntry(this);
                    if (exception instanceof JARSigningException) {
                        throw (JARSigningException)exception;
                    }
                    if (!(exception instanceof ZipException)) throw new IOException(exception.getMessage());
                    throw new JARSigningException(new URL(this.url), this.version, 2, exception);
                }
                Object var9_9 = null;
                if (randomAccessFile == null) break block18;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (zipFile != null) {
                    zipFile.close();
                }
                Cache.cleanup();
                throw throwable;
            }
            randomAccessFile.close();
        }
        if (zipFile != null) {
            zipFile.close();
        }
        Cache.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void readManifest() throws IOException {
        if (this.manifestPosition == -1L) return;
        RandomAccessFile randomAccessFile = this.openLockIndexFile("r", false);
        randomAccessFile.seek(this.manifestPosition);
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(randomAccessFile.getFD()));
            this.readManifest(bufferedInputStream);
            this.doneReadManifest = true;
            Object var4_3 = null;
            if (randomAccessFile == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (randomAccessFile == null) throw throwable;
            randomAccessFile.close();
            throw throwable;
        }
        randomAccessFile.close();
    }

    private void readManifest(BufferedInputStream bufferedInputStream) throws IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        ObjectInputStream objectInputStream = null;
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        objectInputStream = new ObjectInputStream(bufferedInputStream);
        bufferedReader = new BufferedReader(new InputStreamReader(objectInputStream));
        int n2 = objectInputStream.readInt();
        if (n2 > 0) {
            byte[] byArray = new byte[n2];
            objectInputStream.readFully(byArray, 0, n2);
            object3 = new ByteArrayInputStream(byArray);
            object2 = new GZIPInputStream((InputStream)object3);
            object = new Manifest();
            ((Manifest)object).read((InputStream)object2);
            ((GZIPInputStream)object2).close();
            if (!Environment.isJavaPlugin()) {
                ((Manifest)object).getMainAttributes().remove(Attributes.Name.CLASS_PATH);
            }
            this.setManifest((Manifest)object);
        }
        if ((n = objectInputStream.readInt()) > 0) {
            int n3;
            Object object4;
            String string;
            object3 = new HashMap();
            object2 = new HashMap();
            object = new Certificate[n];
            this.signerMapRef = new SoftReference<Object>(object3);
            this.signerMapCertRef = new SoftReference<Object>(object2);
            this.certificatesRef = new SoftReference<Object>(object);
            try {
                for (int i = 0; i < n; ++i) {
                    object[i] = (Certificate)objectInputStream.readObject();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Error reading signer certificates");
            }
            String string2 = bufferedReader.readLine();
            String string3 = null;
            while (string2 != null && !string2.equals("")) {
                string = string2;
                if (string.startsWith("/")) {
                    string = string3 + string;
                } else {
                    int n4 = string.lastIndexOf("/");
                    if (n4 != -1) {
                        string3 = string.substring(0, n4);
                    }
                }
                string2 = bufferedReader.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
                int n5 = Integer.parseInt(stringTokenizer.nextToken());
                object4 = new int[n5];
                for (n3 = 0; n3 < n5; ++n3) {
                    object4[n3] = Integer.parseInt(stringTokenizer.nextToken());
                }
                arrayList.add(string);
                object2.put(string, object4);
                string2 = bufferedReader.readLine();
            }
            if (Config.isJavaVersionAtLeast15()) {
                string = bufferedReader.readLine();
                int n6 = 0;
                if (string != null) {
                    n6 = Integer.parseInt(string);
                }
                if (n6 == 0) {
                    try {
                        int n7;
                        Object object5;
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        object4 = new ArrayList();
                        n3 = 0;
                        int n8 = 0;
                        int n9 = 0;
                        while (n9 < ((Object)object).length) {
                            Serializable serializable;
                            object5 = new ArrayList();
                            int n10 = n8;
                            for (n10 = n8; n10 < ((Object)object).length; ++n10) {
                                serializable = null;
                                Serializable serializable2 = null;
                                if (object[n10] instanceof X509Certificate) {
                                    serializable = (X509Certificate)object[n10];
                                }
                                serializable2 = n10 + 1 < ((Object)object).length && object[n10 + 1] instanceof X509Certificate ? (X509Certificate)object[n10 + 1] : serializable;
                                ((ArrayList)object5).add(serializable);
                                if (!CacheEntry.isIssuerOf((X509Certificate)serializable, (X509Certificate)serializable2)) break;
                            }
                            n9 = n10 < ((Object)object).length ? n10 + 1 : n10;
                            serializable = certificateFactory.generateCertPath((List<? extends Certificate>)object5);
                            ((ArrayList)object5).clear();
                            ((ArrayList)object4).add(serializable);
                            n8 = n9;
                            ++n3;
                        }
                        object5 = new CodeSigner[n3];
                        this.signersRef = new SoftReference<CodeSigner[]>((CodeSigner[])object5);
                        int[] nArray = new int[n3];
                        for (n7 = 0; n7 < n3; ++n7) {
                            object5[n7] = new CodeSigner((CertPath)((ArrayList)object4).get(n7), null);
                            nArray[n7] = n7;
                        }
                        for (n7 = 0; n7 < arrayList.size(); ++n7) {
                            object3.put(arrayList.get(n7), nArray);
                        }
                    }
                    catch (CertificateException certificateException) {
                        throw new IOException("Error process signer certificates");
                    }
                }
                if (n6 > 0) {
                    CodeSigner[] codeSignerArray = new CodeSigner[n6];
                    this.signersRef = new SoftReference<CodeSigner[]>(codeSignerArray);
                    try {
                        for (int i = 0; i < n6; ++i) {
                            codeSignerArray[i] = (CodeSigner)objectInputStream.readObject();
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IOException("Error reading code signer");
                    }
                    String string4 = bufferedReader.readLine();
                    String string5 = null;
                    while (string4 != null && !string4.equals("")) {
                        String string6 = string4;
                        if (string6.startsWith("/")) {
                            string6 = string5 + string6;
                        } else {
                            int n11 = string6.lastIndexOf("/");
                            if (n11 != -1) {
                                string5 = string6.substring(0, n11);
                            }
                        }
                        string4 = bufferedReader.readLine();
                        StringTokenizer stringTokenizer = new StringTokenizer(string4, " ", false);
                        int n12 = Integer.parseInt(stringTokenizer.nextToken());
                        int[] nArray = new int[n12];
                        for (int i = 0; i < n12; ++i) {
                            nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        object3.put(string6, nArray);
                        string4 = bufferedReader.readLine();
                    }
                }
            }
        } else {
            Trace.println(ResourceManager.getString("cacheEntry.unsignedJar", this.url), TraceLevel.NETWORK);
        }
    }

    public String getNativeLibPath() {
        return this.getResourceFilename() + "-n";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeManifest(RandomAccessFile randomAccessFile, JarFile jarFile, Manifest manifest, int n, DownloadEngine.DownloadDelegate downloadDelegate) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        ArrayList<CodeSigner> arrayList2 = new ArrayList<CodeSigner>();
        CodeSigner[] codeSignerArray = null;
        HashMap<Serializable[], Object> hashMap = new HashMap<Serializable[], Object>();
        HashMap<Serializable[], Object> hashMap2 = new HashMap<Serializable[], Object>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        FilterOutputStream filterOutputStream = null;
        byte[] byArray = new byte[2048];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        int n2 = jarFile.size();
        int n3 = 0;
        URL uRL = new URL(this.url);
        if (downloadDelegate != null) {
            downloadDelegate.validating(uRL, 0, n2);
        }
        while (enumeration.hasMoreElements()) {
            int n4;
            block35: {
                Object var26_33;
                object5 = enumeration.nextElement();
                object4 = ((ZipEntry)object5).getName();
                if (object4.startsWith(META_FILE_DIR) && !object4.equals(JAR_INDEX_NAME)) continue;
                object3 = null;
                int n5 = 0;
                try {
                    try {
                        object3 = jarFile.getInputStream((ZipEntry)object5);
                        if (DownloadEngine.isNativeContentType(n) && object4.indexOf("/") == -1 && object4.indexOf("\\") == -1 && ((File)(object2 = (Object)new File((File)(object = new File(this.getNativeLibPath()).getCanonicalFile()), (String)object4).getCanonicalFile())).getParentFile().equals(object)) {
                            ((File)object2).getParentFile().mkdirs();
                            filterOutputStream = new BufferedOutputStream(new FileOutputStream((File)object2));
                        }
                        while ((n5 = ((InputStream)object3).read(byArray, 0, byArray.length)) != -1) {
                            if (filterOutputStream == null) continue;
                            ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n5);
                        }
                        var26_33 = null;
                        if (filterOutputStream == null) break block35;
                    }
                    catch (SecurityException securityException) {
                        throw new JARSigningException(new URL(this.url), this.version, 2, securityException);
                    }
                }
                catch (Throwable throwable) {
                    var26_33 = null;
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                        filterOutputStream = null;
                    }
                    if (object3 == null) throw throwable;
                    ((InputStream)object3).close();
                    throw throwable;
                }
                filterOutputStream.close();
                filterOutputStream = null;
            }
            if (object3 != null) {
                ((InputStream)object3).close();
            }
            if ((object = ((JarEntry)object5).getCertificates()) != null && ((Certificate[])object).length > 0) {
                object2 = new int[((Certificate[])object).length];
                for (n4 = 0; n4 < ((Certificate[])object).length; ++n4) {
                    int n6 = arrayList.indexOf(object[n4]);
                    if (n6 == -1) {
                        n6 = arrayList.size();
                        arrayList.add(object[n4]);
                    }
                    object2[n4] = n6;
                }
                hashMap.put((Serializable[])object4, object2);
            }
            if (Config.isJavaVersionAtLeast15() && (codeSignerArray = ((JarEntry)object5).getCodeSigners()) != null && codeSignerArray.length > 0) {
                object2 = new int[codeSignerArray.length];
                for (n4 = 0; n4 < codeSignerArray.length; ++n4) {
                    int n7 = arrayList2.indexOf(codeSignerArray[n4]);
                    if (n7 == -1) {
                        n7 = arrayList2.size();
                        arrayList2.add(codeSignerArray[n4]);
                    }
                    object2[n4] = n7;
                }
                hashMap2.put((Serializable[])object4, object2);
            }
            if (downloadDelegate == null) continue;
            downloadDelegate.validating(uRL, ++n3, n2);
        }
        if (manifest != null) {
            object5 = new ByteArrayOutputStream();
            object4 = new GZIPOutputStream((OutputStream)object5);
            manifest.write((OutputStream)object4);
            object4.close();
            object3 = ((ByteArrayOutputStream)object5).toByteArray();
            objectOutputStream.writeInt(((byte[])object3).length);
            objectOutputStream.write((byte[])object3);
        } else {
            objectOutputStream.writeInt(0);
        }
        object5 = new BufferedWriter(new OutputStreamWriter(objectOutputStream));
        if (!arrayList.isEmpty()) {
            objectOutputStream.writeInt(arrayList.size());
            object4 = arrayList.iterator();
            while (object4.hasNext()) {
                objectOutputStream.writeObject(object4.next());
            }
            object3 = hashMap.keySet().iterator();
            String string = null;
            while (object3.hasNext()) {
                String string2;
                object = (String)object3.next();
                object2 = (int[])hashMap.get(object);
                if (object.indexOf("/") != -1) {
                    string2 = object.substring(0, object.lastIndexOf("/"));
                    if (string != null && string2.equals(string)) {
                        object = object.substring(string2.length());
                    }
                    string = string2;
                }
                ((Writer)object5).write((String)object);
                ((BufferedWriter)object5).newLine();
                string2 = String.valueOf(((int[])object2).length);
                for (int i = 0; i < ((int[])object2).length; ++i) {
                    string2 = string2 + " " + (int)object2[i];
                }
                ((BufferedWriter)object5).write(string2, 0, string2.length());
                ((BufferedWriter)object5).newLine();
            }
            ((BufferedWriter)object5).newLine();
            ((BufferedWriter)object5).flush();
        } else {
            objectOutputStream.writeInt(0);
        }
        if (!arrayList2.isEmpty()) {
            object4 = new Integer(arrayList2.size());
            ((Writer)object5).write(object4.toString());
            ((BufferedWriter)object5).newLine();
            ((BufferedWriter)object5).flush();
            object3 = arrayList2.iterator();
            while (object3.hasNext()) {
                objectOutputStream.writeObject(object3.next());
            }
            Iterator iterator = hashMap2.keySet().iterator();
            object = null;
            while (iterator.hasNext()) {
                String string;
                object2 = (String)iterator.next();
                int[] nArray = (int[])hashMap2.get(object2);
                if (((String)object2).indexOf("/") != -1) {
                    string = ((String)object2).substring(0, ((String)object2).lastIndexOf("/"));
                    if (object != null && string.equals(object)) {
                        object2 = ((String)object2).substring(string.length());
                    }
                    object = string;
                }
                ((Writer)object5).write((String)object2);
                ((BufferedWriter)object5).newLine();
                string = String.valueOf(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    string = string + " " + nArray[i];
                }
                ((BufferedWriter)object5).write(string, 0, string.length());
                ((BufferedWriter)object5).newLine();
            }
        } else {
            ((Writer)object5).write("0");
        }
        ((BufferedWriter)object5).flush();
        objectOutputStream.flush();
        randomAccessFile.write(byteArrayOutputStream.toByteArray());
        if (Config.isJavaVersionAtLeast15()) {
            if (!arrayList2.isEmpty()) {
                object4 = new CodeSigner[arrayList2.size()];
                this.signersRef = new SoftReference<Serializable[]>(arrayList2.toArray((T[])object4));
                this.signerMapRef = new SoftReference(hashMap2);
                return;
            }
            this.signersRef = null;
            this.signerMapRef = null;
            return;
        }
        if (!arrayList.isEmpty()) {
            object4 = new Certificate[arrayList.size()];
            this.certificatesRef = new SoftReference<Serializable[]>(arrayList.toArray((T[])object4));
            this.signerMapCertRef = new SoftReference(hashMap);
            return;
        }
        this.certificatesRef = null;
        this.signerMapCertRef = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaders(RandomAccessFile randomAccessFile) throws IOException {
        try {
            for (int i = randomAccessFile.readInt(); i > 0; --i) {
                String string = randomAccessFile.readUTF();
                if (string.equals(CODEBASEIP_HEADER_KEY)) {
                    this.setCodebaseIP(randomAccessFile.readUTF());
                    continue;
                }
                if (string.equals("<null>")) {
                    string = null;
                }
                this.headerFields.add(string, randomAccessFile.readUTF());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeaders(RandomAccessFile randomAccessFile) throws IOException {
        try {
            Map map = this.headerFields.getHeaders();
            if (!map.isEmpty()) {
                randomAccessFile.writeInt(map.size());
                for (int i = 0; i < map.size(); ++i) {
                    String string = this.headerFields.getKey(i);
                    if (null == string) {
                        string = "<null>";
                    }
                    randomAccessFile.writeUTF(string);
                    randomAccessFile.writeUTF(this.headerFields.getValue(i));
                }
            } else {
                randomAccessFile.writeInt(0);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    private String printManifest() {
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Attributes attributes = manifest.getMainAttributes();
            Iterator<Object> iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                stringBuffer.append("key: " + object);
                stringBuffer.append(" value: " + attributes.get(object) + "\n");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-----Cache Entry------\n");
        stringBuffer.append("busy: " + this.getBusy() + "\n");
        stringBuffer.append("incomplete: " + this.getIncomplete() + "\n");
        stringBuffer.append("cacheVersion: " + this.getCacheVersion() + "\n");
        stringBuffer.append("forceUpdate: " + this.getForceUpdate() + "\n");
        stringBuffer.append("noHref: " + this.getNoHref() + "\n");
        stringBuffer.append("contentLength: " + this.getContentLength() + "\n");
        long l = this.getLastModified();
        stringBuffer.append("lastModified: " + l + " [" + new Date(l).toString() + "]\n");
        stringBuffer.append("expirationDate: " + this.getExpirationDate() + "\n");
        stringBuffer.append("version: " + this.getVersion() + "\n");
        stringBuffer.append("URL: " + this.url + "\n");
        stringBuffer.append("NamespaceID: " + this.getNamespaceID() + "\n");
        stringBuffer.append("HTTP/HTTPS Header: " + this.getHeaders() + "\n");
        if (this.getManifest() != null) {
            stringBuffer.append("Jar-Manifest Main Attributes:\n");
            stringBuffer.append(this.printManifest());
            stringBuffer.append("----------------------\n");
        }
        return stringBuffer.toString();
    }
}

