/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.ActionsHandler;
import org.netbeans.lib.profiler.ui.memory.AllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;

public class LiveAllocResultsPanel
extends AllocResultsPanel
implements LiveResultsPanel,
ActionListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_GoSourcePopupItemName");
    private static final String SHOW_STACK_TRACES_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_LiveShowStackTracesPopupItemName");
    private static final String LOG_CLASS_HISTORY = messages.getString("LiveResultsPanel_LogClassHistory");
    protected TargetAppRunner runner;
    ActionsHandler handler;
    private JMenuItem popupShowStacks;
    private JMenuItem startHisto;
    private JPopupMenu memoryResPopupMenu;
    private ProfilingSessionStatus status;
    private boolean updateResultsInProgress = false;
    private boolean updateResultsPending = false;

    public LiveAllocResultsPanel(TargetAppRunner runner, MemoryResUserActionsHandler actionsHandler) {
        this(runner, actionsHandler, null);
    }

    public LiveAllocResultsPanel(TargetAppRunner runner, MemoryResUserActionsHandler actionsHandler, ActionsHandler handler) {
        super(actionsHandler);
        this.status = runner.getProfilerClient().getStatus();
        this.runner = runner;
        this.handler = handler;
    }

    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    public String getViewName() {
        return "memory-allocations-live";
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.popupShowStacks) {
            this.actionsHandler.showStacksForClass(this.selectedClassId, this.getSortingColumn(), this.getSortingOrder());
        } else if (e.getSource() == this.startHisto && this.handler != null) {
            this.handler.performAction("history logging", new Object[]{new Integer(this.selectedClassId), this.getClassName(this.selectedClassId), Boolean.FALSE});
        }
    }

    public void fetchResultsFromTargetApp() throws ClientUtils.TargetAppOrVMTerminated {
        MemoryCCTProvider oacgb = this.runner.getProfilerClient().getMemoryCCTProvider();
        if (oacgb == null) {
            throw new ClientUtils.TargetAppOrVMTerminated(1);
        }
        this.totalAllocObjectsSize = oacgb.getAllocObjectNumbers();
        this.nTotalAllocObjects = this.runner.getProfilerClient().getAllocatedObjectsCountResults();
        this.nTrackedItems = this.status.getNInstrClasses();
        if (this.nTrackedItems > this.nTotalAllocObjects.length) {
            this.nTrackedItems = this.nTotalAllocObjects.length;
        }
        if (this.nTrackedItems > this.totalAllocObjectsSize.length) {
            this.nTrackedItems = this.totalAllocObjectsSize.length;
        }
        this.maxValue = 0L;
        this.nTotalBytes = 0L;
        this.nTotalClasses = 0L;
        for (int i = 0; i < this.nTrackedItems; ++i) {
            if (this.maxValue < this.totalAllocObjectsSize[i]) {
                this.maxValue = this.totalAllocObjectsSize[i];
            }
            this.nTotalBytes += this.totalAllocObjectsSize[i];
            this.nTotalClasses += (long)this.nTotalAllocObjects[i];
        }
        if (this.handler != null) {
            this.handler.performAction("history update", new Object[]{this.nTotalAllocObjects, this.totalAllocObjectsSize});
        }
        this.initDataUponResultsFetch();
    }

    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    public void handleRemove() {
    }

    public void handleShutdown() {
        if (this.memoryResPopupMenu != null && this.memoryResPopupMenu.isVisible()) {
            this.updateResultsPending = false;
            this.memoryResPopupMenu.setVisible(false);
        }
    }

    public boolean hasView() {
        return this.resTable != null;
    }

    public boolean supports(int instrumentataionType) {
        return instrumentataionType == 4;
    }

    public void updateLiveResults() {
        if (this.memoryResPopupMenu != null && this.memoryResPopupMenu.isVisible()) {
            this.updateResultsPending = true;
            return;
        }
        if (this.updateResultsInProgress) {
            return;
        }
        this.updateResultsInProgress = true;
        String selectedRowString = null;
        if (this.resTable != null) {
            int selectedRowIndex = this.resTable.getSelectedRow();
            if (selectedRowIndex >= this.resTable.getRowCount()) {
                selectedRowIndex = -1;
                this.resTable.clearSelection();
            }
            if (selectedRowIndex != -1) {
                selectedRowString = this.resTable.getValueAt(selectedRowIndex, 0).toString();
            }
        }
        try {
            if (this.runner.getProfilingSessionStatus().targetAppRunning) {
                this.reset();
                this.fetchResultsFromTargetApp();
            }
            this.prepareResults();
            if (selectedRowString != null) {
                this.resTable.selectRowByContents(selectedRowString, 0, false);
            }
            if (this.resTable != null && this.resTable.isFocusOwner()) {
                this.resTable.requestFocusInWindow();
            }
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            targetAppOrVMTerminated.printStackTrace(System.err);
        }
        this.updateResultsInProgress = false;
    }

    protected String getClassName(int classId) {
        return this.status.getClassNames()[classId];
    }

    protected String[] getClassNames() {
        return this.status.getClassNames();
    }

    protected JPopupMenu getPopupMenu() {
        if (this.memoryResPopupMenu == null) {
            this.memoryResPopupMenu = new JPopupMenu();
            if (this.runner.getProfilerEngineSettings().getAllocStackTraceLimit() != 0) {
                this.memoryResPopupMenu.addSeparator();
                this.popupShowStacks = new JMenuItem();
                this.popupShowStacks.setText(SHOW_STACK_TRACES_POPUP_ITEM_NAME);
                this.memoryResPopupMenu.add(this.popupShowStacks);
                this.popupShowStacks.addActionListener(this);
            }
            this.memoryResPopupMenu.addSeparator();
            this.startHisto = new JMenuItem();
            this.startHisto.setText(LOG_CLASS_HISTORY);
            this.memoryResPopupMenu.add(this.startHisto);
            this.startHisto.addActionListener(this);
        }
        this.memoryResPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (LiveAllocResultsPanel.this.updateResultsPending) {
                            LiveAllocResultsPanel.this.updateLiveResults();
                            LiveAllocResultsPanel.this.updateResultsPending = false;
                        }
                    }
                });
            }
        });
        return this.memoryResPopupMenu;
    }
}

