/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChart;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.monitor.SurvivingGenerationsXYChartModel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryXYChartModel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryXYChartModelDataResetListener;

public class SurvivingGenerationsGraphPanel
extends GraphPanel
implements ChartModelListener,
VMTelemetryXYChartModelDataResetListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.graphs.Bundle");
    private static final String SURVGEN_CURRENT_STRING = messages.getString("SurvivingGenerationsGraphPanel_SurvGenCurrentString");
    private static final String SURVGEN_MAXIMUM_STRING = messages.getString("SurvivingGenerationsGraphPanel_SurvGenMaximumString");
    private static final String GC_TIME_CURRENT_STRING = messages.getString("SurvivingGenerationsGraphPanel_GcTimeCurrentString");
    private static final String GC_TIME_MAXIMUM_STRING = messages.getString("SurvivingGenerationsGraphPanel_GcTimeMaximumString");
    private static final String TIME_AT_CURSOR_STRING = messages.getString("SurvivingGenerationsGraphPanel_TimeAtCursorString");
    private static final String SURVGEN_AT_CURSOR_STRING = messages.getString("SurvivingGenerationsGraphPanel_SurvGenAtCursorString");
    private static final String GC_TIME_AT_CURSOR_STRING = messages.getString("SurvivingGenerationsGraphPanel_GcTimeAtCursorString");
    private static final String CHART_ACCESS_NAME = messages.getString("SurvivingGenerationsGraphPanel_ChartAccessName");
    private JPanel bigLegendPanel;
    private JPanel smallLegendPanel;
    private SurvivingGenerationsXYChartModel survivingGenerationsXYChartModel;
    private SynchronousXYChart xyChart;
    private boolean completeFunctionality;
    private int chartTimeLength = 180000;

    public SurvivingGenerationsGraphPanel(VMTelemetryXYChartModel survivingGenerationsXYChartModel, Action detailsAction) {
        this(false, null, survivingGenerationsXYChartModel, null);
    }

    public SurvivingGenerationsGraphPanel(boolean completeFunctionality, Color backgroundPaint, VMTelemetryXYChartModel survivingGenerationsXYChartModel, final Action detailsAction) {
        this.completeFunctionality = completeFunctionality;
        this.survivingGenerationsXYChartModel = (SurvivingGenerationsXYChartModel)survivingGenerationsXYChartModel;
        survivingGenerationsXYChartModel.addDataResetListener(this);
        this.setLayout(new BorderLayout());
        JLabel survivingGenerationsLabelBig = new JLabel(survivingGenerationsXYChartModel.getSeriesName(0), new ColorIcon(survivingGenerationsXYChartModel.getSeriesColor(0), Color.BLACK, 18, 9), 10);
        survivingGenerationsLabelBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JLabel relativeTimeGCBig = new JLabel(survivingGenerationsXYChartModel.getSeriesName(1), new ColorIcon(survivingGenerationsXYChartModel.getSeriesColor(1), Color.BLACK, 18, 9), 10);
        relativeTimeGCBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.bigLegendPanel = new JPanel();
        this.bigLegendPanel.add(survivingGenerationsLabelBig);
        this.bigLegendPanel.add(relativeTimeGCBig);
        JLabel survivingGenerationsLabelSmall = new JLabel(survivingGenerationsXYChartModel.getSeriesName(0), new ColorIcon(survivingGenerationsXYChartModel.getSeriesColor(0), null, 8, 8), 10);
        survivingGenerationsLabelSmall.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
        survivingGenerationsLabelSmall.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JLabel relativeTimeGCSmall = new JLabel(survivingGenerationsXYChartModel.getSeriesName(1), new ColorIcon(survivingGenerationsXYChartModel.getSeriesColor(1), null, 8, 8), 10);
        relativeTimeGCSmall.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
        relativeTimeGCSmall.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.smallLegendPanel = new JPanel();
        this.smallLegendPanel.setLayout(new FlowLayout(1, 0, 1));
        this.smallLegendPanel.setBackground(Color.WHITE);
        this.smallLegendPanel.setBorder(new LineBorder(new Color(235, 235, 235), 1));
        this.smallLegendPanel.add(survivingGenerationsLabelSmall);
        this.smallLegendPanel.add(relativeTimeGCSmall);
        this.xyChart = new SynchronousXYChart(1, 50, 0.01){

            public String getToolTipText(MouseEvent event) {
                return SurvivingGenerationsGraphPanel.this.getChartToolTipText(event);
            }
        };
        this.xyChart.setUseSecondaryVerticalAxis(true);
        long time = System.currentTimeMillis();
        this.xyChart.setupInitialAppearance(time, time + 1200L, 0L, 2L);
        this.getAccessibleContext().setAccessibleName(CHART_ACCESS_NAME);
        this.xyChart.setAccessibleContext(this.getAccessibleContext());
        if (completeFunctionality) {
            this.xyChart.setTopChartMargin(50);
            this.xyChart.allowSelection();
            this.xyChart.setMinimumVerticalMarksDistance(50);
        } else {
            this.xyChart.setTopChartMargin(20);
            this.xyChart.denySelection();
            this.xyChart.setMinimumVerticalMarksDistance(UIManager.getFont("Panel.font").getSize() + 8);
        }
        this.xyChart.setVerticalAxisValueDivider2(10);
        this.xyChart.setVerticalAxisValueString2("%");
        this.chartDataReset();
        if (backgroundPaint != null) {
            this.setOpaque(true);
            this.setBackground(backgroundPaint);
            this.xyChart.setBackgroundPaint(backgroundPaint);
        }
        this.xyChart.setModel(survivingGenerationsXYChartModel);
        if (!completeFunctionality) {
            survivingGenerationsXYChartModel.addChartModelListener(this);
        }
        this.add(this.xyChart);
        this.xyChart.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getModifiers() == 16 && e.getClickCount() == 2 && detailsAction != null) {
                    detailsAction.actionPerformed(null);
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.xyChart);
    }

    public JPanel getBigLegendPanel() {
        return this.bigLegendPanel;
    }

    public SynchronousXYChart getChart() {
        return this.xyChart;
    }

    public String getChartToolTipText(MouseEvent event) {
        if (this.survivingGenerationsXYChartModel.getItemCount() < 2) {
            return null;
        }
        StringBuffer toolTipBuffer = new StringBuffer();
        toolTipBuffer.append("<html>");
        if (!this.completeFunctionality || !this.xyChart.hasValidDataForPosition(event.getX(), event.getY())) {
            SurvivingGenerationsGraphPanel.appendToolTipItem(toolTipBuffer, SURVGEN_CURRENT_STRING, this.intFormat.format(this.survivingGenerationsXYChartModel.getYValue(this.survivingGenerationsXYChartModel.getItemCount() - 1, 0)), false);
            SurvivingGenerationsGraphPanel.appendToolTipItem(toolTipBuffer, SURVGEN_MAXIMUM_STRING, this.intFormat.format(this.survivingGenerationsXYChartModel.getMaxYValue(0)), false);
            SurvivingGenerationsGraphPanel.appendToolTipItem(toolTipBuffer, GC_TIME_CURRENT_STRING, this.percentFormat.format((float)this.survivingGenerationsXYChartModel.getYValue(this.survivingGenerationsXYChartModel.getItemCount() - 1, 1) / 1000.0f), false);
            SurvivingGenerationsGraphPanel.appendToolTipItem(toolTipBuffer, GC_TIME_MAXIMUM_STRING, this.percentFormat.format((float)this.survivingGenerationsXYChartModel.getMaxYValue(1) / 1000.0f), true);
        } else {
            SurvivingGenerationsGraphPanel.appendToolTipItem(toolTipBuffer, SURVGEN_CURRENT_STRING, this.intFormat.format(this.survivingGenerationsXYChartModel.getYValue(this.survivingGenerationsXYChartModel.getItemCount() - 1, 0)), false);
            SurvivingGenerationsGraphPanel.appendToolTipItem(toolTipBuffer, SURVGEN_MAXIMUM_STRING, this.intFormat.format(this.survivingGenerationsXYChartModel.getMaxYValue(0)), false);
            SurvivingGenerationsGraphPanel.appendToolTipItem(toolTipBuffer, GC_TIME_CURRENT_STRING, this.percentFormat.format((float)this.survivingGenerationsXYChartModel.getYValue(this.survivingGenerationsXYChartModel.getItemCount() - 1, 1) / 1000.0f), false);
            SurvivingGenerationsGraphPanel.appendToolTipItem(toolTipBuffer, GC_TIME_MAXIMUM_STRING, this.percentFormat.format((float)this.survivingGenerationsXYChartModel.getMaxYValue(1) / 1000.0f), false);
            toolTipBuffer.append("<br>");
            SurvivingGenerationsGraphPanel.appendToolTipItem(toolTipBuffer, TIME_AT_CURSOR_STRING, this.xyChart.getTimeAtPosition(event.getX()), false);
            SurvivingGenerationsGraphPanel.appendToolTipItem(toolTipBuffer, SURVGEN_AT_CURSOR_STRING, this.intFormat.format(this.xyChart.getYValueAtPosition(event.getX(), 0)), false);
            SurvivingGenerationsGraphPanel.appendToolTipItem(toolTipBuffer, GC_TIME_AT_CURSOR_STRING, this.percentFormat.format((float)this.xyChart.getYValueAtPosition(event.getX(), 1) / 1000.0f), true);
        }
        toolTipBuffer.append("</html>");
        return toolTipBuffer.toString();
    }

    public JPanel getSmallLegendPanel() {
        return this.smallLegendPanel;
    }

    public void chartDataChanged() {
        if (!this.completeFunctionality && this.xyChart.isFitToWindow() && this.survivingGenerationsXYChartModel.getMaxXValue() - this.survivingGenerationsXYChartModel.getMinXValue() >= (long)this.chartTimeLength) {
            UIUtils.runInEventDispatchThread(new Runnable(){

                public void run() {
                    SurvivingGenerationsGraphPanel.this.xyChart.setTrackingEnd();
                }
            });
        }
    }

    public void chartDataReset() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            public void run() {
                SurvivingGenerationsGraphPanel.this.xyChart.resetChart();
                if (SurvivingGenerationsGraphPanel.this.completeFunctionality) {
                    SurvivingGenerationsGraphPanel.this.xyChart.resetTrackingEnd();
                    SurvivingGenerationsGraphPanel.this.xyChart.resetFitToWindow();
                } else {
                    SurvivingGenerationsGraphPanel.this.xyChart.setFitToWindow();
                }
            }
        });
    }

    private static void appendToolTipItem(StringBuffer toolTipBuffer, String itemName, String itemValue, boolean lastItem) {
        toolTipBuffer.append("&nbsp;<b>");
        toolTipBuffer.append(itemName);
        toolTipBuffer.append("</b>: ");
        toolTipBuffer.append(itemValue);
        toolTipBuffer.append("&nbsp;");
        if (!lastItem) {
            toolTipBuffer.append("<br>");
        }
    }
}

