/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChart;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryXYChartModel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryXYChartModelDataResetListener;

public class MemoryGraphPanel
extends GraphPanel
implements ChartModelListener,
VMTelemetryXYChartModelDataResetListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.graphs.Bundle");
    private static final String TOTAL_MEMORY_CURRENT_STRING = messages.getString("MemoryGraphPanel_TotalMemoryCurrentString");
    private static final String USED_MEMORY_CURRENT_STRING = messages.getString("MemoryGraphPanel_UsedMemoryCurrentString");
    private static final String USED_MEMORY_MAXIMUM_STRING = messages.getString("MemoryGraphPanel_UsedMemoryMaximumString");
    private static final String TIME_AT_CURSOR_STRING = messages.getString("MemoryGraphPanel_TimeAtCursorString");
    private static final String TOTAL_MEMORY_AT_CURSOR_STRING = messages.getString("MemoryGraphPanel_TotalMemoryAtCursorString");
    private static final String USED_MEMORY_AT_CURSOR_STRING = messages.getString("MemoryGraphPanel_UsedMemoryAtCursorString");
    private static final String CHART_ACCESS_NAME = messages.getString("MemoryGraphPanel_ChartAccessName");
    private JPanel bigLegendPanel;
    private JPanel smallLegendPanel;
    private SynchronousXYChart xyChart;
    private VMTelemetryXYChartModel memoryXYChartModel;
    private boolean completeFunctionality;
    private int chartTimeLength = 180000;

    public MemoryGraphPanel(VMTelemetryXYChartModel memoryXYChartModel, Action detailsAction) {
        this(false, null, memoryXYChartModel, detailsAction);
    }

    public MemoryGraphPanel(boolean completeFunctionality, Color backgroundPaint, VMTelemetryXYChartModel memoryXYChartModel, final Action detailsAction) {
        this.completeFunctionality = completeFunctionality;
        this.memoryXYChartModel = memoryXYChartModel;
        memoryXYChartModel.addDataResetListener(this);
        this.setLayout(new BorderLayout());
        JLabel heapSizeBig = new JLabel(memoryXYChartModel.getSeriesName(0), new ColorIcon(memoryXYChartModel.getSeriesColor(0), Color.BLACK, 18, 9), 10);
        heapSizeBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JLabel usedHeapBig = new JLabel(memoryXYChartModel.getSeriesName(1), new ColorIcon(memoryXYChartModel.getSeriesColor(1), Color.BLACK, 18, 9), 10);
        usedHeapBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.bigLegendPanel = new JPanel();
        this.bigLegendPanel.add(heapSizeBig);
        this.bigLegendPanel.add(usedHeapBig);
        JLabel heapSizeSmall = new JLabel(memoryXYChartModel.getSeriesName(0), new ColorIcon(memoryXYChartModel.getSeriesColor(0), null, 8, 8), 10);
        heapSizeSmall.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
        heapSizeSmall.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JLabel usedHeapSmall = new JLabel(memoryXYChartModel.getSeriesName(1), new ColorIcon(memoryXYChartModel.getSeriesColor(1), null, 8, 8), 10);
        usedHeapSmall.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
        usedHeapSmall.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.smallLegendPanel = new JPanel();
        this.smallLegendPanel.setLayout(new FlowLayout(1, 0, 1));
        this.smallLegendPanel.setBackground(Color.WHITE);
        this.smallLegendPanel.setBorder(new LineBorder(new Color(235, 235, 235), 1));
        this.smallLegendPanel.add(heapSizeSmall);
        this.smallLegendPanel.add(usedHeapSmall);
        this.xyChart = new SynchronousXYChart(2, 50, 0.01){

            public String getToolTipText(MouseEvent event) {
                return MemoryGraphPanel.this.getChartToolTipText(event);
            }
        };
        if (completeFunctionality) {
            this.xyChart.setTopChartMargin(50);
            this.xyChart.allowSelection();
            this.xyChart.setMinimumVerticalMarksDistance(50);
        } else {
            this.xyChart.setTopChartMargin(20);
            this.xyChart.denySelection();
            this.xyChart.setMinimumVerticalMarksDistance(UIManager.getFont("Panel.font").getSize() + 8);
        }
        this.xyChart.setVerticalAxisValueDivider(0x100000);
        this.xyChart.setVerticalAxisValueString("M");
        long time = System.currentTimeMillis();
        this.xyChart.setupInitialAppearance(time, time + 1200L, 0L, 2L);
        this.getAccessibleContext().setAccessibleName(CHART_ACCESS_NAME);
        this.xyChart.setAccessibleContext(this.getAccessibleContext());
        this.chartDataReset();
        if (backgroundPaint != null) {
            this.setOpaque(true);
            this.setBackground(backgroundPaint);
            this.xyChart.setBackgroundPaint(backgroundPaint);
        }
        this.xyChart.setModel(memoryXYChartModel);
        if (!completeFunctionality) {
            memoryXYChartModel.addChartModelListener(this);
        }
        this.add(this.xyChart);
        this.xyChart.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getModifiers() == 16 && e.getClickCount() == 2 && detailsAction != null) {
                    detailsAction.actionPerformed(null);
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.xyChart);
    }

    public JPanel getBigLegendPanel() {
        return this.bigLegendPanel;
    }

    public SynchronousXYChart getChart() {
        return this.xyChart;
    }

    public String getChartToolTipText(MouseEvent event) {
        if (this.memoryXYChartModel.getItemCount() < 2) {
            return null;
        }
        StringBuffer toolTipBuffer = new StringBuffer();
        toolTipBuffer.append("<html>");
        if (!this.completeFunctionality || !this.xyChart.hasValidDataForPosition(event.getX(), event.getY())) {
            MemoryGraphPanel.appendToolTipItem(toolTipBuffer, TOTAL_MEMORY_CURRENT_STRING, this.intFormat.format(this.memoryXYChartModel.getYValue(this.memoryXYChartModel.getItemCount() - 1, 0)) + " B", false);
            MemoryGraphPanel.appendToolTipItem(toolTipBuffer, USED_MEMORY_CURRENT_STRING, this.intFormat.format(this.memoryXYChartModel.getYValue(this.memoryXYChartModel.getItemCount() - 1, 1)) + " B", false);
            MemoryGraphPanel.appendToolTipItem(toolTipBuffer, USED_MEMORY_MAXIMUM_STRING, this.intFormat.format(this.memoryXYChartModel.getMaxYValue(1)) + " B", true);
        } else {
            MemoryGraphPanel.appendToolTipItem(toolTipBuffer, TOTAL_MEMORY_CURRENT_STRING, this.intFormat.format(this.memoryXYChartModel.getYValue(this.memoryXYChartModel.getItemCount() - 1, 0)) + " B", false);
            MemoryGraphPanel.appendToolTipItem(toolTipBuffer, USED_MEMORY_CURRENT_STRING, this.intFormat.format(this.memoryXYChartModel.getYValue(this.memoryXYChartModel.getItemCount() - 1, 1)) + " B", false);
            MemoryGraphPanel.appendToolTipItem(toolTipBuffer, USED_MEMORY_MAXIMUM_STRING, this.intFormat.format(this.memoryXYChartModel.getMaxYValue(1)) + " B", false);
            toolTipBuffer.append("<br>");
            MemoryGraphPanel.appendToolTipItem(toolTipBuffer, TIME_AT_CURSOR_STRING, this.xyChart.getTimeAtPosition(event.getX()), false);
            MemoryGraphPanel.appendToolTipItem(toolTipBuffer, TOTAL_MEMORY_AT_CURSOR_STRING, this.intFormat.format(this.xyChart.getYValueAtPosition(event.getX(), 0)) + " B", false);
            MemoryGraphPanel.appendToolTipItem(toolTipBuffer, USED_MEMORY_AT_CURSOR_STRING, this.intFormat.format(this.xyChart.getYValueAtPosition(event.getX(), 1)) + " B", true);
        }
        toolTipBuffer.append("</html>");
        return toolTipBuffer.toString();
    }

    public JPanel getSmallLegendPanel() {
        return this.smallLegendPanel;
    }

    public void chartDataChanged() {
        if (!this.completeFunctionality && this.xyChart.isFitToWindow() && this.memoryXYChartModel.getMaxXValue() - this.memoryXYChartModel.getMinXValue() >= (long)this.chartTimeLength) {
            UIUtils.runInEventDispatchThread(new Runnable(){

                public void run() {
                    MemoryGraphPanel.this.xyChart.setTrackingEnd();
                }
            });
        }
    }

    public void chartDataReset() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            public void run() {
                MemoryGraphPanel.this.xyChart.resetChart();
                if (MemoryGraphPanel.this.completeFunctionality) {
                    MemoryGraphPanel.this.xyChart.resetTrackingEnd();
                    MemoryGraphPanel.this.xyChart.resetFitToWindow();
                } else {
                    MemoryGraphPanel.this.xyChart.setFitToWindow();
                }
            }
        });
    }

    private static void appendToolTipItem(StringBuffer toolTipBuffer, String itemName, String itemValue, boolean lastItem) {
        toolTipBuffer.append("&nbsp;<b>");
        toolTipBuffer.append(itemName);
        toolTipBuffer.append("</b>: ");
        toolTipBuffer.append(itemValue);
        toolTipBuffer.append("&nbsp;");
        if (!lastItem) {
            toolTipBuffer.append("<br>");
        }
    }
}

