/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.table;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;

public class DiffBarCellRenderer
extends CustomBarCellRenderer {
    public static final Color BAR_FOREGROUND2_COLOR = new Color(41, 195, 41);

    public DiffBarCellRenderer(long min, long max) {
        super(min, max);
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Insets insets = this.getInsets();
        int clientWidth = this.getWidth() - insets.right - insets.left;
        int horizCenter = insets.left + clientWidth / 2;
        int barExtent = (int)Math.ceil(Math.abs(this.relValue) * (double)clientWidth / 2.0);
        if (this.relValue > 0.0) {
            g.setColor(BAR_FOREGROUND_COLOR);
            g.fillRect(horizCenter, insets.top, barExtent, this.getHeight() - insets.bottom - insets.top);
        } else if (this.relValue < 0.0) {
            g.setColor(BAR_FOREGROUND2_COLOR);
            g.fillRect(horizCenter - barExtent, insets.top, barExtent, this.getHeight() - insets.bottom - insets.top);
        }
    }

    protected double calculateViewValue(long n) {
        long absMax = Math.max(Math.abs(this.min), this.max);
        return (double)n / (double)absMax;
    }

    protected double calculateViewValue(double n) {
        long absMax = Math.max(Math.abs(this.min), this.max);
        return n / (double)absMax;
    }
}

