/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.masterfs.APIAccess;
import org.netbeans.modules.masterfs.Cache;
import org.netbeans.modules.masterfs.ExLocalFileSystem;
import org.netbeans.modules.masterfs.InternalMountSupport;
import org.netbeans.modules.masterfs.MasterFileObject;
import org.netbeans.modules.masterfs.MasterFileSystem;
import org.netbeans.modules.masterfs.ResourcePath;
import org.netbeans.modules.masterfs.SyncSection;
import org.netbeans.modules.masterfs.Utils;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockUtils;
import org.netbeans.modules.masterfs.providers.MountSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;

final class MountTable
implements InternalMountSupport {
    private static final Map res2fsMap = Collections.synchronizedMap(new HashMap());
    private static final MountTable instance = new MountTable();
    static final MountSupport mountSupport = APIAccess.DEFAULT.createMountSupport(instance);

    static MountTable getDefault() {
        return instance;
    }

    private MountTable() {
    }

    public void mount(final String string, final FileSystem fileSystem) throws IOException {
        final boolean bl = !(fileSystem instanceof ExLocalFileSystem);
        final String string2 = ResourcePath.getNormalizedPath(string);
        MasterFileSystem.getDefault().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                if (bl) {
                    SyncSection.getDefault().enterExclusiveSection();
                    try {
                        MountTable.this.mountIt(string2, fileSystem, string);
                    }
                    finally {
                        SyncSection.getDefault().finishExclusiveSection();
                    }
                } else {
                    MountTable.this.mountIt(string2, fileSystem, string);
                }
            }
        });
        fileSystem.addFileStatusListener((FileStatusListener)MasterFileSystem.getDefault());
        fileSystem.addNotify();
    }

    private void mountIt(String string, FileSystem fileSystem, String string2) throws IOException {
        FileSystem fileSystem2 = res2fsMap.put(string, fileSystem);
        if (fileSystem2 != null) {
            this.handleAlreadyMounted(fileSystem2, fileSystem, string);
        } else {
            MountTable.refreshAfterMount(this.getMountEnumeration(string2));
        }
    }

    public void unmount(final FileSystem fileSystem) throws IOException {
        MasterFileSystem.getDefault().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                SyncSection.getDefault().enterExclusiveSection();
                try {
                    if (!MountTable.this.removeFileSystem(fileSystem)) {
                        String string = Utils.formatString("EXC_CannotUnMount", new Object[]{fileSystem.getDisplayName()});
                        throw new IOException(string);
                    }
                }
                finally {
                    SyncSection.getDefault().finishExclusiveSection();
                }
            }
        });
        fileSystem.removeFileStatusListener((FileStatusListener)MasterFileSystem.getDefault());
        fileSystem.removeNotify();
    }

    FileObject resolveBestDelegate(String string) {
        return this.resolveDelegate(string, 0);
    }

    FileObject resolveSecondDelegate(String string) {
        return this.resolveDelegate(string, 1);
    }

    void unmount(String string) throws IOException {
        FileSystem fileSystem = this.getMountedFileSystem(string);
        if (fileSystem != null) {
            MountTable.getDefault().unmount(fileSystem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration geAllFileSystems() {
        ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>();
        Collection collection = res2fsMap.values();
        SyncSection.getDefault().enterSection();
        try {
            Map map = res2fsMap;
            synchronized (map) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    FileSystem fileSystem = (FileSystem)iterator.next();
                    if (fileSystem == null) continue;
                    arrayList.add(fileSystem);
                }
            }
        }
        finally {
            SyncSection.getDefault().finishSection();
        }
        return Collections.enumeration(arrayList);
    }

    boolean isMounted(FileSystem fileSystem) {
        ResourcePath resourcePath = this.findResourcePath(fileSystem);
        FileSystem fileSystem2 = (FileSystem)res2fsMap.get(resourcePath.getNormalizedPath());
        return fileSystem == fileSystem2;
    }

    private ResourcePath findResourcePath(FileSystem fileSystem) {
        File file = FileUtil.toFile((FileObject)fileSystem.getRoot());
        return Utils.getResource(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject resolveDelegate(String string, int n) {
        FileSystem fileSystem;
        Serializable serializable;
        Object object;
        String string2 = "";
        LinkedList<String> linkedList = new LinkedList<String>();
        if (WriteLockUtils.hasActiveLockFileSigns(string = ResourcePath.getNormalizedPath(string)) && WriteLockUtils.hasActiveLockFileSigns(((File)(object = new ResourcePath(string).getFile())).getAbsolutePath())) {
            return null;
        }
        object = res2fsMap;
        synchronized (object) {
            serializable = new ArrayList(res2fsMap.keySet());
            Collections.sort(serializable);
            Iterator iterator = serializable.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                String string3 = (String)iterator.next();
                if (!string.startsWith(string3) || string3.length() <= string2.length()) continue;
                boolean bl2 = bl = string3.length() == string.length() || string.charAt(string3.length()) == '/';
                if (!bl && !new ResourcePath(string3).isRoot()) continue;
                string2 = string3;
                linkedList.addLast(string2);
            }
            if (linkedList.size() == 0) {
                return null;
            }
            int n2 = linkedList.size() - (n + 1);
            if (n2 < 0) {
                n2 = 0;
            }
            string2 = (String)linkedList.get(n2);
            fileSystem = (FileSystem)res2fsMap.get(string2);
        }
        if (fileSystem instanceof FileBasedFileSystem) {
            serializable = new ResourcePath(string).getFile();
            object = fileSystem.findResource(((File)serializable).getAbsolutePath());
        } else {
            object = fileSystem.findResource(string.substring(string2.length()));
        }
        return object;
    }

    private static void refreshAfterMount(Enumeration enumeration) {
        Object object;
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        while (enumeration.hasMoreElements()) {
            object = (MasterFileObject)((Object)enumeration.nextElement());
            MountTable.refreshAfterMount((MasterFileObject)((Object)object));
            linkedHashSet.add(object);
        }
        MountTable.resetAfterMount(linkedHashSet);
        object = MasterFileSystem.getDefault();
        ((MasterFileSystem)((Object)object)).fireFileStatus(new FileStatusEvent((FileSystem)object, linkedHashSet, true, true));
    }

    static void refreshAfterMount(MasterFileObject masterFileObject) {
        FileObject fileObject = masterFileObject.getDelegate().get();
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = MountTable.getDefault().resolveBestDelegate(masterFileObject.getResource().getNormalizedPath());
        if (fileObject == fileObject2) {
            return;
        }
        MasterFileObject.refreshAfterMount(fileObject2, fileObject, masterFileObject);
    }

    private static void resetAfterMount(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            MasterFileObject masterFileObject = (MasterFileObject)((Object)iterator.next());
            masterFileObject.getDelegate().reset(masterFileObject.getResource());
        }
    }

    static void renameCachedFileObjects(String string, String string2) {
        Enumeration enumeration = Cache.getDefault().getAll();
        while (enumeration.hasMoreElements()) {
            MasterFileObject masterFileObject = (MasterFileObject)((Object)enumeration.nextElement());
            String string3 = masterFileObject.getResource().getNormalizedPath();
            if (string3.startsWith(string2) || !string3.startsWith(string)) continue;
            ResourcePath resourcePath = new ResourcePath(string2 + string3.substring(string.length()));
            masterFileObject.setResource(resourcePath);
            Cache.getDefault().replace(string3, masterFileObject);
        }
    }

    private Enumeration getMountEnumeration(String string) {
        class Mnt
        implements Enumerations.Processor {
            private final /* synthetic */ String val$mountPointPath;

            Mnt(String string) {
                this.val$mountPointPath = string;
            }

            public Object process(Object object, Collection collection) {
                MasterFileObject masterFileObject = (MasterFileObject)((Object)object);
                String string = ResourcePath.getNormalizedPath(this.val$mountPointPath);
                String string2 = masterFileObject.getResource().getNormalizedPath();
                if (string2.startsWith(string) && masterFileObject.isValid()) {
                    return object;
                }
                return null;
            }
        }
        return Enumerations.filter((Enumeration)Cache.getDefault().getAll(), (Enumerations.Processor)new Mnt(string));
    }

    private static Enumeration getUnMountEnumeration(FileSystem fileSystem) {
        class UnMnt
        implements Enumerations.Processor {
            private final /* synthetic */ FileSystem val$fs2Umount;

            UnMnt(FileSystem fileSystem) {
                this.val$fs2Umount = fileSystem;
            }

            public Object process(Object object, Collection collection) {
                FileSystem fileSystem;
                MasterFileObject masterFileObject = (MasterFileObject)((Object)object);
                if (masterFileObject != null && masterFileObject.isValid() && (fileSystem = masterFileObject.getDelegateFileSystem()) == this.val$fs2Umount) {
                    return object;
                }
                return null;
            }
        }
        return Enumerations.filter((Enumeration)Cache.getDefault().getAll(), (Enumerations.Processor)new UnMnt(fileSystem));
    }

    FileSystem getMountedFileSystem(String string) {
        string = ResourcePath.getNormalizedPath(string);
        FileSystem fileSystem = (FileSystem)res2fsMap.get(string);
        return fileSystem;
    }

    private void handleAlreadyMounted(FileSystem fileSystem, FileSystem fileSystem2, String string) throws IOException {
        res2fsMap.put(string, fileSystem);
    }

    private boolean removeFileSystem(FileSystem fileSystem) {
        Iterator iterator = res2fsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            FileSystem fileSystem2 = (FileSystem)entry.getValue();
            if (fileSystem2 != fileSystem) continue;
            iterator.remove();
            MountTable.refreshAfterMount(MountTable.getUnMountEnumeration(fileSystem));
            return true;
        }
        return false;
    }
}

